/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.connection.statements.BitBoolOutParam;
import com.intellij.database.dataSource.connection.statements.ByteOutParam;
import com.intellij.database.dataSource.connection.statements.IntOutParam;
import com.intellij.database.dataSource.connection.statements.ShortOutParam;
import com.intellij.database.dataSource.connection.statements.StringOutParam;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.CallParams;
import com.intellij.database.dialects.oracle.debugger.OraStringArrayOutParameter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001c\b \u0018\u00002\u00020\u0001:\u000f\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries;", "", "<init>", "()V", "retrieveDbmsOutputPortionSize", "", "getRetrieveDbmsOutputPortionSize$intellij_database_dialects_oracle_ex", "()I", "retrieveDbmsOutputBlock", "", "getRetrieveDbmsOutputBlock$intellij_database_dialects_oracle_ex", "()Ljava/lang/String;", "deregisterAllBreakpointsStatement", "getDeregisterAllBreakpointsStatement$intellij_database_dialects_oracle_ex", "peekVariablesTemplate", "getPeekVariablesTemplate$intellij_database_dialects_oracle_ex", "evaluateScalarExpressionFragment", "getEvaluateScalarExpressionFragment$intellij_database_dialects_oracle_ex", "evaluateScalarExpressionFragmentBoolean", "getEvaluateScalarExpressionFragmentBoolean$intellij_database_dialects_oracle_ex", "executeFragmentTemplate", "getExecuteFragmentTemplate$intellij_database_dialects_oracle_ex", "CheckSessionActivityProc", "AttachProc", "SynchronizeProc", "ContinueProc", "StepOutProc", "SyncLikeProc", "GracefulResumeProc", "PrintBacktraceProc", "ObtainBacktraceProc", "RegisterScriptLineBreakpointBlock", "RegisterProgramLineBreakpointBlock", "DeregisterLineBreakpointBlock", "PeekVariable", "EvaluateScalarExpression", "ExecuteFragmentStatement", "intellij.database.dialects.oracle.ex"})
public abstract class OraDebuggingSessionQueries {
    private final int retrieveDbmsOutputPortionSize;
    @NotNull
    private final String retrieveDbmsOutputBlock;
    @NotNull
    private final String deregisterAllBreakpointsStatement;
    @NotNull
    private final String peekVariablesTemplate;
    @NotNull
    private final String evaluateScalarExpressionFragment;
    @NotNull
    private final String evaluateScalarExpressionFragmentBoolean;
    @NotNull
    private final String executeFragmentTemplate;

    public OraDebuggingSessionQueries() {
        this.retrieveDbmsOutputPortionSize = 256;
        this.retrieveDbmsOutputBlock = StringsKt.trimMargin$default((String)("|declare                                                      \n       |    lines sys.dbmsoutput_linesarray;                          \n       |    pp    sys.dbms_debug_vc2coll := sys.dbms_debug_vc2coll(); \n       |    cnt   integer := " + this.retrieveDbmsOutputPortionSize + ";                                     \n       |begin                                                         \n       |    dbms_output.get_lines(lines, cnt);                        \n       |    pp.extend(cnt);                                           \n       |    for i in 1 .. cnt                                         \n       |        loop                                                  \n       |            pp(i) := lines(i);                                \n       |        end loop;                                             \n       |    :1 := pp;                                               \n       |end;                                                          \n    "), null, (int)1, null);
        this.deregisterAllBreakpointsStatement = "declare\n    bps sys.dbms_debug.breakpoint_table;\n    ind binary_integer;\n    ret binary_integer;\nbegin\n    sys.dbms_debug.show_breakpoints(listing => bps);\n    ind := bps.first;\n    while ind is not null\n        loop\n            ret := sys.dbms_debug.delete_breakpoint(ind);\n            ind := bps.next(ind);\n        end loop;\nend;";
        this.peekVariablesTemplate = "declare\n    function getFieldValue(prg_schema_ string, prg_name_ string, field_name_ string) return string is\n            prg sys.dbms_debug.program_info;\n            val varchar(32000);\n            r binary_integer;\n        begin\n            prg.namespace := 1;\n            prg.owner := prg_schema_;\n            prg.name := prg_name_;\n            r := sys.dbms_debug.get_value(field_name_, prg, val);\n            if r = 0 then return val;\n            elsif r = 32 or r = 40 then return chr(26);\n            elsif r = 18 then return 'indexed array';\n            else return chr(27)||'error #'||r;\n            end if; \n        exception when others then\n            return 'error ' || sqlerrm;\n        end;\n    function getVarValue(frame_level_ binary_integer, var_name_ string) return string is\n            val varchar(32000);\n            r binary_integer;\n        begin\n            r := sys.dbms_debug.get_value(var_name_, frame_level_, val);\n            if r = 0 then return val;\n            elsif r = 32 or r = 40 then return chr(26);\n            elsif r = 18 then return 'indexed array';\n            else return chr(27)||'error #'||r;\n            end if; \n        exception when others then\n            return 'error ' || sqlerrm;\n        end;\nbegin\n@\nend;";
        this.evaluateScalarExpressionFragment = "declare                                                      \n    pp sys.dbms_debug_vc2coll := sys.dbms_debug_vc2coll(); \nbegin                                                         \n    pp.extend(1);   \n    pp(1) := ( \n                 @ \n             );                                        \n    :1 := pp;                                               \nend;                                                          ";
        this.evaluateScalarExpressionFragmentBoolean = "declare                                                      \n    b boolean := null; \n    pp sys.dbms_debug_vc2coll := sys.dbms_debug_vc2coll(); \nbegin                                                         \n    b := ( \n                 @ \n         );                                        \n    pp.extend(1);   \n    pp(1) := case when b = true then 'true' when b = false then 'false' else null end;\n    :1 := pp;                                               \nend;                                                          ";
        this.executeFragmentTemplate = "begin          \n    --                                           \n    @                                           \n    --                                           \nend;                                                          ";
    }

    public final int getRetrieveDbmsOutputPortionSize$intellij_database_dialects_oracle_ex() {
        return this.retrieveDbmsOutputPortionSize;
    }

    @NotNull
    public final String getRetrieveDbmsOutputBlock$intellij_database_dialects_oracle_ex() {
        return this.retrieveDbmsOutputBlock;
    }

    @NotNull
    public final String getDeregisterAllBreakpointsStatement$intellij_database_dialects_oracle_ex() {
        return this.deregisterAllBreakpointsStatement;
    }

    @NotNull
    public final String getPeekVariablesTemplate$intellij_database_dialects_oracle_ex() {
        return this.peekVariablesTemplate;
    }

    @NotNull
    public final String getEvaluateScalarExpressionFragment$intellij_database_dialects_oracle_ex() {
        return this.evaluateScalarExpressionFragment;
    }

    @NotNull
    public final String getEvaluateScalarExpressionFragmentBoolean$intellij_database_dialects_oracle_ex() {
        return this.evaluateScalarExpressionFragmentBoolean;
    }

    @NotNull
    public final String getExecuteFragmentTemplate$intellij_database_dialects_oracle_ex() {
        return this.executeFragmentTemplate;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$AttachProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "versionMajor", "Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "getVersionMajor", "()Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "versionMinor", "getVersionMinor", "intellij.database.dialects.oracle.ex"})
    public static final class AttachProc
    extends CallDefinition {
        @NotNull
        public static final AttachProc INSTANCE = new AttachProc();
        @NotNull
        private static final IntOutParam versionMajor = INSTANCE.registerInt(2, 0);
        @NotNull
        private static final IntOutParam versionMinor = INSTANCE.registerInt(3, 0);

        private AttachProc() {
            super("declare\n    dummy_value binary_integer;\n    ver_major   binary_integer;\n    ver_minor   binary_integer;\nbegin\n    sys.dbms_debug.attach_session(?);\n    sys.dbms_debug.probe_version(ver_major, ver_minor);\n    dummy_value := sys.dbms_debug.set_timeout(1);\n    sys.dbms_debug.set_timeout_behaviour(sys.dbms_debug.continue_on_timeout);\n    ? := ver_major;\n    ? := ver_minor;\nend;    ");
        }

        @NotNull
        public final IntOutParam getVersionMajor() {
            return versionMajor;
        }

        @NotNull
        public final IntOutParam getVersionMinor() {
            return versionMinor;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$CheckSessionActivityProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "status", "Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "getStatus", "()Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "intellij.database.dialects.oracle.ex"})
    public static final class CheckSessionActivityProc
    extends CallDefinition {
        @NotNull
        public static final CheckSessionActivityProc INSTANCE = new CheckSessionActivityProc();
        @NotNull
        private static final StringOutParam status = CallParams.registerString$default(INSTANCE, 2, 15, null, 4, null);

        private CheckSessionActivityProc() {
            super(StringsKt.replace$default((String)"declare \n    theStatus varchar(15) := null;\nbegin\n    select min(status)\n        into theStatus\n        from sys.v_\u00a7session\n        where audsid = ?;\n    ? := theStatus;\nend;", (char)'\u00a7', (char)'$', (boolean)false, (int)4, null));
        }

        @NotNull
        public final StringOutParam getStatus() {
            return status;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$ContinueProc;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;", "<init>", "()V", "intellij.database.dialects.oracle.ex"})
    public static final class ContinueProc
    extends SyncLikeProc {
        @NotNull
        public static final ContinueProc INSTANCE = new ContinueProc();

        private ContinueProc() {
            super("declare\n    breaks binary_integer := ?;\n    ri     sys.dbms_debug.runtime_info;\n    proc   binary_integer := 0;\nbegin\n    ? := sys.dbms_debug.continue(ri, breaks, 14);\n    ? := ri.Reason;\n    ? := ri.Line#;\n    ? := ri.Breakpoint;\n    ? := ri.StackDepth;\n    ? := ri.program.Namespace;\n    ? := ri.program.Owner;\n    ? := ri.program.Name;\n    ? := ri.program.EntryPointName;\n    ? := ri.Terminated;\n    if (sys.dbms_debug.target_program_running) then proc := 1; end if;\n    ? := proc;\nend;", 1);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$DeregisterLineBreakpointBlock;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "result", "Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "getResult", "()Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "intellij.database.dialects.oracle.ex"})
    public static final class DeregisterLineBreakpointBlock
    extends CallDefinition {
        @NotNull
        public static final DeregisterLineBreakpointBlock INSTANCE = new DeregisterLineBreakpointBlock();
        @NotNull
        private static final IntOutParam result = INSTANCE.registerInt(2, -1);

        private DeregisterLineBreakpointBlock() {
            super("declare\n    r  binary_integer;\nbegin\n    r := sys.dbms_debug.delete_breakpoint(?);\n    ? := r;\nend;");
        }

        @NotNull
        public final IntOutParam getResult() {
            return result;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$EvaluateScalarExpression;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "error", "Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "getError", "()Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "value", "getValue", "intellij.database.dialects.oracle.ex"})
    public static final class EvaluateScalarExpression
    extends CallDefinition {
        @NotNull
        public static final EvaluateScalarExpression INSTANCE = new EvaluateScalarExpression();
        @NotNull
        private static final StringOutParam error = CallParams.registerString$default(INSTANCE, 2, 1000, null, 4, null);
        @NotNull
        private static final StringOutParam value = CallParams.registerString$default(INSTANCE, 3, 1000, null, 4, null);

        private EvaluateScalarExpression() {
            super("declare\n    block  varchar(4000)          := ?; \n    pp     sys.dbms_debug_vc2coll := null;\n    err    varchar(1000)          := null;\n    value  varchar(1000)          := null;\nbegin\n    sys.dbms_debug.execute(block, frame# => -1, bind_results => 1, results => pp, errm => err);\n    if err is null then value := pp(1); end if;\n    ? := err;\n    ? := value;\nend;");
        }

        @NotNull
        public final StringOutParam getError() {
            return error;
        }

        @NotNull
        public final StringOutParam getValue() {
            return value;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$ExecuteFragmentStatement;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "error", "Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "getError", "()Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "intellij.database.dialects.oracle.ex"})
    public static final class ExecuteFragmentStatement
    extends CallDefinition {
        @NotNull
        public static final ExecuteFragmentStatement INSTANCE = new ExecuteFragmentStatement();
        @NotNull
        private static final StringOutParam error = CallParams.registerString$default(INSTANCE, 2, 1000, null, 4, null);

        private ExecuteFragmentStatement() {
            super("declare\n    pp sys.dbms_debug_vc2coll := sys.dbms_debug_vc2coll();\nbegin\n    sys.dbms_debug.execute(?, frame# => -1, bind_results => 0, results => pp, errm => ?);\nend;");
        }

        @NotNull
        public final StringOutParam getError() {
            return error;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0011\u0010%\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000fR\u0011\u0010'\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010#\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$GracefulResumeProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "inputParameters", "", "result", "Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "getResult", "()Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "reason", "getReason", "lineNr", "Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "getLineNr", "()Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "breakpoint", "getBreakpoint", "stackDepth", "getStackDepth", "namespaceCode", "Lcom/intellij/database/dataSource/connection/statements/ShortOutParam;", "getNamespaceCode", "()Lcom/intellij/database/dataSource/connection/statements/ShortOutParam;", "programSchema", "Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "getProgramSchema", "()Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "programName", "getProgramName", "entryPointName", "getEntryPointName", "terminated", "Lcom/intellij/database/dataSource/connection/statements/BitBoolOutParam;", "getTerminated", "()Lcom/intellij/database/dataSource/connection/statements/BitBoolOutParam;", "isProcedure", "stepsDone", "getStepsDone", "coffeeBreak", "getCoffeeBreak", "intellij.database.dialects.oracle.ex"})
    public static final class GracefulResumeProc
    extends CallDefinition {
        @NotNull
        public static final GracefulResumeProc INSTANCE = new GracefulResumeProc();
        private static final int inputParameters = 5;
        @NotNull
        private static final ByteOutParam result = CallParams.registerByte$default(INSTANCE, 6, (byte)0, 2, null);
        @NotNull
        private static final ByteOutParam reason = CallParams.registerByte$default(INSTANCE, 7, (byte)0, 2, null);
        @NotNull
        private static final IntOutParam lineNr = CallParams.registerInt$default(INSTANCE, 8, 0, 2, null);
        @NotNull
        private static final IntOutParam breakpoint = CallParams.registerInt$default(INSTANCE, 9, 0, 2, null);
        @NotNull
        private static final IntOutParam stackDepth = CallParams.registerInt$default(INSTANCE, 10, 0, 2, null);
        @NotNull
        private static final ShortOutParam namespaceCode = CallParams.registerShort$default(INSTANCE, 11, (short)0, 2, null);
        @NotNull
        private static final StringOutParam programSchema = CallParams.registerString$default(INSTANCE, 12, 60, null, 4, null);
        @NotNull
        private static final StringOutParam programName = CallParams.registerString$default(INSTANCE, 13, 60, null, 4, null);
        @NotNull
        private static final StringOutParam entryPointName = CallParams.registerString$default(INSTANCE, 14, 512, null, 4, null);
        @NotNull
        private static final BitBoolOutParam terminated = CallParams.registerBitBool$default(INSTANCE, 15, false, 2, null);
        @NotNull
        private static final BitBoolOutParam isProcedure = CallParams.registerBitBool$default(INSTANCE, 16, false, 2, null);
        @NotNull
        private static final IntOutParam stepsDone = CallParams.registerInt$default(INSTANCE, 17, 0, 2, null);
        @NotNull
        private static final BitBoolOutParam coffeeBreak = CallParams.registerBitBool$default(INSTANCE, 18, false, 2, null);

        private GracefulResumeProc() {
            super("declare\n    --\n    cmd         binary_integer := ?;  \n    stepDepth   binary_integer := ?;\n    stepLine    binary_integer := ?;\n    stepPrgNsp  binary_integer := ?;\n    stepPrgName varchar(128)   := ?;\n    --\n    v1          binary_double := extract(second from localtimestamp);\n    v2          binary_double;\n    delta       binary_double;\n    breaks      binary_integer := 46;\n    ri          sys.dbms_debug.runtime_info;\n    isProcedure binary_integer := 0;\n    rc          binary_integer;\n    d           binary_integer;\n    r           binary_integer;\n    stepsDone   binary_integer := 0;\n    coffeeBreak binary_integer := 0;\n    isRunning   boolean;\n    --\nbegin\n    --\n    loop\n        rc := sys.dbms_debug.continue(ri, breaks, 14);\n        stepsDone := stepsDone + 1;\n        r := ri.Reason;\n        d := ri.StackDepth;\n        isRunning := sys.dbms_debug.target_program_running;\n        exit when rc != 0 or r not in (6,9) or ri.Breakpoint > 0 or not isRunning or ri.Terminated > 0;\n        exit when cmd = 2 and (d < stepDepth or d = stepDepth and ri.Line# != stepLine);\n        exit when cmd = 3 and (d < stepDepth or d = stepDepth and r = sys.dbms_debug.reason_return);\n        exit when cmd = 4 and ri.program.Namespace = stepPrgNsp and ri.program.Name = stepPrgName and ri.Line# = stepLine;\n        exit when cmd = 5 and ri.program.Namespace is null and ri.Line# = stepLine;\n        v2 := extract(second from localtimestamp);   \n        delta := v2 - v1;\n        if (delta < 0 or delta > 0.3) then coffeeBreak := 1; end if;\n        exit when coffeeBreak > 0;\n    end loop;\n    --\n    ? := rc;\n    ? := r;\n    ? := ri.Line#;\n    ? := ri.Breakpoint;\n    ? := d;\n    ? := ri.program.Namespace;\n    ? := ri.program.Owner;\n    ? := ri.program.Name;\n    ? := ri.program.EntryPointName;\n    ? := ri.Terminated;\n    if (isRunning) then isProcedure := 1; end if;\n    ? := isProcedure;\n    ? := stepsDone;\n    ? := coffeeBreak;\n    --\nend;");
        }

        @NotNull
        public final ByteOutParam getResult() {
            return result;
        }

        @NotNull
        public final ByteOutParam getReason() {
            return reason;
        }

        @NotNull
        public final IntOutParam getLineNr() {
            return lineNr;
        }

        @NotNull
        public final IntOutParam getBreakpoint() {
            return breakpoint;
        }

        @NotNull
        public final IntOutParam getStackDepth() {
            return stackDepth;
        }

        @NotNull
        public final ShortOutParam getNamespaceCode() {
            return namespaceCode;
        }

        @NotNull
        public final StringOutParam getProgramSchema() {
            return programSchema;
        }

        @NotNull
        public final StringOutParam getProgramName() {
            return programName;
        }

        @NotNull
        public final StringOutParam getEntryPointName() {
            return entryPointName;
        }

        @NotNull
        public final BitBoolOutParam getTerminated() {
            return terminated;
        }

        @NotNull
        public final BitBoolOutParam isProcedure() {
            return isProcedure;
        }

        @NotNull
        public final IntOutParam getStepsDone() {
            return stepsDone;
        }

        @NotNull
        public final BitBoolOutParam getCoffeeBreak() {
            return coffeeBreak;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$ObtainBacktraceProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "listing", "Lcom/intellij/database/dialects/oracle/debugger/OraStringArrayOutParameter;", "getListing", "()Lcom/intellij/database/dialects/oracle/debugger/OraStringArrayOutParameter;", "intellij.database.dialects.oracle.ex"})
    public static final class ObtainBacktraceProc
    extends CallDefinition {
        @NotNull
        public static final ObtainBacktraceProc INSTANCE = new ObtainBacktraceProc();
        @NotNull
        private static final OraStringArrayOutParameter listing = INSTANCE.registerStringArray(1, "SYS.DBMS_DEBUG_VC2COLL");

        private ObtainBacktraceProc() {
            super("declare\n    bt sys.dbms_debug.backtrace_table;\n    pi sys.dbms_debug.program_info;\n    rt sys.dbms_debug_vc2coll;\n    s  string(1000);\n    z  constant char(1) := chr(1);\nbegin\n    sys.dbms_debug.print_backtrace(backtrace => bt);\n    rt := sys.dbms_debug_vc2coll();\n    if (bt.count >= 1) then\n        rt.extend(bt.count);\n        for i in 1 .. bt.count loop\n            pi := bt(i);\n            s := pi.namespace || z ||\n                 pi.owner || z ||\n                 pi.name || z ||\n                 pi.line# || z ||\n                 pi.libunittype || z ||\n                 pi.entrypointname || z;\n            rt(i) := s;\n        end loop;\n    end if;\n    ? := rt;\nend;");
        }

        @NotNull
        public final OraStringArrayOutParameter getListing() {
            return listing;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$PeekVariable;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "result", "Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "getResult", "()Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "value", "Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "getValue", "()Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "intellij.database.dialects.oracle.ex"})
    public static final class PeekVariable
    extends CallDefinition {
        @NotNull
        public static final PeekVariable INSTANCE = new PeekVariable();
        @NotNull
        private static final ByteOutParam result = INSTANCE.registerByte(2, (byte)-1);
        @NotNull
        private static final StringOutParam value = CallParams.registerString$default(INSTANCE, 3, 4000, null, 4, null);

        private PeekVariable() {
            super("declare\n    variable string(92) := ?;\nbegin\n    ? := sys.dbms_debug.get_value(variable, -1, ?);\nend;");
        }

        @NotNull
        public final ByteOutParam getResult() {
            return result;
        }

        @NotNull
        public final StringOutParam getValue() {
            return value;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$PrintBacktraceProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "listing", "Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "getListing", "()Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "intellij.database.dialects.oracle.ex"})
    public static final class PrintBacktraceProc
    extends CallDefinition {
        @NotNull
        public static final PrintBacktraceProc INSTANCE = new PrintBacktraceProc();
        @NotNull
        private static final StringOutParam listing = CallParams.registerString$default(INSTANCE, 1, 4000, null, 4, null);

        private PrintBacktraceProc() {
            super("{call sys.dbms_debug.print_backtrace(listing => ?)}");
        }

        @NotNull
        public final StringOutParam getListing() {
            return listing;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$RegisterProgramLineBreakpointBlock;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "result", "Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "getResult", "()Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "id", "Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "getId", "()Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "intellij.database.dialects.oracle.ex"})
    public static final class RegisterProgramLineBreakpointBlock
    extends CallDefinition {
        @NotNull
        public static final RegisterProgramLineBreakpointBlock INSTANCE = new RegisterProgramLineBreakpointBlock();
        @NotNull
        private static final ByteOutParam result = INSTANCE.registerByte(5, (byte)-1);
        @NotNull
        private static final IntOutParam id = CallParams.registerInt$default(INSTANCE, 6, 0, 2, null);

        private RegisterProgramLineBreakpointBlock() {
            super("declare\n    pi sys.dbms_debug.program_info; \n    id binary_integer;\n    r  binary_integer;\nbegin\n    pi.namespace := ?;\n    pi.owner := ?;\n    pi.name := ?;\n    pi.line# := ?; \n    r := sys.dbms_debug.set_breakpoint(pi, pi.line#, id);\n    ? := r;\n    ? := id;\nend;");
        }

        @NotNull
        public final ByteOutParam getResult() {
            return result;
        }

        @NotNull
        public final IntOutParam getId() {
            return id;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$RegisterScriptLineBreakpointBlock;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "<init>", "()V", "result", "Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "getResult", "()Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "id", "Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "getId", "()Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "intellij.database.dialects.oracle.ex"})
    public static final class RegisterScriptLineBreakpointBlock
    extends CallDefinition {
        @NotNull
        public static final RegisterScriptLineBreakpointBlock INSTANCE = new RegisterScriptLineBreakpointBlock();
        @NotNull
        private static final ByteOutParam result = INSTANCE.registerByte(2, (byte)-1);
        @NotNull
        private static final IntOutParam id = CallParams.registerInt$default(INSTANCE, 3, 0, 2, null);

        private RegisterScriptLineBreakpointBlock() {
            super("declare\n    pi sys.dbms_debug.program_info; \n    id binary_integer;\n    r  binary_integer;\nbegin\n    pi.namespace := sys.dbms_debug.namespace_cursor;\n    pi.owner := null;\n    pi.name := null;\n    pi.line# := ?; \n    r := sys.dbms_debug.set_breakpoint(pi, pi.line#, id);\n    ? := r;\n    ? := id;\nend;");
        }

        @NotNull
        public final ByteOutParam getResult() {
            return result;
        }

        @NotNull
        public final IntOutParam getId() {
            return id;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$StepOutProc;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;", "<init>", "()V", "intellij.database.dialects.oracle.ex"})
    public static final class StepOutProc
    extends SyncLikeProc {
        @NotNull
        public static final StepOutProc INSTANCE = new StepOutProc();

        private StepOutProc() {
            super("declare\n    depth         binary_integer := ?;\n    breaks        binary_integer := ?;\n    stopOnReturn  boolean        := ? > 0;\n    ri     sys.dbms_debug.runtime_info;\n    proc   binary_integer := 0;\n    rc     binary_integer;\n    d      binary_integer;\n    r      binary_integer;\nbegin\n    --\n    loop\n        rc := sys.dbms_debug.continue(ri, breaks, 14);\n        r := ri.Reason;\n        d := ri.StackDepth;\n        exit when rc != 0 or d < depth or d = depth and r = sys.dbms_debug.reason_return;\n    end loop;\n    if rc = 0 and d = depth and r = sys.dbms_debug.reason_return and not stopOnReturn then\n        rc := sys.dbms_debug.continue(ri, 62, 14); \n        r := ri.Reason;\n        d := ri.StackDepth;\n    end if;\n    --\n    ? := rc;\n    ? := r;\n    ? := ri.Line#;\n    ? := ri.Breakpoint;\n    ? := d;\n    ? := ri.program.Namespace;\n    ? := ri.program.Owner;\n    ? := ri.program.Name;\n    ? := ri.program.EntryPointName;\n    ? := ri.Terminated;\n    if (sys.dbms_debug.target_program_running) then proc := 1; end if;\n    ? := proc;\n    --\nend;", 3);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010'\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "text", "", "skip", "", "<init>", "(Ljava/lang/String;I)V", "getSkip", "()I", "result", "Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "getResult", "()Lcom/intellij/database/dataSource/connection/statements/ByteOutParam;", "reason", "getReason", "lineNr", "Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "getLineNr", "()Lcom/intellij/database/dataSource/connection/statements/IntOutParam;", "breakpoint", "getBreakpoint", "stackDepth", "getStackDepth", "namespaceCode", "Lcom/intellij/database/dataSource/connection/statements/ShortOutParam;", "getNamespaceCode", "()Lcom/intellij/database/dataSource/connection/statements/ShortOutParam;", "programSchema", "Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "getProgramSchema", "()Lcom/intellij/database/dataSource/connection/statements/StringOutParam;", "programName", "getProgramName", "entryPointName", "getEntryPointName", "terminated", "Lcom/intellij/database/dataSource/connection/statements/BitBoolOutParam;", "getTerminated", "()Lcom/intellij/database/dataSource/connection/statements/BitBoolOutParam;", "isProcedure", "intellij.database.dialects.oracle.ex"})
    public static abstract class SyncLikeProc
    extends CallDefinition {
        private final int skip;
        @NotNull
        private final ByteOutParam result;
        @NotNull
        private final ByteOutParam reason;
        @NotNull
        private final IntOutParam lineNr;
        @NotNull
        private final IntOutParam breakpoint;
        @NotNull
        private final IntOutParam stackDepth;
        @NotNull
        private final ShortOutParam namespaceCode;
        @NotNull
        private final StringOutParam programSchema;
        @NotNull
        private final StringOutParam programName;
        @NotNull
        private final StringOutParam entryPointName;
        @NotNull
        private final BitBoolOutParam terminated;
        @NotNull
        private final BitBoolOutParam isProcedure;

        public SyncLikeProc(@NotNull String text, int skip) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
            this.skip = skip;
            this.result = CallParams.registerByte$default(this, this.skip + 1, (byte)0, 2, null);
            this.reason = CallParams.registerByte$default(this, this.skip + 2, (byte)0, 2, null);
            this.lineNr = CallParams.registerInt$default(this, this.skip + 3, 0, 2, null);
            this.breakpoint = CallParams.registerInt$default(this, this.skip + 4, 0, 2, null);
            this.stackDepth = CallParams.registerInt$default(this, this.skip + 5, 0, 2, null);
            this.namespaceCode = CallParams.registerShort$default(this, this.skip + 6, (short)0, 2, null);
            this.programSchema = CallParams.registerString$default(this, this.skip + 7, 60, null, 4, null);
            this.programName = CallParams.registerString$default(this, this.skip + 8, 60, null, 4, null);
            this.entryPointName = CallParams.registerString$default(this, this.skip + 9, 512, null, 4, null);
            this.terminated = CallParams.registerBitBool$default(this, this.skip + 10, false, 2, null);
            this.isProcedure = CallParams.registerBitBool$default(this, this.skip + 11, false, 2, null);
        }

        public final int getSkip() {
            return this.skip;
        }

        @NotNull
        public final ByteOutParam getResult() {
            return this.result;
        }

        @NotNull
        public final ByteOutParam getReason() {
            return this.reason;
        }

        @NotNull
        public final IntOutParam getLineNr() {
            return this.lineNr;
        }

        @NotNull
        public final IntOutParam getBreakpoint() {
            return this.breakpoint;
        }

        @NotNull
        public final IntOutParam getStackDepth() {
            return this.stackDepth;
        }

        @NotNull
        public final ShortOutParam getNamespaceCode() {
            return this.namespaceCode;
        }

        @NotNull
        public final StringOutParam getProgramSchema() {
            return this.programSchema;
        }

        @NotNull
        public final StringOutParam getProgramName() {
            return this.programName;
        }

        @NotNull
        public final StringOutParam getEntryPointName() {
            return this.entryPointName;
        }

        @NotNull
        public final BitBoolOutParam getTerminated() {
            return this.terminated;
        }

        @NotNull
        public final BitBoolOutParam isProcedure() {
            return this.isProcedure;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SynchronizeProc;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;", "<init>", "()V", "intellij.database.dialects.oracle.ex"})
    public static final class SynchronizeProc
    extends SyncLikeProc {
        @NotNull
        public static final SynchronizeProc INSTANCE = new SynchronizeProc();

        private SynchronizeProc() {
            super("declare\n    ri sys.dbms_debug.runtime_info;\n    proc binary_integer := 0;\nbegin\n    ? := sys.dbms_debug.synchronize(ri, 14);\n    ? := ri.Reason;\n    ? := ri.Line#;\n    ? := ri.Breakpoint;\n    ? := ri.StackDepth;\n    ? := ri.program.Namespace;\n    ? := ri.program.Owner;\n    ? := ri.program.Name;\n    ? := ri.program.EntryPointName;\n    ? := ri.Terminated;\n    if (sys.dbms_debug.target_program_running) then proc := 1; end if;\n    ? := proc;\nend;", 0);
        }
    }
}

