/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHighlightingPassFactory;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunLineMarkerContributorKt;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlImplUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "<init>", "()V", "tagType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.database.dialects.oracle.ex"})
final class UtPlSqlHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    @NotNull
    private HighlightInfoType.HighlightInfoTypeImpl tagType = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, DefaultLanguageHighlighterColors.DOC_COMMENT);

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        int[] nArray = new int[]{4};
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, nArray, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(psiFile instanceof SqlFile) || !Intrinsics.areEqual((Object)((SqlFile)psiFile).getSqlLanguage().getDbms(), (Object)Dbms.ORACLE)) {
            return null;
        }
        Project project = ((SqlFile)psiFile).getProject();
        Document document = editor.getDocument();
        return new TextEditorHighlightingPass(psiFile, editor, this, project, document){
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ UtPlSqlHighlightingPassFactory this$0;
            {
                this.$psiFile = $psiFile;
                this.$editor = $editor;
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            /*
             * WARNING - void declaration
             */
            public void doCollectInformation(ProgressIndicator progress) {
                void $this$forEach$iv;
                Object pack2;
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                IntArrayList tags = new IntArrayList();
                for (Object pack2 : SqlImplUtil.sqlChildren((PsiElement)((PsiElement)this.$psiFile)).filter(arg_0 -> createHighlightingPass.1.doCollectInformation$lambda$1(createHighlightingPass.1::doCollectInformation$lambda$0, arg_0))) {
                    for (PsiComment comment : SqlImplUtil.sqlChildren((PsiElement)pack2).filter(PsiComment.class)) {
                        String string = comment.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (!UtPlSqlRunLineMarkerContributorKt.isTagged(string, "")) continue;
                        TextRange rg = comment.getTextRange();
                        tags.add(rg.getStartOffset());
                        tags.add(rg.getEndOffset());
                    }
                }
                ArrayList<E> infos = new ArrayList<E>();
                pack2 = (Iterable)RangesKt.until((int)0, (int)(tags.size() / 2));
                UtPlSqlHighlightingPassFactory utPlSqlHighlightingPassFactory = this.this$0;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    ((Collection)infos).add(HighlightInfo.newHighlightInfo((HighlightInfoType)((HighlightInfoType)UtPlSqlHighlightingPassFactory.access$getTagType$p(utPlSqlHighlightingPassFactory))).range(tags.getInt(i * 2), tags.getInt(i * 2 + 1)).createUnconditionally());
                }
                BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.$psiFile, (Document)this.$editor.getDocument(), (int)0, (int)this.$psiFile.getTextLength(), (Collection)infos, (int)this.getId());
            }

            public void doApplyInformationToEditor() {
            }

            private static final boolean doCollectInformation$lambda$0(PsiElement it) {
                return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)OraElementTypes.Stubs.ORA_CREATE_PACKAGE_STATEMENT);
            }

            private static final boolean doCollectInformation$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    public static final /* synthetic */ HighlightInfoType.HighlightInfoTypeImpl access$getTagType$p(UtPlSqlHighlightingPassFactory $this) {
        return $this.tagType;
    }
}

