/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend;

import com.intellij.platform.searchEverywhere.SeItemData;
import com.intellij.platform.searchEverywhere.SeItemDataKt;
import com.intellij.platform.searchEverywhere.frontend.SeSelectionState;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultJBList;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListItemRow;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListModel;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListRow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/SeSelectionListener;", "", "initialSelectionState", "Lcom/intellij/platform/searchEverywhere/frontend/SeSelectionState;", "resultList", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultJBList;", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListRow;", "resultListModel", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel;", "<init>", "(Lcom/intellij/platform/searchEverywhere/frontend/SeSelectionState;Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultJBList;Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel;)V", "getResultList", "()Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultJBList;", "getResultListModel", "()Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultListModel;", "selectionState", "getIndexToSelect", "", "maxVisibleRowCount", "currentPattern", "", "isInitialSearchPattern", "", "isEndEvent", "saveSelectionState", "", "getSelectionState", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSeSelectionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeSelectionListener.kt\ncom/intellij/platform/searchEverywhere/frontend/SeSelectionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n296#2,2:74\n*S KotlinDebug\n*F\n+ 1 SeSelectionListener.kt\ncom/intellij/platform/searchEverywhere/frontend/SeSelectionListener\n*L\n39#1:74,2\n*E\n"})
public final class SeSelectionListener {
    @NotNull
    private final SeResultJBList<SeResultListRow> resultList;
    @NotNull
    private final SeResultListModel resultListModel;
    @Nullable
    private SeSelectionState selectionState;

    public SeSelectionListener(@Nullable SeSelectionState initialSelectionState, @NotNull SeResultJBList<SeResultListRow> resultList, @NotNull SeResultListModel resultListModel) {
        Intrinsics.checkNotNullParameter(resultList, (String)"resultList");
        Intrinsics.checkNotNullParameter((Object)resultListModel, (String)"resultListModel");
        this.resultList = resultList;
        this.resultListModel = resultListModel;
        this.selectionState = initialSelectionState;
    }

    @NotNull
    public final SeResultJBList<SeResultListRow> getResultList() {
        return this.resultList;
    }

    @NotNull
    public final SeResultListModel getResultListModel() {
        return this.resultListModel;
    }

    public final int getIndexToSelect(int maxVisibleRowCount, @NotNull String currentPattern, boolean isInitialSearchPattern, boolean isEndEvent) {
        Object v6;
        IntRange searchRange;
        block10: {
            int effectiveModelSize;
            SeItemData selectedItemData;
            block12: {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)currentPattern, (String)"currentPattern");
                    if (this.selectionState == null) {
                        return 0;
                    }
                    SeSelectionState seSelectionState = this.selectionState;
                    Intrinsics.checkNotNull((Object)seSelectionState);
                    selectedItemData = seSelectionState.getSelectedItem();
                    if (this.resultListModel.getSize() >= 1) {
                        Object e = this.resultListModel.get(0);
                        SeResultListItemRow seResultListItemRow = e instanceof SeResultListItemRow ? (SeResultListItemRow)e : null;
                        boolean bl = seResultListItemRow != null && (seResultListItemRow = seResultListItemRow.getItem()) != null ? SeItemDataKt.contentEquals((SeItemData)seResultListItemRow, (Object)selectedItemData) : false;
                        if (bl) {
                            return 0;
                        }
                    }
                    effectiveModelSize = this.resultList.getEffectiveModelSize();
                    if (this.resultList.getSelectedIndex() >= 1 || effectiveModelSize == 0) {
                        return -1;
                    }
                    if (isEndEvent) break block11;
                    if (!isInitialSearchPattern) break block12;
                    SeSelectionState seSelectionState2 = this.selectionState;
                    Intrinsics.checkNotNull((Object)seSelectionState2);
                    if (Intrinsics.areEqual((Object)seSelectionState2.getPattern(), (Object)currentPattern)) break block12;
                }
                this.selectionState = null;
                return 0;
            }
            searchRange = new IntRange(0, Math.min(effectiveModelSize - 1, maxVisibleRowCount - 1));
            Iterable $this$firstOrNull$iv = (Iterable)searchRange;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int i = ((Number)element$iv).intValue();
                boolean bl = false;
                Object e = this.resultListModel.get(i);
                SeResultListItemRow seResultListItemRow = e instanceof SeResultListItemRow ? (SeResultListItemRow)e : null;
                boolean bl2 = seResultListItemRow != null && (seResultListItemRow = seResultListItemRow.getItem()) != null ? SeItemDataKt.contentEquals((SeItemData)seResultListItemRow, (Object)selectedItemData) : false;
                if (!bl2) continue;
                v6 = element$iv;
                break block10;
            }
            v6 = null;
        }
        Integer matchingIndex = v6;
        if (matchingIndex != null) {
            return matchingIndex;
        }
        if (searchRange.getLast() >= maxVisibleRowCount - 1) {
            this.selectionState = null;
        }
        return 0;
    }

    public final void saveSelectionState(@NotNull String currentPattern) {
        SeItemData itemDataToSave;
        Intrinsics.checkNotNullParameter((Object)currentPattern, (String)"currentPattern");
        if (this.resultList.getSelectedIndex() == -1) {
            return;
        }
        Object e = this.resultListModel.get(this.resultList.getSelectedIndex());
        SeResultListItemRow seResultListItemRow = e instanceof SeResultListItemRow ? (SeResultListItemRow)e : null;
        Object object = itemDataToSave = seResultListItemRow != null ? seResultListItemRow.getItem() : null;
        if (itemDataToSave != null) {
            this.selectionState = new SeSelectionState(currentPattern, itemDataToSave);
        }
    }

    @Nullable
    public final SeSelectionState getSelectionState() {
        return this.selectionState;
    }
}

