/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compose.ide.plugin.shared;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.compose.ide.plugin.shared.ComposeColorConstructor;
import com.intellij.compose.ide.plugin.shared.ComposeColorLineMarkerProviderDescriptorKt;
import com.intellij.compose.ide.plugin.shared.ComposeIdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.colorpicker.ColorPickerBuilder;
import com.intellij.ui.colorpicker.ColorPipetteProvider;
import com.intellij.ui.colorpicker.LightCalloutPopup;
import com.intellij.ui.colorpicker.MaterialGraphicalColorPipetteProvider;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\u0016\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0017H\u0007J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0083\u0004J\n\u0010\u001f\u001a\u00020 H\u00d6\u0081\u0004J\n\u0010!\u001a\u00020\"H\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/intellij/compose/ide/plugin/shared/ColorIconRenderer;", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "ktCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "color", "Ljava/awt/Color;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Ljava/awt/Color;)V", "getKtCallExpression", "()Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getColor", "()Ljava/awt/Color;", "icon", "Lcom/intellij/util/ui/ColorIcon;", "getIcon", "()Lcom/intellij/util/ui/ColorIcon;", "navigate", "", "e", "Ljava/awt/event/MouseEvent;", "elt", "getSetColorTask", "Lkotlin/Function1;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.compose.ide.plugin.shared"})
@SourceDebugExtension(value={"SMAP\nComposeColorLineMarkerProviderDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeColorLineMarkerProviderDescriptor.kt\ncom/intellij/compose/ide/plugin/shared/ColorIconRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1807#2,3:439\n1807#2,3:442\n1807#2,3:445\n1807#2,3:448\n*S KotlinDebug\n*F\n+ 1 ComposeColorLineMarkerProviderDescriptor.kt\ncom/intellij/compose/ide/plugin/shared/ColorIconRenderer\n*L\n279#1:439,3\n292#1:442,3\n294#1:445,3\n315#1:448,3\n*E\n"})
public final class ColorIconRenderer
implements GutterIconNavigationHandler<PsiElement> {
    @NotNull
    private final KtCallExpression ktCallExpression;
    @NotNull
    private final Color color;
    @NotNull
    private final ColorIcon icon;

    public ColorIconRenderer(@NotNull KtCallExpression ktCallExpression, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)ktCallExpression, (String)"ktCallExpression");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.ktCallExpression = ktCallExpression;
        this.color = color;
        this.icon = new ColorIcon(8, this.color);
    }

    @NotNull
    public final KtCallExpression getKtCallExpression() {
        return this.ktCallExpression;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final ColorIcon getIcon() {
        return this.icon;
    }

    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
        Project project = this.ktCallExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Function1<Color, Unit> function1 = this.getSetColorTask();
        if (function1 == null) {
            return;
        }
        Function1<Color, Unit> setColorTask = function1;
        ColorListener pickerListener = (arg_0, arg_1) -> ColorIconRenderer.navigate$lambda$0(project2, setColorTask, arg_0, arg_1);
        LightCalloutPopup colorPicker = new ColorPickerBuilder(true, false).setOriginalColor(this.color).addSaturationBrightnessComponent().addColorAdjustPanel((ColorPipetteProvider)new MaterialGraphicalColorPipetteProvider()).addColorValuePanel().withFocus().addColorListener(pickerListener).focusWhenDisplay(true).setFocusCycleRoot(true).build();
        LightCalloutPopup dialog = new LightCalloutPopup(colorPicker.getContent(), null, null, null, 14, null);
        Point point = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
        LightCalloutPopup.show$default((LightCalloutPopup)dialog, null, (Point)point, null, (int)5, null);
    }

    @VisibleForTesting
    @Nullable
    public final Function1<Color, Unit> getSetColorTask() {
        ComposeColorConstructor composeColorConstructor = ComposeColorLineMarkerProviderDescriptorKt.access$getConstructorType(this.ktCallExpression.getValueArguments());
        if (composeColorConstructor == null) {
            return null;
        }
        ComposeColorConstructor constructorType = composeColorConstructor;
        return switch (WhenMappings.$EnumSwitchMapping$0[constructorType.ordinal()]) {
            case 1, 2 -> arg_0 -> ColorIconRenderer.getSetColorTask$lambda$0(this, arg_0);
            case 3, 4 -> arg_0 -> ColorIconRenderer.getSetColorTask$lambda$1(this, arg_0);
            case 5, 6 -> arg_0 -> ColorIconRenderer.getSetColorTask$lambda$2(this, arg_0);
            case 7 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final KtCallExpression component1() {
        return this.ktCallExpression;
    }

    @NotNull
    public final Color component2() {
        return this.color;
    }

    @NotNull
    public final ColorIconRenderer copy(@NotNull KtCallExpression ktCallExpression, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)ktCallExpression, (String)"ktCallExpression");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new ColorIconRenderer(ktCallExpression, color);
    }

    public static /* synthetic */ ColorIconRenderer copy$default(ColorIconRenderer colorIconRenderer, KtCallExpression ktCallExpression, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            ktCallExpression = colorIconRenderer.ktCallExpression;
        }
        if ((n & 2) != 0) {
            color = colorIconRenderer.color;
        }
        return colorIconRenderer.copy(ktCallExpression, color);
    }

    @NotNull
    public String toString() {
        return "ColorIconRenderer(ktCallExpression=" + this.ktCallExpression + ", color=" + this.color + ")";
    }

    public int hashCode() {
        int result = this.ktCallExpression.hashCode();
        result = result * 31 + this.color.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColorIconRenderer)) {
            return false;
        }
        ColorIconRenderer colorIconRenderer = (ColorIconRenderer)other;
        if (!Intrinsics.areEqual((Object)this.ktCallExpression, (Object)colorIconRenderer.ktCallExpression)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.color, (Object)colorIconRenderer.color);
    }

    private static final void navigate$lambda$0$0$0(Function1 $setColorTask, Color $color) {
        Intrinsics.checkNotNull((Object)$color);
        $setColorTask.invoke((Object)$color);
    }

    private static final void navigate$lambda$0$0(Project $project, Function1 $setColorTask, Color $color) {
        WriteCommandAction.runWriteCommandAction((Project)$project, (String)ComposeIdeBundle.INSTANCE.message("compose.color.picker.action.name", new Object[0]), null, () -> ColorIconRenderer.navigate$lambda$0$0$0($setColorTask, $color), (PsiFile[])new PsiFile[0]);
    }

    private static final void navigate$lambda$0(Project $project, Function1 $setColorTask, Color color, Object object) {
        ApplicationManager.getApplication().invokeLater(() -> ColorIconRenderer.navigate$lambda$0$0($project, $setColorTask, color), $project.getDisposed());
    }

    private static final Unit getSetColorTask$lambda$0(ColorIconRenderer this$0, Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        KtValueArgumentList valueArgumentList = this$0.ktCallExpression.getValueArgumentList();
        if (valueArgumentList != null) {
            boolean bl;
            block4: {
                List list = valueArgumentList.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl2 = false;
                        if (!(it.getArgumentName() != null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean needsArgumentName = bl;
            String string = "%08X";
            Object[] objectArray = new Object[]{color.getRGB()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String hexString = "0x" + string2;
            String argumentText = needsArgumentName ? "(color = " + hexString + ")" : "(" + hexString + ")";
            Project project = this$0.ktCallExpression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            valueArgumentList.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createCallArguments(argumentText));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getSetColorTask$lambda$1(ColorIconRenderer this$0, Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        KtValueArgumentList valueArgumentList = this$0.ktCallExpression.getValueArgumentList();
        if (valueArgumentList != null) {
            boolean bl;
            boolean needsArgumentName;
            block8: {
                boolean bl2;
                block7: {
                    List list = valueArgumentList.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtValueArgument it = (KtValueArgument)element$iv;
                            boolean bl3 = false;
                            if (!(it.getArgumentName() != null)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                needsArgumentName = bl2;
                List list = valueArgumentList.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl4 = false;
                        Object object = it.getArgumentExpression();
                        if (!(object != null && (object = object.getText()) != null ? StringsKt.startsWith$default((String)object, (String)"0x", (boolean)false, (int)2, null) : false)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            boolean hasHexFormat = bl;
            String red = hasHexFormat ? ComposeColorLineMarkerProviderDescriptorKt.access$toHexString(color.getRed()) : String.valueOf(color.getRed());
            String green = hasHexFormat ? ComposeColorLineMarkerProviderDescriptorKt.access$toHexString(color.getGreen()) : String.valueOf(color.getGreen());
            String blue = hasHexFormat ? ComposeColorLineMarkerProviderDescriptorKt.access$toHexString(color.getBlue()) : String.valueOf(color.getBlue());
            String alpha = hasHexFormat ? ComposeColorLineMarkerProviderDescriptorKt.access$toHexString(color.getAlpha()) : String.valueOf(color.getAlpha());
            String argumentText = needsArgumentName ? "(red = " + red + ", green = " + green + ", blue = " + blue + ", alpha = " + alpha + ")" : "(" + red + ", " + green + ", " + blue + ", " + alpha + ")";
            Project project = this$0.ktCallExpression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            valueArgumentList.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createCallArguments(argumentText));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getSetColorTask$lambda$2(ColorIconRenderer this$0, Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        KtValueArgumentList valueArgumentList = this$0.ktCallExpression.getValueArgumentList();
        if (valueArgumentList != null) {
            boolean bl;
            block4: {
                List list = valueArgumentList.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl2 = false;
                        if (!(it.getArgumentName() != null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean needsArgumentName = bl;
            String red = ComposeColorLineMarkerProviderDescriptorKt.toRoundString$default((float)color.getRed() / 255.0f, 0, 1, null);
            String green = ComposeColorLineMarkerProviderDescriptorKt.toRoundString$default((float)color.getGreen() / 255.0f, 0, 1, null);
            String blue = ComposeColorLineMarkerProviderDescriptorKt.toRoundString$default((float)color.getBlue() / 255.0f, 0, 1, null);
            String alpha = ComposeColorLineMarkerProviderDescriptorKt.toRoundString$default((float)color.getAlpha() / 255.0f, 0, 1, null);
            String argumentText = needsArgumentName ? "(red = " + red + "f, green = " + green + "f, blue = " + blue + "f, alpha = " + alpha + "f)" : "(" + red + "f, " + green + "f, " + blue + "f, " + alpha + "f)";
            Project project = this$0.ktCallExpression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            valueArgumentList.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createCallArguments(argumentText));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComposeColorConstructor.values().length];
            try {
                nArray[ComposeColorConstructor.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeColorConstructor.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeColorConstructor.INT_X3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeColorConstructor.INT_X4.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeColorConstructor.FLOAT_X3.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeColorConstructor.FLOAT_X4.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComposeColorConstructor.FLOAT_X4_COLORSPACE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

