/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.vcs.impl.frontend.changes.ChangesTree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Processor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0014J\b\u0010\u0011\u001a\u00020\u000bH\u0014J\b\u0010\u0012\u001a\u00020\u000bH\u0014J\b\u0010\u0013\u001a\u00020\u000bH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u000bH&R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/changes/ChangesTreeEditorDiffPreview;", "T", "Lcom/intellij/platform/vcs/impl/frontend/changes/ChangesTree;", "", "tree", "<init>", "(Lcom/intellij/platform/vcs/impl/frontend/changes/ChangesTree;)V", "getTree", "()Lcom/intellij/platform/vcs/impl/frontend/changes/ChangesTree;", "Lcom/intellij/platform/vcs/impl/frontend/changes/ChangesTree;", "handleDoubleClick", "", "e", "Ljava/awt/event/MouseEvent;", "handleEnterKey", "Ljava/awt/event/KeyEvent;", "isPreviewOnDoubleClick", "isOpenPreviewWithSingleClickEnabled", "isPreviewOnEnter", "isOpenPreviewWithSingleClick", "handleSingleClick", "", "performDiffAction", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public abstract class ChangesTreeEditorDiffPreview<T extends ChangesTree> {
    @NotNull
    private final T tree;

    public ChangesTreeEditorDiffPreview(@NotNull T tree) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        this.tree = tree;
        ((ChangesTree)((Object)this.tree)).setEnterKeyHandler((Processor<KeyEvent>)((Processor)arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$1(arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$0(this, arg_0), arg_0)));
        ((ChangesTree)((Object)this.tree)).setDoubleClickHandler((Processor<MouseEvent>)((Processor)arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$3(arg_0 -> ChangesTreeEditorDiffPreview._init_$lambda$2(this, arg_0), arg_0)));
    }

    @NotNull
    protected final T getTree() {
        return this.tree;
    }

    public boolean handleDoubleClick(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isPreviewOnDoubleClick()) {
            return false;
        }
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)this.tree), (MouseEvent)e)) {
            return false;
        }
        return this.performDiffAction();
    }

    public boolean handleEnterKey(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isPreviewOnEnter()) {
            return false;
        }
        return this.performDiffAction();
    }

    protected boolean isPreviewOnDoubleClick() {
        return true;
    }

    protected boolean isOpenPreviewWithSingleClickEnabled() {
        return false;
    }

    protected boolean isPreviewOnEnter() {
        return true;
    }

    protected boolean isOpenPreviewWithSingleClick() {
        if (!this.isOpenPreviewWithSingleClickEnabled()) {
            return false;
        }
        Project project = ((ChangesTree)((Object)this.tree)).getProject();
        return Intrinsics.areEqual(this.tree, (Object)IdeFocusManager.getInstance((Project)project).getFocusOwner());
    }

    protected void handleSingleClick() {
        if (!this.isOpenPreviewWithSingleClick()) {
            return;
        }
        this.performDiffAction();
    }

    public abstract boolean performDiffAction();

    private static final boolean _init_$lambda$0(ChangesTreeEditorDiffPreview this$0, KeyEvent it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.handleEnterKey(it);
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$2(ChangesTreeEditorDiffPreview this$0, MouseEvent it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.handleDoubleClick(it);
    }

    private static final boolean _init_$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

