/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.shelf.tree;

import com.intellij.platform.vcs.impl.frontend.VcsFrontendBundle;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ChangesBrowserNodeRenderer;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.EntityChangesBrowserNode;
import com.intellij.platform.vcs.impl.shared.rhizome.NodeEntity;
import com.intellij.platform.vcs.impl.shared.rhizome.ShelvedChangeListEntity;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.text.DateFormatUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u000f\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelvedChangeListNode;", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/EntityChangesBrowserNode;", "Lcom/intellij/platform/vcs/impl/shared/rhizome/ShelvedChangeListEntity;", "changeList", "<init>", "(Lcom/intellij/platform/vcs/impl/shared/rhizome/ShelvedChangeListEntity;)V", "render", "", "renderer", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "doGetTextPresentation", "", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public final class ShelvedChangeListNode
extends EntityChangesBrowserNode<ShelvedChangeListEntity> {
    @NotNull
    private final ShelvedChangeListEntity changeList;

    public ShelvedChangeListNode(@NotNull ShelvedChangeListEntity changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        super((NodeEntity)changeList);
        this.changeList = changeList;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        String listName = this.changeList.getDescription();
        if (StringsKt.isBlank((CharSequence)listName)) {
            listName = VcsFrontendBundle.message("changes.nodetitle.empty.changelist.name", new Object[0]);
        }
        if (this.changeList.isRecycled() || this.changeList.isDeleted()) {
            renderer.appendTextWithIssueLinks(listName, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else {
            renderer.appendTextWithIssueLinks(listName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.appendCount(renderer);
        String string = DateFormatUtil.formatPrettyDateTime((long)this.changeList.getDate());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDateTime(...)");
        String date = string;
        renderer.append(", " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        String string2 = this.changeList.getError();
        if (string2 == null) {
            return;
        }
        String loadingError = string2;
        renderer.append(FontUtil.spaceAndThinSpace() + loadingError, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    @Override
    @Nullable
    public String doGetTextPresentation() {
        return ((ShelvedChangeListEntity)this.getUserObject()).getDescription();
    }
}

