/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.navbar.frontend.actions.ActionsKt;
import com.intellij.platform.navbar.frontend.ui.ContextJBList;
import com.intellij.platform.navbar.frontend.ui.NavBarListWrapper;
import com.intellij.platform.navbar.frontend.ui.NavBarPopupListCellRenderer;
import com.intellij.platform.navbar.frontend.vm.NavBarPopupItem;
import com.intellij.platform.navbar.frontend.vm.NavBarPopupVm;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0000\u001a6\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0003\"\b\b\u0000\u0010\u0006*\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002\u00a8\u0006\u000f"}, d2={"createNavBarPopup", "Lcom/intellij/ui/LightweightHint;", "list", "Ljavax/swing/JList;", "Lcom/intellij/platform/navbar/frontend/vm/NavBarPopupItem;", "navBarPopupList", "T", "vm", "Lcom/intellij/platform/navbar/frontend/vm/NavBarPopupVm;", "contextComponent", "Ljava/awt/Component;", "floating", "", "withSpeedSearch", "Ljavax/swing/JComponent;", "intellij.platform.navbar.frontend"})
public final class PopupKt {
    @NotNull
    public static final LightweightHint createNavBarPopup(@NotNull JList<? extends NavBarPopupItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)list);
        JComponent popupComponent = PopupKt.withSpeedSearch(list);
        LightweightHint popup2 = new LightweightHint(popupComponent, list){
            final /* synthetic */ JList<? extends NavBarPopupItem> $list;
            {
                this.$list = $list;
                super($popupComponent);
            }

            protected void onPopupCancel() {
                HintUpdateSupply.hideHint((JComponent)this.$list);
            }
        };
        popup2.setFocusRequestor(popupComponent);
        popup2.setForceShowAsPopup(true);
        popup2.setCancelOnOtherWindowOpen(false);
        return popup2;
    }

    @NotNull
    public static final <T extends NavBarPopupItem> JList<T> navBarPopupList(@NotNull NavBarPopupVm<T> vm, @NotNull Component contextComponent, boolean floating) {
        Intrinsics.checkNotNullParameter(vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)contextComponent, (String)"contextComponent");
        ContextJBList list = new ContextJBList(contextComponent);
        list.setModel((ListModel)new CollectionListModel(vm.getItems()));
        list.setCellRenderer(new NavBarPopupListCellRenderer(floating));
        list.setBorder(JBUI.Borders.empty((int)5));
        list.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        list.addListSelectionListener(arg_0 -> PopupKt.navBarPopupList$lambda$0(vm, list, arg_0));
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)list)), (ActionGroup)ActionsKt.navBarContextMenuActionGroup(), (String)"NavBar");
        list.addMouseListener(new MouseAdapter(vm){
            final /* synthetic */ NavBarPopupVm<T> $vm;
            {
                this.$vm = $vm;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private final void click(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() == 1 && e.getButton() == 1) {
                    this.$vm.complete();
                }
            }
        });
        return (JList)((Object)list);
    }

    private static final JComponent withSpeedSearch(JList<? extends NavBarPopupItem> $this$withSpeedSearch) {
        NavBarListWrapper wrapper = new NavBarListWrapper($this$withSpeedSearch);
        JComponent jComponent = ListWithFilter.wrap($this$withSpeedSearch, (JScrollPane)((JScrollPane)((Object)wrapper)), arg_0 -> PopupKt.withSpeedSearch$lambda$1(PopupKt::withSpeedSearch$lambda$0, arg_0));
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.ui.speedSearch.ListWithFilter<*>");
        ListWithFilter component2 = (ListWithFilter)jComponent;
        wrapper.updateViewportPreferredSizeIfNeeded();
        component2.setAutoPackHeight(!UISettings.Companion.getInstance().getShowNavigationBarInBottom());
        OpenInRightSplitAction.Companion.overrideDoubleClickWithOneClick((JComponent)component2);
        return (JComponent)component2;
    }

    private static final void navBarPopupList$lambda$0(NavBarPopupVm $vm, ContextJBList $list, ListSelectionEvent it) {
        List list = $list.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
        $vm.itemsSelected(list);
    }

    private static final String withSpeedSearch$lambda$0(NavBarPopupItem item) {
        String string = item.getPresentation().getPopupText();
        if (string == null) {
            string = item.getPresentation().getText();
        }
        return string;
    }

    private static final String withSpeedSearch$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

