/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.deletetag;

import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class DeleteTagDialog
extends BaseRefactoringDialog {
    private final JLabel tagNameLabel = new JLabel();
    private final String tagName;

    DeleteTagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.setModal(true);
        this.setTitle(RefactorXBundle.message("dialog.title.delete.tag", new Object[0]));
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.init();
        this.tagName = tag.getName();
        this.tagNameLabel.setText(RefactorXBundle.message("label.text.delete.tag.0", this.tagName));
    }

    protected JComponent createNorthPanel() {
        return this.tagNameLabel;
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.DeleteTag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    protected boolean isValid() {
        return this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        return "<xsl:template match = \"" + this.tagName + "/>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.deleteTag";
    }
}

