/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.DesignerEditorState;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DesignerEditor
extends UserDataHolderBase
implements FileEditor {
    protected final DesignerEditorPanel myDesignerPanel;

    public DesignerEditor(Project project, VirtualFile file) {
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        this.myDesignerPanel = this.createDesignerPanel(project, this.findModule(project, file), file);
    }

    protected abstract Module findModule(Project var1, VirtualFile var2);

    @NotNull
    protected abstract DesignerEditorPanel createDesignerPanel(Project var1, Module var2, VirtualFile var3);

    public final DesignerEditorPanel getDesignerPanel() {
        return this.myDesignerPanel;
    }

    @NotNull
    public final JComponent getComponent() {
        DesignerEditorPanel designerEditorPanel = this.myDesignerPanel;
        if (designerEditorPanel == null) {
            DesignerEditor.$$$reportNull$$$0(0);
        }
        return designerEditorPanel;
    }

    public final JComponent getPreferredFocusedComponent() {
        return this.myDesignerPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = DesignerBundle.message("design", new Object[0]);
        if (string == null) {
            DesignerEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void dispose() {
        this.myDesignerPanel.dispose();
    }

    public void selectNotify() {
        this.myDesignerPanel.activate();
    }

    public void deselectNotify() {
        this.myDesignerPanel.deactivate();
    }

    public boolean isValid() {
        return this.myDesignerPanel.isEditorValid();
    }

    public boolean isModified() {
        return false;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            DesignerEditor.$$$reportNull$$$0(2);
        }
        DesignerEditorState designerEditorState = this.myDesignerPanel.createState();
        if (designerEditorState == null) {
            DesignerEditor.$$$reportNull$$$0(3);
        }
        return designerEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            DesignerEditor.$$$reportNull$$$0(4);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            DesignerEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            DesignerEditor.$$$reportNull$$$0(6);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/DesignerEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/DesignerEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

