/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MorphingAction
extends AnAction {
    private final DesignerEditorPanel myDesigner;
    private final EditableArea myArea;
    private final List<? extends RadComponent> myComponents;
    private final MetaModel myTarget;

    public MorphingAction(DesignerEditorPanel designer, EditableArea area, List<? extends RadComponent> components, MetaModel target) {
        super(target.getTag(), null, target.getIcon());
        this.myDesigner = designer;
        this.myArea = area;
        this.myComponents = components;
        this.myTarget = target;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            MorphingAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MorphingAction.$$$reportNull$$$0(1);
        }
        PaletteItem paletteItem = this.myTarget.getPaletteItem();
        e.getPresentation().setEnabled(paletteItem == null || paletteItem.isEnabled());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MorphingAction.$$$reportNull$$$0(2);
        }
        this.myDesigner.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            ArrayList<RadComponent> newComponents = new ArrayList<RadComponent>();
            for (RadComponent radComponent : this.myComponents) {
                RadComponent newComponent = radComponent.morphingTo(this.myTarget);
                if (newComponent == null) continue;
                newComponents.add(newComponent);
            }
            this.myArea.setSelection(newComponents);
        }), DesignerBundle.message("run.morphing.action", new Object[0]), true);
    }

    public static void fill(DesignerEditorPanel designer, DefaultActionGroup group, EditableArea area) {
        List<RadComponent> selection = area.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        MetaModel model = null;
        for (RadComponent component : selection) {
            if (model == null) {
                model = component.getMetaModel();
                continue;
            }
            if (model == component.getMetaModel()) continue;
            return;
        }
        if (model == null) {
            return;
        }
        List<MetaModel> models = model.getMorphingModels();
        if (models.isEmpty()) {
            return;
        }
        DefaultActionGroup morphingGroup = DefaultActionGroup.createPopupGroup(() -> DesignerBundle.message("action.morphing.text", new Object[0]));
        for (MetaModel morphingModel : models) {
            morphingGroup.add((AnAction)new MorphingAction(designer, area, selection, morphingModel));
        }
        group.add((AnAction)morphingGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/actions/MorphingAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/actions/MorphingAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

