/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.model.MetaModel;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariationPaletteItem
implements PaletteItem {
    private final PaletteItem myDefaultItem;
    @NotNull
    private final String myTitle;
    private final String myIconPath;
    private final String myTooltip;
    private final String myCreation;
    private Icon myIcon;
    private MetaModel myModel;

    protected VariationPaletteItem(PaletteItem defaultItem, MetaModel model, Element element) {
        this.myDefaultItem = defaultItem;
        this.myModel = model;
        String title = element.getAttributeValue("title");
        if (StringUtil.isEmpty((String)title)) {
            title = this.myDefaultItem.getTitle();
        }
        this.myTitle = title;
        String iconPath = element.getAttributeValue("icon");
        if (StringUtil.isEmpty((String)iconPath)) {
            this.myIcon = this.myDefaultItem.getIcon();
        }
        this.myIconPath = iconPath;
        String tooltip = element.getAttributeValue("tooltip");
        if (StringUtil.isEmpty((String)tooltip)) {
            tooltip = this.myDefaultItem.getTooltip();
        }
        this.myTooltip = tooltip;
        Element creation = element.getChild("creation");
        this.myCreation = creation != null ? creation.getTextTrim() : this.myModel.getCreation();
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            VariationPaletteItem.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        if (this.myIcon == null) {
            assert (this.myIconPath != null);
            this.myIcon = IconLoader.findIcon((String)this.myIconPath, this.myModel.getModel());
        }
        return this.myIcon;
    }

    @Override
    public String getTooltip() {
        return this.myTooltip;
    }

    @Override
    public String getVersion() {
        return this.myDefaultItem.getVersion();
    }

    @Override
    public boolean isEnabled() {
        return this.myDefaultItem.isEnabled();
    }

    @Override
    public String getCreation() {
        return this.myCreation;
    }

    @Override
    public MetaModel getMetaModel() {
        return this.myModel;
    }

    @Override
    public void setMetaModel(MetaModel metaModel) {
        this.myModel = metaModel;
    }

    @Override
    @Nullable
    public String getDeprecatedIn() {
        return this.myDefaultItem.getDeprecatedIn();
    }

    @Override
    @Nullable
    public String getDeprecatedHint() {
        return this.myDefaultItem.getDeprecatedHint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/model/VariationPaletteItem", "getTitle"));
    }
}

