/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.actions;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.designer.propertyTable.actions.IPropertyTableAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ShowJavadoc
extends AnAction
implements IPropertyTableAction {
    private final RadPropertyTable myTable;

    public ShowJavadoc(RadPropertyTable table) {
        this.myTable = table;
        Presentation presentation = this.getTemplatePresentation();
        String text = DesignerBundle.message("designer.properties.show.javadoc", new Object[0]);
        presentation.setText(text);
        presentation.setDescription(text);
        presentation.setIcon(AllIcons.Actions.Help);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ShowJavadoc.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowJavadoc.$$$reportNull$$$0(1);
        }
        ShowJavadoc.setEnabled(this.myTable, e, e.getPresentation());
    }

    @Override
    public void update() {
        ShowJavadoc.setEnabled(this.myTable, null, this.getTemplatePresentation());
    }

    private static void setEnabled(RadPropertyTable table, AnActionEvent e, Presentation presentation) {
        Property property = table.getSelectionProperty();
        presentation.setEnabled(!(property == null || table.isEditing() || property.getJavadocElement() == null && StringUtil.isEmpty((String)property.getJavadocText()) || e != null && e.getProject() == null));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ActionCallback callback;
        Project project;
        if (e == null) {
            ShowJavadoc.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)project);
        DocumentationComponent component = new DocumentationComponent(documentationManager);
        Property property = this.myTable.getSelectionProperty();
        if (property == null) {
            return;
        }
        PsiElement javadocElement = property.getJavadocElement();
        if (javadocElement == null) {
            callback = new ActionCallback();
            component.setText(Objects.requireNonNull(property.getJavadocText()), null, null);
            component.clearHistory();
        } else {
            callback = documentationManager.queueFetchDocInfo(javadocElement, component);
        }
        callback.doWhenProcessed(() -> {
            JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setProject(project).setDimensionServiceKey(project, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(DesignerBundle.message("designer.properties.javadoc.title", property.getName())).setCancelCallback(() -> {
                Disposer.dispose((Disposable)component);
                return Boolean.TRUE;
            }).createPopup();
            component.setHint(hint);
            Disposer.register((Disposable)hint, (Disposable)component);
            hint.show(new RelativePoint((Component)this.myTable.getParent(), new Point(0, 0)));
        });
        if (javadocElement == null) {
            callback.setDone();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/propertyTable/actions/ShowJavadoc";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/propertyTable/actions/ShowJavadoc";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

