/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent;

import com.intellij.platform.eel.EelUserPosixInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemPosixApi;
import com.intellij.platform.eel.fs.EelFileSystemWindowsApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelMountRoot;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/ijent/DockerMountRoot;", "Lcom/intellij/platform/eel/provider/EelMountRoot;", "targetRoot", "Lcom/intellij/platform/eel/path/EelPath;", "localRoot", "readOnly", "", "<init>", "(Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/path/EelPath;Z)V", "getTargetRoot", "()Lcom/intellij/platform/eel/path/EelPath;", "getLocalRoot", "getReadOnly", "()Z", "canReadPermissionsDirectly", "targetEel", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "localEel", "options", "Lcom/intellij/platform/eel/provider/EelMountRoot$DirectAccessOptions;", "intellij.clouds.docker"})
public final class DockerMountRoot
implements EelMountRoot {
    @NotNull
    private final EelPath targetRoot;
    @NotNull
    private final EelPath localRoot;
    private final boolean readOnly;

    public DockerMountRoot(@NotNull EelPath targetRoot, @NotNull EelPath localRoot, boolean readOnly) {
        Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        this.targetRoot = targetRoot;
        this.localRoot = localRoot;
        this.readOnly = readOnly;
    }

    @NotNull
    public EelPath getTargetRoot() {
        return this.targetRoot;
    }

    @NotNull
    public EelPath getLocalRoot() {
        return this.localRoot;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean canReadPermissionsDirectly(@NotNull EelFileSystemApi targetEel, @NotNull EelFileSystemApi localEel, @NotNull EelMountRoot.DirectAccessOptions options) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)targetEel, (String)"targetEel");
        Intrinsics.checkNotNullParameter((Object)localEel, (String)"localEel");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(Intrinsics.areEqual((Object)targetEel.getDescriptor(), (Object)this.getTargetRoot().getDescriptor()) && Intrinsics.areEqual((Object)localEel.getDescriptor(), (Object)this.getLocalRoot().getDescriptor()))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.readOnly) {
            return false;
        }
        EelMountRoot.DirectAccessOptions directAccessOptions = options;
        if (Intrinsics.areEqual((Object)directAccessOptions, (Object)EelMountRoot.DirectAccessOptions.BasicAttributes.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)directAccessOptions, (Object)EelMountRoot.DirectAccessOptions.PosixAttributes.INSTANCE)) {
            bl = targetEel instanceof EelFileSystemPosixApi && localEel instanceof EelFileSystemPosixApi;
        } else if (Intrinsics.areEqual((Object)directAccessOptions, (Object)EelMountRoot.DirectAccessOptions.PosixAttributesAndAllAccess.INSTANCE)) {
            if (targetEel instanceof EelFileSystemPosixApi && localEel instanceof EelFileSystemPosixApi) {
                EelUserPosixInfo containerUser = ((EelFileSystemPosixApi)targetEel).getUser();
                EelUserPosixInfo localUser = ((EelFileSystemPosixApi)localEel).getUser();
                bl = localUser.getUid() == containerUser.getUid() && localUser.getGid() == containerUser.getGid() || containerUser.getUid() == 0;
            } else {
                bl = false;
            }
        } else if (Intrinsics.areEqual((Object)directAccessOptions, (Object)EelMountRoot.DirectAccessOptions.CaseSensitivity.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)directAccessOptions, (Object)EelMountRoot.DirectAccessOptions.BasicAttributesAndWritable.INSTANCE)) {
            if (targetEel instanceof EelFileSystemPosixApi && localEel instanceof EelFileSystemPosixApi) {
                EelUserPosixInfo containerUser = ((EelFileSystemPosixApi)targetEel).getUser();
                EelUserPosixInfo localUser = ((EelFileSystemPosixApi)localEel).getUser();
                bl = localUser.getUid() == containerUser.getUid() && localUser.getGid() == containerUser.getGid() || containerUser.getUid() == 0;
            } else {
                bl = targetEel instanceof EelFileSystemPosixApi && localEel instanceof EelFileSystemWindowsApi;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

