/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes.deploy;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.DockerRuntimesManager;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeFileConfigurationProvider;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.ComposeServiceStatus;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.deploy.DockerComposeDeployer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001a\u0010\r\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a0\u0010\r\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u001a\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "shouldRestartOnDeploy", "", "Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer$DeployInfo;", "composeProject", "", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "computeComposeProjectName", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "composeFiles", "", "Ljava/io/File;", "workdir", "getComposeFiles", "getTaskEnvironment", "", "task", "computeWorkingDir", "validateComposeFiles", "", "files", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComposeDeployer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeDeployer.kt\ncom/intellij/docker/runtimes/deploy/DockerComposeDeployerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,269:1\n1586#2:270\n1661#2,3:271\n1642#2,10:274\n1915#2:284\n1916#2:286\n1652#2:287\n1642#2,10:288\n1915#2:298\n1916#2:300\n1652#2:301\n777#2:302\n873#2,2:303\n1205#2,2:305\n1282#2,4:307\n296#2,2:311\n1#3:285\n1#3:299\n13#4:313\n*S KotlinDebug\n*F\n+ 1 DockerComposeDeployer.kt\ncom/intellij/docker/runtimes/deploy/DockerComposeDeployerKt\n*L\n217#1:270\n217#1:271,3\n232#1:274,10\n232#1:284\n232#1:286\n232#1:287\n243#1:288,10\n243#1:298\n243#1:300\n243#1:301\n247#1:302\n247#1:303,2\n247#1:305,2\n247#1:307,4\n264#1:311,2\n232#1:285\n243#1:299\n47#1:313\n*E\n"})
public final class DockerComposeDeployerKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(DockerComposeDeployerKt::logger_delegate$lambda$0);

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    private static final boolean shouldRestartOnDeploy(DockerComposeDeployer.DeployInfo $this$shouldRestartOnDeploy, String composeProject, DockerRuntimeContext context) {
        if ($this$shouldRestartOnDeploy.getServices().length != 1) {
            return false;
        }
        if ($this$shouldRestartOnDeploy.getDeployment().isUpForceRecreate()) {
            return false;
        }
        if (DockerComposeDeploymentSourceType.getInstance().isForceBuild($this$shouldRestartOnDeploy.getDeployment())) {
            return false;
        }
        DockerRuntimesManager manager = context.getRuntimesManager();
        ComposeServiceRuntime composeServiceRuntime = manager.findComposeService(composeProject, $this$shouldRestartOnDeploy.getServices()[0]);
        return (composeServiceRuntime != null ? composeServiceRuntime.getServiceStatus() : null) == ComposeServiceStatus.UP;
    }

    @NotNull
    public static final String computeComposeProjectName(@NotNull DeploymentTask<DockerDeploymentConfiguration> $this$computeComposeProjectName, @NotNull DockerRuntimeContext context) {
        Intrinsics.checkNotNullParameter($this$computeComposeProjectName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<File> composeFiles = DockerComposeDeployerKt.getComposeFiles($this$computeComposeProjectName);
        return DockerComposeDeployerKt.computeComposeProjectName($this$computeComposeProjectName, context, composeFiles, DockerComposeDeployerKt.computeWorkingDir(composeFiles));
    }

    /*
     * WARNING - void declaration
     */
    private static final String computeComposeProjectName(DeploymentTask<DockerDeploymentConfiguration> $this$computeComposeProjectName, DockerRuntimeContext context, List<? extends File> composeFiles, File workdir) {
        String string = StringKt.nullize((String)((DockerDeploymentConfiguration)$this$computeComposeProjectName.getConfiguration()).getComposeProjectName(), (boolean)true);
        if (string == null) {
            Object $this$computeComposeProjectName_u24lambda_u240_u240;
            boolean bl = false;
            DockerComposeFileConfigurationProvider parser = DockerComposeFileConfigurationProvider.Companion.getInstance();
            DockerComposeDeployer.DeployInfo deployInfo = new DockerComposeDeployer.DeployInfo(composeFiles, $this$computeComposeProjectName);
            Object object = $this$computeComposeProjectName;
            try {
                void $this$mapTo$iv$iv;
                $this$computeComposeProjectName_u24lambda_u240_u240 = object;
                boolean bl2 = false;
                Object $this$map$iv = deployInfo.getComposeFiles();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getPath());
                }
                List list = (List)destination$iv$iv;
                $this$map$iv = context.getServerConfiguration();
                $this$computeComposeProjectName_u24lambda_u240_u240 = Result.constructor-impl((Object)((String)DockerComposeFileConfigurationProvider.getConfigFor$default(parser, (DockerCloudConfiguration)((Object)$this$map$iv), list, null, 4, null).accept((DockerComposeConfiguration.Visitor)new DockerComposeConfiguration.Visitor<String>(){

                    public String visit(DockerComposeConfigurationV1 configuration) {
                        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                        return null;
                    }

                    public String visit(DockerComposeConfigurationV2 configuration) {
                        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                        return configuration.getName();
                    }
                })));
            }
            catch (Throwable bl2) {
                $this$computeComposeProjectName_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$computeComposeProjectName_u24lambda_u240_u240;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Object it = $this$computeComposeProjectName_u24lambda_u240_u240 = throwable;
                boolean bl4 = false;
                DockerComposeDeployerKt.getLogger().warn(it);
            }
            if ((string = (String)(Result.isFailure-impl(object) ? null : object)) == null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                String string2 = workdir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                Path path2 = Paths.get(string2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                object = deployInfo.getEnvFiles();
                Path path3 = path2;
                ComposeApplicationRuntime.Companion companion = ComposeApplicationRuntime.Companion;
                boolean $i$f$mapNotNull = false;
                void it = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl5 = false;
                    String it2 = (String)element$iv$iv;
                    boolean bl6 = false;
                    if (StringKt.nullize((String)it2, (boolean)true) == null) continue;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                string = companion.computeEnvVarAwareProjectName(path3, list);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getComposeFiles(@NotNull DeploymentTask<DockerDeploymentConfiguration> $this$getComposeFiles) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter($this$getComposeFiles, (String)"<this>");
        List paths = new LinkedList();
        paths.add(((DockerDeploymentConfiguration)$this$getComposeFiles.getConfiguration()).getSourceFilePath());
        paths.addAll((Collection)((DockerDeploymentConfiguration)$this$getComposeFiles.getConfiguration()).getSecondarySourceFiles());
        Iterable iterable = paths;
        Project project = $this$getComposeFiles.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (DockerDeploymentConfigurationUtilsKt.resolveFile(project2, p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, String> getTaskEnvironment(DeploymentTask<DockerDeploymentConfiguration> task) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ((DockerDeploymentConfiguration)task.getConfiguration()).getEnvVars();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DockerEnvVarImpl it = (DockerEnvVarImpl)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            boolean bl2 = ((CharSequence)string).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            DockerEnvVarImpl it = (DockerEnvVarImpl)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string3 = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            Pair pair = new Pair((Object)string2, (Object)((Object)StringsKt.trim((CharSequence)string3)).toString());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final File computeWorkingDir(List<? extends File> composeFiles) throws ServerRuntimeException {
        DockerComposeDeployerKt.validateComposeFiles(composeFiles);
        File file = composeFiles.get(0).getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return file;
    }

    private static final void validateComposeFiles(List<? extends File> files) throws ServerRuntimeException {
        Object v0;
        block3: {
            if (files.isEmpty()) {
                throw new ServerRuntimeException("Compose file is not specified");
            }
            Iterable $this$firstOrNull$iv = files;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!(!it.exists() || !it.isFile())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        File firstMissing = v0;
        if (firstMissing != null) {
            throw new ServerRuntimeException("Can't read compose file at " + firstMissing);
        }
    }

    private static final Logger logger_delegate$lambda$0() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerComposeDeployer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public static final /* synthetic */ File access$computeWorkingDir(List composeFiles) {
        return DockerComposeDeployerKt.computeWorkingDir(composeFiles);
    }

    public static final /* synthetic */ String access$computeComposeProjectName(DeploymentTask $receiver, DockerRuntimeContext context, List composeFiles, File workdir) {
        return DockerComposeDeployerKt.computeComposeProjectName((DeploymentTask<DockerDeploymentConfiguration>)$receiver, context, composeFiles, workdir);
    }

    public static final /* synthetic */ Map access$getTaskEnvironment(DeploymentTask task) {
        return DockerComposeDeployerKt.getTaskEnvironment((DeploymentTask<DockerDeploymentConfiguration>)task);
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return DockerComposeDeployerKt.getLogger();
    }

    public static final /* synthetic */ boolean access$shouldRestartOnDeploy(DockerComposeDeployer.DeployInfo $receiver, String composeProject, DockerRuntimeContext context) {
        return DockerComposeDeployerKt.shouldRestartOnDeploy($receiver, composeProject, context);
    }
}

