/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.splitApi;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.splitApi.DockerDtoConvertersKt;
import com.intellij.docker.splitApi.DockerServerRuntimeEventDto;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0012\u0010\u0011\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0012\u0010\u0012\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/splitApi/DockerRuntimeEventsCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "serverEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/docker/splitApi/DockerServerRuntimeEventDto;", "getServerEvents", "Lkotlinx/coroutines/flow/Flow;", "fireServerRuntimeAdded", "", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "fireServerRuntimeRemoved", "fireServerRuntimeChanged", "isApplicable", "", "Companion", "intellij.clouds.docker"})
public final class DockerRuntimeEventsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableSharedFlow<DockerServerRuntimeEventDto> serverEvents;

    public DockerRuntimeEventsCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.serverEvents = SharedFlowKt.MutableSharedFlow((int)1000, (int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Flow<DockerServerRuntimeEventDto> getServerEvents() {
        return (Flow)FlowKt.asSharedFlow(this.serverEvents);
    }

    public final void fireServerRuntimeAdded(@NotNull RemoteServer<?> server2) {
        Intrinsics.checkNotNullParameter(server2, (String)"server");
        if (this.isApplicable(server2)) {
            this.serverEvents.tryEmit((Object)DockerDtoConvertersKt.createRemoteServerAddedEvent(server2));
        }
    }

    public final void fireServerRuntimeRemoved(@NotNull RemoteServer<?> server2) {
        Intrinsics.checkNotNullParameter(server2, (String)"server");
        if (this.isApplicable(server2)) {
            this.serverEvents.tryEmit((Object)DockerDtoConvertersKt.createRemoteServerRemovedEvent(server2));
        }
    }

    public final void fireServerRuntimeChanged(@NotNull RemoteServer<?> server2) {
        Intrinsics.checkNotNullParameter(server2, (String)"server");
        if (this.isApplicable(server2)) {
            this.serverEvents.tryEmit((Object)DockerDtoConvertersKt.createRemoteServerChangedEvent(server2));
        }
    }

    private final boolean isApplicable(RemoteServer<?> server2) {
        ServerConfiguration serverConfiguration = server2.getConfiguration();
        DockerCloudConfiguration dockerCloudConfiguration = serverConfiguration instanceof DockerCloudConfiguration ? (DockerCloudConfiguration)serverConfiguration : null;
        return dockerCloudConfiguration != null ? dockerCloudConfiguration.isVisibleInProject(this.project) : false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/splitApi/DockerRuntimeEventsCollector$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/docker/splitApi/DockerRuntimeEventsCollector;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerRuntimeEventsCollector getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DockerRuntimeEventsCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DockerRuntimeEventsCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

