/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.splitApi.registry;

import com.intellij.docker.agent.registry.model.DockerRegistry;
import com.intellij.docker.splitApi.registry.DockerRegistryDto;
import com.intellij.docker.splitApi.registry.DockerRegistryNamespaceDto;
import com.intellij.docker.splitApi.registry.DockerRegistryRepositoryDto;
import com.intellij.docker.splitApi.registry.DockerRegistryTagDto;
import com.intellij.docker.view.registry.node.DockerNamespaceNode;
import com.intellij.docker.view.registry.node.DockerRegistryRoot;
import com.intellij.docker.view.registry.node.DockerRegistryTagNode;
import com.intellij.docker.view.registry.node.DockerRepositoryNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"toRegistryDto", "Lcom/intellij/docker/splitApi/registry/DockerRegistryDto;", "registryNode", "Lcom/intellij/docker/view/registry/node/DockerRegistryRoot;", "toNamespaceDto", "Lcom/intellij/docker/splitApi/registry/DockerRegistryNamespaceDto;", "namespaceNode", "Lcom/intellij/docker/view/registry/node/DockerNamespaceNode;", "toRepositoryDto", "Lcom/intellij/docker/splitApi/registry/DockerRegistryRepositoryDto;", "repositoryNode", "Lcom/intellij/docker/view/registry/node/DockerRepositoryNode;", "toTagDto", "Lcom/intellij/docker/splitApi/registry/DockerRegistryTagDto;", "tagNode", "Lcom/intellij/docker/view/registry/node/DockerRegistryTagNode;", "intellij.clouds.docker"})
public final class DockerRegistryDtoConvertersKt {
    @NotNull
    public static final DockerRegistryDto toRegistryDto(@NotNull DockerRegistryRoot registryNode) {
        Intrinsics.checkNotNullParameter((Object)registryNode, (String)"registryNode");
        String string = registryNode.getDockerRegistryRootContext().getRegistry().getId();
        String string2 = registryNode.getConfiguration().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = registryNode.getConfiguration().getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAddress(...)");
        String string4 = registryNode.getConfiguration().getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getUsername(...)");
        return new DockerRegistryDto(string, string2, string3, string4);
    }

    @NotNull
    public static final DockerRegistryNamespaceDto toNamespaceDto(@NotNull DockerNamespaceNode namespaceNode) {
        Intrinsics.checkNotNullParameter((Object)namespaceNode, (String)"namespaceNode");
        DockerRegistry.Namespace namespace = namespaceNode.getNamespace();
        return new DockerRegistryNamespaceDto(namespace.getId(), namespace.getName());
    }

    @NotNull
    public static final DockerRegistryRepositoryDto toRepositoryDto(@NotNull DockerRepositoryNode repositoryNode) {
        Intrinsics.checkNotNullParameter((Object)repositoryNode, (String)"repositoryNode");
        return new DockerRegistryRepositoryDto(repositoryNode.getRepository().getId(), repositoryNode.getRepository().getName());
    }

    @NotNull
    public static final DockerRegistryTagDto toTagDto(@NotNull DockerRegistryTagNode tagNode) {
        Intrinsics.checkNotNullParameter((Object)tagNode, (String)"tagNode");
        return new DockerRegistryTagDto(tagNode.getTag().getId(), tagNode.getTag().getName());
    }
}

