/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.splitApi.registry;

import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.view.registry.node.DockerNamespaceNode;
import com.intellij.docker.view.registry.node.DockerRegistryRoot;
import com.intellij.docker.view.registry.node.DockerRegistryTagNode;
import com.intellij.docker.view.registry.node.DockerRepositoryNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/splitApi/registry/DockerRegistryLookup;", "", "<init>", "()V", "findDockerRegistryRootById", "Lcom/intellij/docker/view/registry/node/DockerRegistryRoot;", "id", "", "findDockerNamespaceNodeByIds", "Lcom/intellij/docker/view/registry/node/DockerNamespaceNode;", "rootId", "namespaceId", "findDockerRepositoryNodeByIds", "Lcom/intellij/docker/view/registry/node/DockerRepositoryNode;", "repoId", "findRepositoryNodeById", "registryRoot", "selectedNodeId", "registryId", "findTagNodeById", "Lcom/intellij/docker/view/registry/node/DockerRegistryTagNode;", "tagId", "intellij.clouds.docker"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDockerRegistryLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRegistryLookup.kt\ncom/intellij/docker/splitApi/registry/DockerRegistryLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1#2:51\n1391#3:52\n1480#3,5:53\n1391#3:58\n1480#3,5:59\n1391#3:64\n1480#3,5:65\n*S KotlinDebug\n*F\n+ 1 DockerRegistryLookup.kt\ncom/intellij/docker/splitApi/registry/DockerRegistryLookup\n*L\n30#1:52\n30#1:53,5\n41#1:58\n41#1:59,5\n42#1:64\n42#1:65,5\n*E\n"})
public final class DockerRegistryLookup {
    @NotNull
    public static final DockerRegistryLookup INSTANCE = new DockerRegistryLookup();

    private DockerRegistryLookup() {
    }

    @Nullable
    public final DockerRegistryRoot findDockerRegistryRootById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return DockerRegistryManager.getInstance().findRegistryRootById(id);
    }

    @Nullable
    public final DockerNamespaceNode findDockerNamespaceNodeByIds(@NotNull String rootId, @NotNull String namespaceId) {
        DockerNamespaceNode dockerNamespaceNode;
        List<DockerNamespaceNode> list;
        Intrinsics.checkNotNullParameter((Object)rootId, (String)"rootId");
        Intrinsics.checkNotNullParameter((Object)namespaceId, (String)"namespaceId");
        DockerRegistryRoot dockerRegistryRoot = this.findDockerRegistryRootById(rootId);
        if (dockerRegistryRoot != null && (list = dockerRegistryRoot.getNamespaceNodesIfInitialized()) != null) {
            Object v0;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    DockerNamespaceNode it = (DockerNamespaceNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getNamespace().getId(), (Object)namespaceId)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            dockerNamespaceNode = v0;
        } else {
            dockerNamespaceNode = null;
        }
        return dockerNamespaceNode;
    }

    @Nullable
    public final DockerRepositoryNode findDockerRepositoryNodeByIds(@NotNull String rootId, @NotNull String namespaceId, @NotNull String repoId) {
        DockerRepositoryNode dockerRepositoryNode;
        List<DockerRepositoryNode> list;
        Intrinsics.checkNotNullParameter((Object)rootId, (String)"rootId");
        Intrinsics.checkNotNullParameter((Object)namespaceId, (String)"namespaceId");
        Intrinsics.checkNotNullParameter((Object)repoId, (String)"repoId");
        DockerNamespaceNode dockerNamespaceNode = this.findDockerNamespaceNodeByIds(rootId, namespaceId);
        if (dockerNamespaceNode != null && (list = dockerNamespaceNode.getRepositoryNodesIfInitialized()) != null) {
            Object v0;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    DockerRepositoryNode it = (DockerRepositoryNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getRepository().getId(), (Object)repoId)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            dockerRepositoryNode = v0;
        } else {
            dockerRepositoryNode = null;
        }
        return dockerRepositoryNode;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DockerRepositoryNode findRepositoryNodeById(@NotNull DockerRegistryRoot registryRoot, @NotNull String selectedNodeId) {
        Object v0;
        block2: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)registryRoot, (String)"registryRoot");
            Intrinsics.checkNotNullParameter((Object)selectedNodeId, (String)"selectedNodeId");
            Iterable $this$flatMap$iv = registryRoot.getNamespaceNodesIfInitialized();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DockerNamespaceNode ns = (DockerNamespaceNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ns.getRepositoryNodesIfInitialized();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                DockerRepositoryNode it = (DockerRepositoryNode)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNodeId(), (Object)selectedNodeId)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final DockerRepositoryNode findRepositoryNodeById(@NotNull String registryId, @NotNull String selectedNodeId) {
        Intrinsics.checkNotNullParameter((Object)registryId, (String)"registryId");
        Intrinsics.checkNotNullParameter((Object)selectedNodeId, (String)"selectedNodeId");
        DockerRegistryRoot dockerRegistryRoot = this.findDockerRegistryRootById(registryId);
        if (dockerRegistryRoot == null) {
            return null;
        }
        DockerRegistryRoot root = dockerRegistryRoot;
        return this.findRepositoryNodeById(root, selectedNodeId);
    }

    @Nullable
    public final DockerRegistryTagNode findTagNodeById(@NotNull DockerRegistryRoot registryRoot, @NotNull String selectedNodeId) {
        Object v0;
        block3: {
            Iterable list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)registryRoot, (String)"registryRoot");
            Intrinsics.checkNotNullParameter((Object)selectedNodeId, (String)"selectedNodeId");
            Iterable $this$flatMap$iv = registryRoot.getNamespaceNodesIfInitialized();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DockerNamespaceNode ns = (DockerNamespaceNode)element$iv$iv;
                boolean bl = false;
                list$iv$iv = ns.getRepositoryNodesIfInitialized();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DockerRepositoryNode repo = (DockerRepositoryNode)element$iv$iv;
                boolean bl = false;
                list$iv$iv = repo.getTagNodesIfInitialized();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                DockerRegistryTagNode it = (DockerRegistryTagNode)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNodeId(), (Object)selectedNodeId)) continue;
                v0 = e;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final DockerRegistryTagNode findTagNodeById(@NotNull String registryId, @NotNull String tagId) {
        Intrinsics.checkNotNullParameter((Object)registryId, (String)"registryId");
        Intrinsics.checkNotNullParameter((Object)tagId, (String)"tagId");
        DockerRegistryRoot dockerRegistryRoot = this.findDockerRegistryRootById(registryId);
        if (dockerRegistryRoot == null) {
            return null;
        }
        DockerRegistryRoot root = dockerRegistryRoot;
        return this.findTagNodeById(root, tagId);
    }
}

