/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.splitApi.registry;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.splitApi.registry.DockerRegistryActionUtilsInterface;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/splitApi/registry/DockerServerEventCollector;", "Lcom/intellij/docker/splitApi/registry/DockerRegistryActionUtilsInterface;", "<init>", "()V", "dockerServerCount", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "emitDockerServerCount", "", "getDockerServerCount", "Lkotlinx/coroutines/flow/Flow;", "getDockerServersCount", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerServerEventCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerServerEventCollector.kt\ncom/intellij/docker/splitApi/registry/DockerServerEventCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1834#2,4:50\n*S KotlinDebug\n*F\n+ 1 DockerServerEventCollector.kt\ncom/intellij/docker/splitApi/registry/DockerServerEventCollector\n*L\n42#1:50,4\n*E\n"})
public final class DockerServerEventCollector
implements DockerRegistryActionUtilsInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableStateFlow<Integer> dockerServerCount = StateFlowKt.MutableStateFlow((Object)0);

    public DockerServerEventCollector() {
        this.emitDockerServerCount();
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = RemoteServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new RemoteServerListener(){

            public void serverAdded(RemoteServer<?> server2) {
                Intrinsics.checkNotNullParameter(server2, (String)"server");
                if (Intrinsics.areEqual((Object)server2.getType(), (Object)((Object)DockerCloudType.getInstance()))) {
                    this.emitDockerServerCount();
                }
            }

            public void serverRemoved(RemoteServer<?> server2) {
                Intrinsics.checkNotNullParameter(server2, (String)"server");
                if (Intrinsics.areEqual((Object)server2.getType(), (Object)((Object)DockerCloudType.getInstance()))) {
                    this.emitDockerServerCount();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void emitDockerServerCount() {
        int n;
        void $this$count$iv;
        Iterable iterable = DockerUtils.getDockerServers();
        MutableStateFlow<Integer> mutableStateFlow = this.dockerServerCount;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_4;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RemoteServer it = (RemoteServer)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)((Object)DockerCloudType.getInstance())) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_4;
        }
        int n2 = n;
        mutableStateFlow.tryEmit((Object)n2);
    }

    @NotNull
    public final Flow<Integer> getDockerServerCount() {
        return (Flow)FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this.dockerServerCount));
    }

    public int getDockerServersCount() {
        return ((Number)DockerServerEventCollector.Companion.getInstance().dockerServerCount.getValue()).intValue();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/splitApi/registry/DockerServerEventCollector$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/docker/splitApi/registry/DockerServerEventCollector;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerServerEventCollector getInstance() {
            Object object = ApplicationManager.getApplication().getService(DockerServerEventCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DockerServerEventCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

