/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tJ\"\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\tR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/utils/TruncatedLogger;", "", "log", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "alreadyLoggedBytes", "", "logSingleByteRead", "value", "logSingleByteWrite", "logBytes", "b", "", "off", "len", "Companion", "intellij.clouds.docker"})
final class TruncatedLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Unit> log;
    private int alreadyLoggedBytes;
    @NotNull
    private static final String EOF_MARKER = "[EOF]";

    public TruncatedLogger(@NotNull Function1<? super String, Unit> log) {
        Intrinsics.checkNotNullParameter(log, (String)"log");
        this.log = log;
    }

    public final void logSingleByteRead(int value) {
        if (value == -1) {
            this.log.invoke((Object)EOF_MARKER);
        } else {
            byte[] byArray = new byte[]{(byte)value};
            TruncatedLogger.logBytes$default(this, byArray, 0, 0, 6, null);
        }
    }

    public final void logSingleByteWrite(int value) {
        byte[] byArray = new byte[]{(byte)(value & 0xFF)};
        TruncatedLogger.logBytes$default(this, byArray, 0, 0, 6, null);
    }

    public final void logBytes(@NotNull byte[] b, int off, int len) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (len == 0) {
            return;
        }
        if (len == -1) {
            object = EOF_MARKER;
        } else if (this.alreadyLoggedBytes >= 1000) {
            object = "... truncated " + len + " bytes";
        } else if (this.alreadyLoggedBytes + len > 1000) {
            int chunkLen = 1000 - this.alreadyLoggedBytes;
            this.alreadyLoggedBytes = 1000;
            object = new String(b, off, chunkLen, Charsets.UTF_8) + "... truncated " + (len - chunkLen) + " bytes";
        } else {
            this.alreadyLoggedBytes += len;
            object = new String(b, off, len, Charsets.UTF_8);
        }
        String message = object;
        this.log.invoke((Object)message);
    }

    public static /* synthetic */ void logBytes$default(TruncatedLogger truncatedLogger, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        truncatedLogger.logBytes(byArray, n, n2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/utils/TruncatedLogger$Companion;", "", "<init>", "()V", "EOF_MARKER", "", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

