/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassLiteralExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtCollectionLiteralExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007b\u0002\b\bJ\u0018\u0010\t\u001a\u00020\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\n\u0010\u000e\u001a\u00020\u000f*\u00020\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ElementTypeUtils;", "", "<init>", "()V", "getKotlinBlockImbalanceCount", "", "seq", "", "Lkotlin/jvm/JvmStatic;", "getOperationSymbol", "Lorg/jetbrains/kotlin/lexer/KtToken;", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "isExpression", "", "psi-impl"})
public final class ElementTypeUtils {
    @NotNull
    public static final ElementTypeUtils INSTANCE = new ElementTypeUtils();

    private ElementTypeUtils() {
    }

    @JvmStatic
    public static final int getKotlinBlockImbalanceCount(@NotNull CharSequence seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        KotlinLexer lexer = new KotlinLexer();
        lexer.start(seq);
        if (lexer.getTokenType() != KtTokens.LBRACE) {
            return Integer.MIN_VALUE;
        }
        lexer.advance();
        int balance = 1;
        while (!Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)((Object)KtTokens.EOF)) && lexer.getTokenType() != null) {
            IElementType type;
            if (balance == 0) {
                return Integer.MIN_VALUE;
            }
            if (type == KtTokens.LBRACE) {
                ++balance;
            } else if (type == KtTokens.RBRACE) {
                --balance;
            }
            lexer.advance();
        }
        return balance;
    }

    @NotNull
    public final KtToken getOperationSymbol(@NotNull LighterASTNode $this$getOperationSymbol, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Intrinsics.checkNotNullParameter((Object)$this$getOperationSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        boolean bl = Intrinsics.areEqual((Object)$this$getOperationSymbol.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LighterASTNode lighterASTNode = LightTreeUtilsKt.getSingleChildOrNull($this$getOperationSymbol, tree);
        Intrinsics.checkNotNull((Object)lighterASTNode);
        IElementType iElementType = lighterASTNode.getTokenType();
        Intrinsics.checkNotNull((Object)iElementType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
        return (KtToken)iElementType;
    }

    public final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$isExpression, (String)"<this>");
        IElementType tokenType = $this$isExpression.getTokenType();
        return tokenType instanceof KtNodeType || tokenType instanceof KtConstantExpressionElementType || tokenType instanceof KtStringTemplateExpressionElementType || tokenType instanceof KtClassLiteralExpressionElementType || tokenType instanceof KtCollectionLiteralExpressionElementType || Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.LAMBDA_EXPRESSION) ? true : (tokenType instanceof KtStubElementType ? ((KtStubElementType)tokenType).isExpression() : false);
    }
}

