/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltInDefinitionFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInDecompilationInterceptor;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInStubVersionOffsetProvider;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinBuiltInMetadataStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "<init>", "()V", "getStubVersion", "", "supportedFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getSupportedFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "expectedBinaryVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getExpectedBinaryVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "readFile", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "createCallableSource", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "file", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "filename", "", "decompiler-to-psi"})
public final class KotlinBuiltInMetadataStubBuilder
extends KotlinMetadataStubBuilder {
    @NotNull
    public static final KotlinBuiltInMetadataStubBuilder INSTANCE = new KotlinBuiltInMetadataStubBuilder();

    private KotlinBuiltInMetadataStubBuilder() {
    }

    public int getStubVersion() {
        return 236 + KotlinBuiltInStubVersionOffsetProvider.Companion.getVersionOffset();
    }

    @Override
    @NotNull
    protected FileType getSupportedFileType() {
        return KotlinBuiltInFileType.INSTANCE;
    }

    @Override
    @NotNull
    protected BinaryVersion getExpectedBinaryVersion() {
        return BuiltInsBinaryVersion.INSTANCE;
    }

    @Override
    @Nullable
    protected KotlinMetadataStubBuilder.FileWithMetadata readFile(@NotNull VirtualFile virtualFile, @Nullable byte[] content) {
        byte[] content2;
        KotlinMetadataStubBuilder.FileWithMetadata fileWithMetadata;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        byte[] byArray = content;
        if (content == null) {
            byte[] byArray2 = virtualFile.contentsToByteArray(false);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"contentsToByteArray(...)");
        }
        if ((fileWithMetadata = KotlinBuiltInDecompilationInterceptor.Companion.readFile(content2 = byArray, virtualFile)) == null) {
            fileWithMetadata = BuiltInDefinitionFile.Companion.read$default(BuiltInDefinitionFile.Companion, content2, virtualFile, false, 4, null);
        }
        return fileWithMetadata;
    }

    @Override
    @Nullable
    protected SourceElement createCallableSource(@NotNull KotlinMetadataStubBuilder.FileWithMetadata.Compatible file, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String withoutExtension = StringsKt.removeSuffix((String)filename, (CharSequence)".kotlin_builtins");
        String fileNameForFacade = Intrinsics.areEqual((Object)withoutExtension, (Object)"kotlin") ? "library" : withoutExtension;
        FqName facadeFqName = PackagePartClassUtils.getPackagePartFqName(file.getPackageFqName(), fileNameForFacade);
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.Companion.topLevel(facadeFqName));
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(...)");
        ProtoBuf.Package package_ = file.getProto().getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
        return new JvmPackagePartSource(jvmClassName, null, null, package_, file.getNameResolver(), null, null, null, null, 480, null);
    }
}

