/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.openapi.util.TextRange;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007b\u0002\b\u000bR\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u0092\u0002\u0002\b\u0007\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/DiagnosticRangeUtils;", "", "<init>", "()V", "TEXT_RANGE_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/openapi/util/TextRange;", "Lkotlin/jvm/JvmField;", "firstRange", "ranges", "", "Lkotlin/jvm/JvmStatic;", "frontend.common"})
public final class DiagnosticRangeUtils {
    @NotNull
    public static final DiagnosticRangeUtils INSTANCE = new DiagnosticRangeUtils();
    @JvmField
    @NotNull
    public static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = DiagnosticRangeUtils::TEXT_RANGE_COMPARATOR$lambda$0;

    private DiagnosticRangeUtils() {
    }

    @JvmStatic
    @NotNull
    public static final TextRange firstRange(@NotNull List<? extends TextRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        return (TextRange)CollectionsKt.minWithOrThrow((Iterable)ranges, TEXT_RANGE_COMPARATOR);
    }

    private static final int TEXT_RANGE_COMPARATOR$lambda$0(TextRange o1, TextRange o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        if (o1.getStartOffset() != o2.getStartOffset()) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
        return o1.getEndOffset() - o2.getEndOffset();
    }
}

