/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElementImpl;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "Lorg/jetbrains/kotlin/psi/KtElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "getContainingDoc", "Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "getContainingSection", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "getQualifier", "getNameTextRange", "Lcom/intellij/openapi/util/TextRange;", "getNameText", "", "getQualifiedName", "", "getQualifiedNameAsFqName", "Lorg/jetbrains/kotlin/name/FqName;", "psi-api"})
@SourceDebugExtension(value={"SMAP\nKDocName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KDocName.kt\norg/jetbrains/kotlin/kdoc/psi/impl/KDocName\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,72:1\n249#2:73\n249#2:74\n261#2:75\n*S KotlinDebug\n*F\n+ 1 KDocName.kt\norg/jetbrains/kotlin/kdoc/psi/impl/KDocName\n*L\n33#1:73\n38#1:74\n42#1:75\n*E\n"})
public final class KDocName
extends KtElementImpl {
    public KDocName(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @NotNull
    public final KDoc getContainingDoc() {
        KDoc kdoc;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)this;
        boolean $i$f$getStrictParentOfType = false;
        KDoc kDoc = kdoc = (KDoc)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KDoc.class, (boolean)true);
        if (kDoc == null) {
            throw new IllegalStateException("KDocName must be inside a KDoc");
        }
        return kDoc;
    }

    @NotNull
    public final KDocSection getContainingSection() {
        KDocSection kdoc;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)this;
        boolean $i$f$getStrictParentOfType = false;
        KDocSection kDocSection = kdoc = (KDocSection)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KDocSection.class, (boolean)true);
        if (kDocSection == null) {
            throw new IllegalStateException("KDocName must be inside a KDocSection");
        }
        return kDocSection;
    }

    @Nullable
    public final KDocName getQualifier() {
        PsiElement $this$getChildOfType$iv = (PsiElement)this;
        boolean $i$f$getChildOfType = false;
        return (KDocName)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KDocName.class);
    }

    @NotNull
    public final TextRange getNameTextRange() {
        ASTNode dot = this.getNode().findChildByType((IElementType)KtTokens.DOT);
        TextRange textRange = this.getTextRange();
        ASTNode aSTNode = dot;
        int nameStart = aSTNode != null ? aSTNode.getTextRange().getEndOffset() - textRange.getStartOffset() : 0;
        int nameEnd = textRange.getLength();
        if (nameEnd - nameStart >= 2 && this.getText().charAt(nameStart) == '`' && this.getText().charAt(nameEnd - 1) == '`') {
            ++nameStart;
            --nameEnd;
        }
        return new TextRange(nameStart, nameEnd);
    }

    @NotNull
    public final String getNameText() {
        String string = this.getNameTextRange().substring(this.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final List<String> getQualifiedName() {
        KDocName qualifier = this.getQualifier();
        List nameAsList = CollectionsKt.listOf((Object)this.getNameText());
        KDocName kDocName = qualifier;
        return kDocName != null ? CollectionsKt.plus((Collection)kDocName.getQualifiedName(), (Iterable)nameAsList) : nameAsList;
    }

    @NotNull
    public final FqName getQualifiedNameAsFqName() {
        return FqName.Companion.fromSegments(this.getQualifiedName());
    }
}

