/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.components.KlibMetadataComponentLayout;
import org.jetbrains.kotlin.library.writer.KlibComponentWriter;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/impl/KlibMetadataComponentWriterImpl;", "Lorg/jetbrains/kotlin/library/writer/KlibComponentWriter;", "metadata", "Lorg/jetbrains/kotlin/library/SerializedMetadata;", "(Lorg/jetbrains/kotlin/library/SerializedMetadata;)V", "writeTo", "", "root", "Lorg/jetbrains/kotlin/konan/file/File;", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKlibMetadataComponentWriterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibMetadataComponentWriterImpl.kt\norg/jetbrains/kotlin/library/impl/KlibMetadataComponentWriterImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1878#2,2:45\n1878#2,3:47\n1880#2:50\n*S KotlinDebug\n*F\n+ 1 KlibMetadataComponentWriterImpl.kt\norg/jetbrains/kotlin/library/impl/KlibMetadataComponentWriterImpl\n*L\n25#1:45,2\n35#1:47,3\n25#1:50\n*E\n"})
public final class KlibMetadataComponentWriterImpl
implements KlibComponentWriter {
    @NotNull
    private final SerializedMetadata metadata;

    public KlibMetadataComponentWriterImpl(@NotNull SerializedMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.metadata = metadata;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTo(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        KlibMetadataComponentLayout layout = new KlibMetadataComponentLayout(root);
        layout.getMetadataDir().mkdirs();
        layout.getModuleHeaderFile().writeBytes(this.metadata.getModule());
        Iterable $this$forEachIndexed$iv = this.metadata.getFragmentNames();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void packageFqName;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            File packageFragmentDir = layout.getPackageFragmentsDir((String)packageFqName);
            packageFragmentDir.mkdirs();
            String shortPackageName = StringsKt.substringAfterLast$default((String)packageFqName, (String)".", null, (int)2, null);
            List<byte[]> packageFragmentParts = this.metadata.getFragments().get(index);
            int padding = String.valueOf(packageFragmentParts.size()).length();
            Iterable $this$forEachIndexed$iv2 = packageFragmentParts;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void packageFragmentPart;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                byte[] byArray = (byte[])item$iv2;
                int packageFragmentPartIndex = n2;
                boolean bl2 = false;
                layout.getPackageFragmentFile((String)packageFqName, KlibMetadataComponentWriterImpl.writeTo$lambda$1$withPadding(padding, packageFragmentPartIndex) + '_' + shortPackageName).writeBytes((byte[])packageFragmentPart);
            }
        }
    }

    private static final String writeTo$lambda$1$withPadding(int padding, int packageFragmentPartIndex) {
        String string = "%0" + padding + 'd';
        Object[] objectArray = new Object[]{packageFragmentPartIndex};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

