/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.PerformanceManager;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "perfManager", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "<init>", "(Lorg/jetbrains/kotlin/util/PerformanceManager;)V", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findSourceOrBinaryVirtualFile", "findKotlinClassOrContent", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "classFileName", "", "jClass", "SERVICE", "frontend.common.jvm"})
@SourceDebugExtension(value={"SMAP\nVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileFinder.kt\norg/jetbrains/kotlin/load/kotlin/VirtualFileFinder\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,70:1\n19#2:71\n*S KotlinDebug\n*F\n+ 1 VirtualFileFinder.kt\norg/jetbrains/kotlin/load/kotlin/VirtualFileFinder\n*L\n48#1:71\n*E\n"})
public abstract class VirtualFileFinder
implements KotlinClassFinder {
    @NotNull
    public static final SERVICE SERVICE = new SERVICE(null);
    @Nullable
    private final PerformanceManager perfManager;

    public VirtualFileFinder(@Nullable PerformanceManager perfManager) {
        this.perfManager = perfManager;
    }

    public /* synthetic */ VirtualFileFinder(PerformanceManager performanceManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            performanceManager = null;
        }
        this(performanceManager);
    }

    @Nullable
    public abstract VirtualFile findVirtualFileWithHeader(@NotNull ClassId var1);

    @Nullable
    public abstract VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId var1);

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, file, metadataVersion, null, this.perfManager, 4, null);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        VirtualFileBoundJavaClass virtualFileBoundJavaClass = javaClass instanceof VirtualFileBoundJavaClass ? (VirtualFileBoundJavaClass)javaClass : null;
        if (virtualFileBoundJavaClass == null || (virtualFileBoundJavaClass = virtualFileBoundJavaClass.getVirtualFile()) == null) {
            return null;
        }
        VirtualFileBoundJavaClass file = virtualFileBoundJavaClass;
        if (javaClass.getOuterClass() != null) {
            VirtualFile virtualFile = file.getParent();
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile $this$sure$iv = virtualFile.findChild(this.classFileName(javaClass) + ".class");
            boolean $i$f$sure = false;
            VirtualFile virtualFile2 = $this$sure$iv;
            if (virtualFile2 == null) {
                boolean bl = false;
                String string = "Virtual file not found for " + javaClass;
                throw new AssertionError((Object)string);
            }
            file = virtualFile2;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, (VirtualFile)file, metadataVersion, null, this.perfManager, 4, null);
    }

    private final String classFileName(JavaClass jClass) {
        String string = jClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String simpleName = string;
        JavaClass javaClass = jClass.getOuterClass();
        if (javaClass == null) {
            return simpleName;
        }
        JavaClass outerClass = javaClass;
        return this.classFileName(outerClass) + '$' + simpleName;
    }

    public VirtualFileFinder() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder$SERVICE;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "frontend.common.jvm"})
    public static final class SERVICE {
        private SERVICE() {
        }

        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project, @Nullable ModuleInfo module) {
            VirtualFileFinder virtualFileFinder;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFileFinderFactory factory = VirtualFileFinderFactory.SERVICE.getInstance(project);
            if (module == null) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
                virtualFileFinder = factory.create(globalSearchScope);
            } else {
                virtualFileFinder = factory.create(project, module);
            }
            return virtualFileFinder;
        }

        public /* synthetic */ SERVICE(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

