/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.stats;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.stats.MarkdownTableRenderer;
import org.jetbrains.kotlin.stats.ModulesReportsData;
import org.jetbrains.kotlin.stats.StatsCalculator;
import org.jetbrains.kotlin.stats.TimestampReportsData;
import org.jetbrains.kotlin.util.DynamicStats;
import org.jetbrains.kotlin.util.GarbageCollectionStats;
import org.jetbrains.kotlin.util.KlibElementStats;
import org.jetbrains.kotlin.util.PhaseSideType;
import org.jetbrains.kotlin.util.PhaseType;
import org.jetbrains.kotlin.util.SideStats;
import org.jetbrains.kotlin.util.Time;
import org.jetbrains.kotlin.util.TimeRatio;
import org.jetbrains.kotlin.util.UnitStats;
import org.jetbrains.kotlin.util.UnitStatsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001aH\u0002J|\u0010\u001f\u001a\u00020\u0018\"\u000e\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0!*\u00060\u0019j\u0002`\u001a2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00112\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H 0%26\u0010&\u001a2\u0012\u0013\u0012\u0011H \u00a2\u0006\f\b(\u0012\b\b\"\u0012\u0004\b\b()\u0012\u0013\u0012\u0011H \u00a2\u0006\f\b(\u0012\b\b\"\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u00160'H\u0002J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0014\u00100\u001a\u00020\u0016*\u00020\n2\u0006\u00101\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/stats/MarkdownReportRenderer;", "", "statsCalculator", "Lorg/jetbrains/kotlin/stats/StatsCalculator;", "<init>", "(Lorg/jetbrains/kotlin/stats/StatsCalculator;)V", "getStatsCalculator", "()Lorg/jetbrains/kotlin/stats/StatsCalculator;", "unitStats", "", "Lorg/jetbrains/kotlin/util/UnitStats;", "getUnitStats", "()Ljava/util/Collection;", "totalStats", "getTotalStats", "()Lorg/jetbrains/kotlin/util/UnitStats;", "isTimestampMode", "", "()Z", "aggregatedStats", "getAggregatedStats", "render", "", "renderInfo", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderAggregateTimeStats", "renderSystemStats", "renderKlibStats", "renderTopUnitStats", "renderTopModules", "R", "", "name", "max", "selector", "Lkotlin/Function1;", "printer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "moduleResult", "totalResult", "formatTime", "ratio", "", "nanos", "", "getTitleName", "total", "dateTimeFormatter", "Ljava/text/SimpleDateFormat;", "Companion", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nMarkdownReportRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownReportRenderer.kt\norg/jetbrains/kotlin/stats/MarkdownReportRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1#2:231\n1915#3,2:232\n1915#3,2:234\n*S KotlinDebug\n*F\n+ 1 MarkdownReportRenderer.kt\norg/jetbrains/kotlin/stats/MarkdownReportRenderer\n*L\n112#1:232,2\n79#1:234,2\n*E\n"})
public final class MarkdownReportRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StatsCalculator statsCalculator;
    @NotNull
    private final Collection<UnitStats> unitStats;
    @NotNull
    private final UnitStats totalStats;
    private final boolean isTimestampMode;
    @NotNull
    private final UnitStats aggregatedStats;
    @NotNull
    private final SimpleDateFormat dateTimeFormatter;
    public static final int TOP_MODULE_COUNT = 10;

    /*
     * WARNING - void declaration
     */
    public MarkdownReportRenderer(@NotNull StatsCalculator statsCalculator) {
        void $this$dateTimeFormatter_u24lambda_u240;
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkNotNullParameter((Object)statsCalculator, (String)"statsCalculator");
        this.statsCalculator = statsCalculator;
        this.unitStats = this.statsCalculator.getUnitStats();
        this.totalStats = this.statsCalculator.getTotalStats();
        this.isTimestampMode = this.statsCalculator.getReportsData() instanceof TimestampReportsData;
        this.aggregatedStats = this.isTimestampMode ? this.statsCalculator.getAverageStats() : this.totalStats;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        MarkdownReportRenderer markdownReportRenderer = this;
        boolean bl = false;
        $this$dateTimeFormatter_u24lambda_u240.setTimeZone(TimeZone.getTimeZone("UTC"));
        markdownReportRenderer.dateTimeFormatter = simpleDateFormat;
    }

    @NotNull
    public final StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    @NotNull
    public final Collection<UnitStats> getUnitStats() {
        return this.unitStats;
    }

    @NotNull
    public final UnitStats getTotalStats() {
        return this.totalStats;
    }

    public final boolean isTimestampMode() {
        return this.isTimestampMode;
    }

    @NotNull
    public final UnitStats getAggregatedStats() {
        return this.aggregatedStats;
    }

    @NotNull
    public final String render() {
        StringBuilder stringBuilder;
        StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.renderInfo($this$render_u24lambda_u240);
        this.renderAggregateTimeStats($this$render_u24lambda_u240);
        this.renderKlibStats($this$render_u24lambda_u240);
        this.renderSystemStats($this$render_u24lambda_u240);
        if (this.statsCalculator.getUnitStats().size() > 1) {
            this.renderTopUnitStats($this$render_u24lambda_u240);
        }
        return stringBuilder.toString();
    }

    private final void renderInfo(StringBuilder $this$renderInfo) {
        $this$renderInfo.append("# Stats for " + this.getTitleName(this.totalStats, true)).append('\n');
        $this$renderInfo.append('\n');
        $this$renderInfo.append("* Platform: " + (Object)((Object)this.totalStats.getPlatform())).append('\n');
        $this$renderInfo.append("* Has errors: " + this.totalStats.getHasErrors()).append('\n');
        $this$renderInfo.append("* Modules count: " + this.unitStats.size()).append('\n');
        $this$renderInfo.append("* Files count: " + this.totalStats.getFilesCount()).append('\n');
        $this$renderInfo.append("* Lines count: " + this.totalStats.getLinesCount()).append('\n');
        $this$renderInfo.append('\n');
    }

    private final void renderAggregateTimeStats(StringBuilder $this$renderAggregateTimeStats) {
        Time aggregatedTime = this.aggregatedStats.getTotalTime();
        $this$renderAggregateTimeStats.append("# " + (this.isTimestampMode ? "Average" : "Total") + " time").append('\n');
        $this$renderAggregateTimeStats.append('\n');
        long maxTotalTime = Math.max(aggregatedTime.getNanos(), Math.max(aggregatedTime.getUserNanos(), aggregatedTime.getCpuNanos()));
        Iterator iterator2 = ((Iterable)UnitStatsKt.getPhaseTypeName().values()).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        String it422 = (String)iterator2.next();
        boolean bl = false;
        int it422 = it422.length();
        while (iterator2.hasNext()) {
            String it32 = (String)iterator2.next();
            $i$a$-maxOf-MarkdownReportRenderer$renderAggregateTimeStats$nameMaxColumnWidth$1 = false;
            int it32 = it32.length();
            if (it422 >= it32) continue;
            it422 = it32;
        }
        int n = it422;
        Iterator it422 = ((Iterable)UnitStatsKt.getPhaseSideTypeName().values()).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        String it22 = (String)it422.next();
        boolean bl2 = false;
        int it22 = it22.length();
        while (it422.hasNext()) {
            String it = (String)it422.next();
            $i$a$-maxOf-MarkdownReportRenderer$renderAggregateTimeStats$nameMaxColumnWidth$2 = false;
            int n2 = it.length();
            if (it22 >= n2) continue;
            it22 = n2;
        }
        int n3 = it22;
        int nameMaxColumnWidth = Math.max(n, n3);
        int valueMaxColumnWidth = this.formatTime(1.0, maxTotalTime).length();
        MarkdownTableRenderer $this$renderAggregateTimeStats_u24lambda_u242 = new MarkdownTableRenderer(4, nameMaxColumnWidth, valueMaxColumnWidth);
        boolean bl3 = false;
        String[] stringArray = new String[]{"Phase", "Absolute", "User", "Cpu"};
        $this$renderAggregateTimeStats_u24lambda_u242.renderHeader($this$renderAggregateTimeStats, stringArray);
        UnitStatsKt.forEachPhaseMeasurement(this.aggregatedStats, (Function2<? super PhaseType, ? super Time, Unit>)((Function2)(arg_0, arg_1) -> MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$0(this, aggregatedTime, $this$renderAggregateTimeStats_u24lambda_u242, $this$renderAggregateTimeStats, arg_0, arg_1)));
        $this$renderAggregateTimeStats_u24lambda_u242.renderBreak($this$renderAggregateTimeStats);
        UnitStatsKt.forEachPhaseSideMeasurement(this.aggregatedStats, (Function2<? super PhaseSideType, ? super SideStats, Unit>)((Function2)(arg_0, arg_1) -> MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$1(aggregatedTime, $this$renderAggregateTimeStats_u24lambda_u242, $this$renderAggregateTimeStats, this, arg_0, arg_1)));
        $this$renderAggregateTimeStats_u24lambda_u242.renderBreak($this$renderAggregateTimeStats);
        MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$renderTimeLine(aggregatedTime, $this$renderAggregateTimeStats_u24lambda_u242, $this$renderAggregateTimeStats, this, "TOTAL", aggregatedTime);
        $this$renderAggregateTimeStats.append('\n');
    }

    private final void renderSystemStats(StringBuilder $this$renderSystemStats) {
        $this$renderSystemStats.append("# System stats" + (this.isTimestampMode ? " (Average)" : "")).append('\n');
        $this$renderSystemStats.append('\n');
        $this$renderSystemStats.append("* JIT time: " + this.aggregatedStats.getJitTimeMillis() + " ms").append('\n');
        $this$renderSystemStats.append("* GC stats:").append('\n');
        for (GarbageCollectionStats gcStats : this.aggregatedStats.getGcStats()) {
            $this$renderSystemStats.append("  * " + gcStats.getKind() + ": " + gcStats.getMillis() + " ms (" + gcStats.getCount() + " collections)").append('\n');
        }
        $this$renderSystemStats.append('\n');
    }

    private final void renderKlibStats(StringBuilder $this$renderKlibStats) {
        block1: {
            List<KlibElementStats> list = this.totalStats.getKlibElementStats();
            if (list == null) break block1;
            List<KlibElementStats> stats = list;
            boolean bl = false;
            $this$renderKlibStats.append("# KLIB stats").append('\n');
            Iterable $this$forEach$iv = stats;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KlibElementStats klibElementStats = (KlibElementStats)element$iv;
                boolean bl2 = false;
                String path = klibElementStats.component1();
                long size = klibElementStats.component2();
                $this$renderKlibStats.append("* KLIB element '" + path + "' has size of " + size + " Bytes").append('\n');
            }
        }
    }

    private final void renderTopUnitStats(StringBuilder $this$renderTopUnitStats) {
        $this$renderTopUnitStats.append("# Slowest " + (this.isTimestampMode ? "runs" : "modules")).append('\n');
        $this$renderTopUnitStats.append('\n');
        this.renderTopModules($this$renderTopUnitStats, "total time", true, MarkdownReportRenderer::renderTopUnitStats$lambda$0, (arg_0, arg_1) -> MarkdownReportRenderer.renderTopUnitStats$lambda$1(this, arg_0, arg_1));
        this.renderTopModules($this$renderTopUnitStats, "analysis time", true, MarkdownReportRenderer::renderTopUnitStats$lambda$2, (arg_0, arg_1) -> MarkdownReportRenderer.renderTopUnitStats$lambda$3(this, arg_0, arg_1));
        this.renderTopModules($this$renderTopUnitStats, "LPS (lines per second)", false, MarkdownReportRenderer::renderTopUnitStats$lambda$4, MarkdownReportRenderer::renderTopUnitStats$lambda$5);
    }

    private final <R extends Comparable<? super R>> void renderTopModules(StringBuilder $this$renderTopModules, String name2, boolean max, Function1<? super UnitStats, ? extends R> selector, Function2<? super R, ? super R, String> printer) {
        $this$renderTopModules.append("## By " + name2).append('\n');
        $this$renderTopModules.append('\n');
        Comparable totalValue = (Comparable)selector.invoke((Object)this.totalStats);
        List<UnitStats> topAnalysisModules = this.statsCalculator.getTopModulesBy(10, max, selector);
        String firstColumnName = this.statsCalculator.getReportsData() instanceof TimestampReportsData ? "Time Stamp" : "Module";
        int n = firstColumnName.length();
        Iterator iterator2 = ((Iterable)topAnalysisModules).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        UnitStats it22 = (UnitStats)iterator2.next();
        boolean bl = false;
        int it22 = this.getTitleName(it22, false).length();
        while (iterator2.hasNext()) {
            UnitStats it = (UnitStats)iterator2.next();
            $i$a$-maxOf-MarkdownReportRenderer$renderTopModules$nameMaxColumnWidth$1 = false;
            int n2 = this.getTitleName(it, false).length();
            if (it22 >= n2) continue;
            it22 = n2;
        }
        int n3 = it22;
        int nameMaxColumnWidth = Math.max(n, n3);
        int valueMaxColumnWidth = ((String)printer.invoke(selector.invoke((Object)(max ? (UnitStats)CollectionsKt.first(topAnalysisModules) : (UnitStats)CollectionsKt.last(topAnalysisModules))), (Object)totalValue)).length();
        MarkdownTableRenderer $this$renderTopModules_u24lambda_u241 = new MarkdownTableRenderer(2, nameMaxColumnWidth, valueMaxColumnWidth);
        boolean bl2 = false;
        String[] stringArray = new String[]{firstColumnName, "Value"};
        $this$renderTopModules_u24lambda_u241.renderHeader($this$renderTopModules, stringArray);
        for (UnitStats module : topAnalysisModules) {
            String[] stringArray2 = new String[]{this.getTitleName(module, false), printer.invoke(selector.invoke((Object)module), (Object)totalValue)};
            $this$renderTopModules_u24lambda_u241.renderLine($this$renderTopModules, stringArray2);
        }
        $this$renderTopModules.append('\n');
    }

    private final String formatTime(double ratio, long nanos) {
        String string = "%.2f%% (%d ms)";
        Object[] objectArray = new Object[]{ratio * (double)100, TimeUnit.NANOSECONDS.toMillis(nanos)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final String getTitleName(UnitStats $this$getTitleName, boolean total) {
        String string;
        if (this.statsCalculator.getReportsData() instanceof TimestampReportsData && total || this.statsCalculator.getReportsData() instanceof ModulesReportsData && !total) {
            string = $this$getTitleName.getName();
            if (string == null) {
                string = "";
            }
        } else {
            String prefix = this.statsCalculator.getUnitStats().size() == 1 ? $this$getTitleName.getName() + " at " : "";
            string = prefix + this.dateTimeFormatter.format($this$getTitleName.getTimeStampMs());
        }
        return string;
    }

    private static final void renderAggregateTimeStats$lambda$2$renderTimeLine(Time aggregatedTime, MarkdownTableRenderer $this_with, StringBuilder $this_renderAggregateTimeStats, MarkdownReportRenderer this$0, String name2, Time time) {
        if (time == null || Intrinsics.areEqual((Object)time, (Object)Time.Companion.getZERO())) {
            return;
        }
        TimeRatio timeRatio = time.div(aggregatedTime);
        String[] stringArray = new String[]{name2, this$0.formatTime(timeRatio.getNanos(), time.getNanos()), this$0.formatTime(timeRatio.getUserNanos(), time.getUserNanos()), this$0.formatTime(timeRatio.getCpuNanos(), time.getCpuNanos())};
        $this_with.renderLine($this_renderAggregateTimeStats, stringArray);
    }

    private static final Unit renderAggregateTimeStats$lambda$2$0(MarkdownReportRenderer this$0, Time $aggregatedTime, MarkdownTableRenderer $this_with, StringBuilder $this_renderAggregateTimeStats, PhaseType phaseType, Time time) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
            MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$renderTimeLine($aggregatedTime, $this_with, $this_renderAggregateTimeStats, this$0, (String)MapsKt.getValue(UnitStatsKt.getPhaseTypeName(), (Object)((Object)phaseType)), time);
            List<DynamicStats> list = this$0.aggregatedStats.getDynamicStats();
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DynamicStats dynamicStats = (DynamicStats)element$iv;
                boolean bl = false;
                PhaseType parentPhaseType = dynamicStats.component1();
                String name2 = dynamicStats.component2();
                Time time2 = dynamicStats.component3();
                if (parentPhaseType != phaseType) continue;
                MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$renderTimeLine($aggregatedTime, $this_with, $this_renderAggregateTimeStats, this$0, "\u21b3 " + name2, time2);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderAggregateTimeStats$lambda$2$1(Time $aggregatedTime, MarkdownTableRenderer $this_with, StringBuilder $this_renderAggregateTimeStats, MarkdownReportRenderer this$0, PhaseSideType phaseSideType, SideStats time) {
        Intrinsics.checkNotNullParameter((Object)((Object)phaseSideType), (String)"phaseSideType");
        SideStats sideStats = time;
        MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$renderTimeLine($aggregatedTime, $this_with, $this_renderAggregateTimeStats, this$0, (String)MapsKt.getValue(UnitStatsKt.getPhaseSideTypeName(), (Object)((Object)phaseSideType)), sideStats != null ? sideStats.getTime() : null);
        return Unit.INSTANCE;
    }

    private static final long renderTopUnitStats$lambda$0(UnitStats it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTotalTime().getNanos();
    }

    private static final String renderTopUnitStats$lambda$1(MarkdownReportRenderer this$0, long moduleResult, long totalResult) {
        return this$0.formatTime((double)moduleResult / (double)totalResult, moduleResult);
    }

    private static final long renderTopUnitStats$lambda$2(UnitStats it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Time time = it.getAnalysisStats();
        return time != null ? time.getNanos() : 0L;
    }

    private static final String renderTopUnitStats$lambda$3(MarkdownReportRenderer this$0, long moduleResult, long totalResult) {
        return this$0.formatTime((double)moduleResult / (double)totalResult, moduleResult);
    }

    private static final double renderTopUnitStats$lambda$4(UnitStats it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (double)it.getLinesCount() / (double)it.getTotalTime().getNanos() * (double)UnitStatsKt.getNanosInSecond();
    }

    private static final String renderTopUnitStats$lambda$5(double moduleResult, double d) {
        String string = "%.2f LPS";
        Object[] objectArray = new Object[]{moduleResult};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/stats/MarkdownReportRenderer$Companion;", "", "<init>", "()V", "TOP_MODULE_COUNT", "", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

