/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryProtocolDataListener;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SingleTrFileDiscoveryProtocolDataListener
extends TestDiscoveryProtocolDataListener {
    public static final String TRACE_FILE = "org.jetbrains.instrumentation.trace.file";
    public static final String BUFFER_SIZE = "org.jetbrains.instrumentation.trace.file.buffer.size";
    public static final String FILE_VERSION = "org.jetbrains.instrumentation.trace.file.version";
    public static final byte HEADER_START = 73;
    public static final byte[] HEADER_TAIL = new byte[]{74, 84, 67};
    private static final int DEFAULT_VERSION = 3;
    private final DataOutputStream myStream;
    private final NameEnumerator.Incremental myNameEnumerator;
    private static Long ourSendTime = 0L;

    /*
     * WARNING - void declaration
     */
    public SingleTrFileDiscoveryProtocolDataListener() throws Exception {
        super(Byte.parseByte(System.getProperty(FILE_VERSION, "3")));
        void var2_2;
        void var1_1;
        File myTraceFile = SingleTrFileDiscoveryProtocolDataListener.getCanonicalFile(new File(System.getProperty(TRACE_FILE, "td.ijtc")));
        int bufferSize = Integer.parseInt(System.getProperty(BUFFER_SIZE, "32768"));
        myTraceFile.getParentFile().mkdirs();
        this.myStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)var1_1), (int)var2_2));
        this.myNameEnumerator = new NameEnumerator.Incremental();
        SingleTrFileDiscoveryProtocolDataListener singleTrFileDiscoveryProtocolDataListener = this;
        singleTrFileDiscoveryProtocolDataListener.start(singleTrFileDiscoveryProtocolDataListener.myStream);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
            final /* synthetic */ SingleTrFileDiscoveryProtocolDataListener this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                System.out.println("Send time: " + 1.0 * (double)ourSendTime.longValue() / 1.0E9);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    SingleTrFileDiscoveryProtocolDataListener(DataOutputStream stream, int version) throws Exception {
        super((byte)var2_2);
        void var1_1;
        void var2_2;
        this.myStream = var1_1;
        this.myNameEnumerator = new NameEnumerator.Incremental();
        SingleTrFileDiscoveryProtocolDataListener singleTrFileDiscoveryProtocolDataListener = this;
        singleTrFileDiscoveryProtocolDataListener.start(singleTrFileDiscoveryProtocolDataListener.myStream);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void testFinished(String className, String methodName, Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames, List<int[]> openedFiles) throws IOException {
        long s = System.nanoTime();
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            SingleTrFileDiscoveryProtocolDataListener singleTrFileDiscoveryProtocolDataListener = this;
            singleTrFileDiscoveryProtocolDataListener.writeTestFinished(singleTrFileDiscoveryProtocolDataListener.myStream, (String)var1_1, (String)var2_3, (Map<Integer, boolean[]>)var3_4, classToMethodNames, openedFiles);
            return;
        }
        finally {
            ourSendTime = ourSendTime + (System.nanoTime() - s);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void testsFinished() throws IOException {
        long s = System.nanoTime();
        try {
            SingleTrFileDiscoveryProtocolDataListener singleTrFileDiscoveryProtocolDataListener = this;
            singleTrFileDiscoveryProtocolDataListener.writeDictionaryIncrementIfNeeded(singleTrFileDiscoveryProtocolDataListener.myStream);
            SingleTrFileDiscoveryProtocolDataListener singleTrFileDiscoveryProtocolDataListener2 = this;
            singleTrFileDiscoveryProtocolDataListener2.finish(singleTrFileDiscoveryProtocolDataListener2.myStream);
        }
        catch (Throwable throwable) {
            void var1_1;
            ourSendTime = ourSendTime + (System.nanoTime() - var1_1);
            this.myStream.close();
            throw throwable;
        }
        ourSendTime = ourSendTime + (System.nanoTime() - s);
        this.myStream.close();
    }

    @Override
    public NameEnumerator.Incremental getNameEnumerator() {
        return this.myNameEnumerator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addMetadata(Map<String, String> metadata) throws IOException {
        void var1_1;
        SingleTrFileDiscoveryProtocolDataListener singleTrFileDiscoveryProtocolDataListener = this;
        singleTrFileDiscoveryProtocolDataListener.writeMetadata(singleTrFileDiscoveryProtocolDataListener.myStream, (Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addClassMetadata(List<ClassMetadata> metadata) throws IOException {
        void var1_1;
        SingleTrFileDiscoveryProtocolDataListener singleTrFileDiscoveryProtocolDataListener = this;
        singleTrFileDiscoveryProtocolDataListener.writeClassMetadata(singleTrFileDiscoveryProtocolDataListener.myStream, (List<ClassMetadata>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void start(DataOutput output) throws IOException {
        void var1_1;
        output.writeByte(73);
        output.write(HEADER_TAIL);
        super.start((DataOutput)var1_1);
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            File file2;
            return file2.getAbsoluteFile();
        }
    }
}

