/*
 * Decompiled with CFR 0.152.
 */
package liquibase.das;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.util.DasUtil;
import com.intellij.liquibase.orm.db.DasDatabase;
import com.intellij.util.containers.JBIterable;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import liquibase.das.DasSnapshotGenerator;
import liquibase.das.DasToDbObjectsConverter;
import liquibase.database.Database;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.Table;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\f"}, d2={"Lliquibase/das/DasSequenceSnapshotGenerator;", "Lliquibase/das/DasSnapshotGenerator;", "<init>", "()V", "snapshotObject", "Lliquibase/structure/DatabaseObject;", "example", "snapshot", "Lliquibase/snapshot/DatabaseSnapshot;", "addTo", "", "foundObject", "intellij.liquibase.orm"})
public final class DasSequenceSnapshotGenerator
extends DasSnapshotGenerator {
    public DasSequenceSnapshotGenerator() {
        Class[] classArray = new Class[]{Schema.class};
        super(Sequence.class, classArray);
    }

    @Override
    @NotNull
    protected DatabaseObject snapshotObject(@NotNull DatabaseObject example, @NotNull DatabaseSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        return example;
    }

    @Override
    protected void addTo(@NotNull DatabaseObject foundObject, @NotNull DatabaseSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)foundObject, (String)"foundObject");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (!snapshot.getSnapshotControl().shouldInclude(Sequence.class) || !(foundObject instanceof Schema)) {
            return;
        }
        Database database = snapshot.getDatabase();
        Intrinsics.checkNotNull((Object)database, (String)"null cannot be cast to non-null type com.intellij.liquibase.orm.db.DasDatabase");
        DasDatabase dasDatabase = (DasDatabase)database;
        JBIterable jBIterable = DasUtil.getSchemaElements((DasDataSource)((DasDataSource)dasDatabase.getDbDataSource()), BasicSequence.class).filter(arg_0 -> DasSequenceSnapshotGenerator.addTo$lambda$1(arg_0 -> DasSequenceSnapshotGenerator.addTo$lambda$0(this, foundObject, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable dasSequences = jBIterable;
        Set<Sequence> sequences = DasToDbObjectsConverter.INSTANCE.createSequences((JBIterable<? extends BasicSequence>)dasSequences);
        for (Sequence sequence : sequences) {
            if (dasDatabase.isSystemObject((DatabaseObject)sequence)) continue;
            sequence.setSchema((Schema)foundObject);
            for (Table table : ((Schema)foundObject).getDatabaseObjects(Table.class)) {
                for (Column column : table.getColumns()) {
                    String columnSequence = (String)column.getAttribute("sequence", String.class);
                    if (!Intrinsics.areEqual((Object)columnSequence, (Object)sequence.getName())) continue;
                    sequence.setAttribute("owned", (Object)table.getName());
                }
            }
            ((Schema)foundObject).addDatabaseObject((DatabaseObject)sequence);
        }
    }

    private static final boolean addTo$lambda$0(DasSequenceSnapshotGenerator this$0, DatabaseObject $foundObject, BasicSequence it) {
        Intrinsics.checkNotNull((Object)it);
        Catalog catalog = ((Schema)$foundObject).getCatalog();
        return this$0.filterDasObjectByDataStore((DasObject)it, catalog != null ? catalog.getName() : null, ((Schema)$foundObject).getName());
    }

    private static final boolean addTo$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

