/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractDynamicAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/SequenceGeneratorAnnotation;", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/AbstractDynamicAttributeAnnotation;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isInsert", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "getParams", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "module", "Lcom/intellij/openapi/module/Module;", "knownAttributes", "", "intellij.javaee.jpa.jpb.model"})
public final class SequenceGeneratorAnnotation
extends AbstractDynamicAttributeAnnotation {
    @NotNull
    private final Project project;

    public SequenceGeneratorAnnotation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(JpaAttributeAnnotation.SequenceGenerator);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!attribute.isId() || attribute.getGeneratedStrategy() != EntityAttribute.GeneratedStrategy.SEQUENCE || (objectArray = (Object[])attribute.getGeneratorName()) == null || objectArray.length() == 0 || CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])(objectArray = new String[]{"hibernate_sequence", "seq_gen"})), (Object)attribute.getGeneratorName()) || entity.getSequenceGenerator() != null) {
            return false;
        }
        EntityPsi generatorEntity = EntityUtil.getEntityWithGenerator(this.project, attribute.getGeneratorName());
        return generatorEntity == null || Intrinsics.areEqual((Object)generatorEntity, (Object)entity);
    }

    @Override
    @NotNull
    public LinkedHashMap<String, String> getParams(@NotNull EntityAttribute attribute, @Nullable Module module) {
        int allocationSize;
        int initialValue;
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Pair[] pairArray = new Pair[]{new Pair((Object)"name", (Object)("\"" + attribute.getGeneratorName() + "\""))};
        LinkedHashMap params = MapsKt.linkedMapOf((Pair[])pairArray);
        String sequenceOrTableGeneratorName = attribute.getSequenceOrTableGeneratorName();
        CharSequence charSequence = sequenceOrTableGeneratorName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            ((Map)params).put("sequenceName", "\"" + sequenceOrTableGeneratorName + "\"");
        }
        if ((initialValue = attribute.getInitialValue()) != 1) {
            ((Map)params).put("initialValue", String.valueOf(initialValue));
        }
        if ((allocationSize = attribute.getAllocationSize()) != 50) {
            ((Map)params).put("allocationSize", String.valueOf(allocationSize));
        }
        return params;
    }

    @Override
    @NotNull
    public List<String> knownAttributes(@Nullable EntityAttribute attribute) {
        Object[] objectArray = new String[]{"name", "sequenceName", "initialValue", "allocationSize"};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

