/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.util;

import com.intellij.jpa.jpb.model.core.util.CanceledProgressAction;
import com.intellij.jpa.jpb.model.core.util.HProgressManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ConcurrencyUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jpa/jpb/model/core/util/HProgressManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "executor", "Ljava/util/concurrent/ExecutorService;", "runProcessWithCanceledProgressSynchronously", "T", "progressAction", "Lcom/intellij/jpa/jpb/model/core/util/CanceledProgressAction;", "(Lcom/intellij/jpa/jpb/model/core/util/CanceledProgressAction;)Ljava/lang/Object;", "dispose", "", "Companion", "intellij.javaee.jpa.jpb.model.core"})
public final class HProgressManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService executor;

    public HProgressManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"HProgressManager");
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        this.executor = threadPoolExecutor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final <T> T runProcessWithCanceledProgressSynchronously(@NotNull CanceledProgressAction<T> progressAction) throws CancellationException {
        Intrinsics.checkNotNullParameter(progressAction, (String)"progressAction");
        Project project = this.project;
        String string = progressAction.getProgressTitle();
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, Exception>(this, progressAction, project, string){
            final /* synthetic */ HProgressManager this$0;
            final /* synthetic */ CanceledProgressAction<T> $progressAction;
            {
                this.this$0 = $receiver;
                this.$progressAction = $progressAction;
                super($super_call_param$1, $super_call_param$2, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected T compute(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Future<Object> futureTask = HProgressManager.access$getExecutor$p(this.this$0).submit(() -> runProcessWithCanceledProgressSynchronously.1.compute$lambda$0(this.$progressAction));
                Timer timer = new Timer(this.$progressAction.getProgressTitle() + " Timer");
                Ref.IntRef timerIdx = new Ref.IntRef();
                try {
                    timer.scheduleAtFixedRate(new TimerTask(indicator, futureTask, this.$progressAction, timerIdx){
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ Future<T> $futureTask;
                        final /* synthetic */ CanceledProgressAction<T> $progressAction;
                        final /* synthetic */ Ref.IntRef $timerIdx;
                        {
                            this.$indicator = $indicator;
                            this.$futureTask = $futureTask;
                            this.$progressAction = $progressAction;
                            this.$timerIdx = $timerIdx;
                        }

                        public void run() {
                            block1: {
                                if (this.$indicator.isCanceled()) {
                                    this.$futureTask.cancel(true);
                                    return;
                                }
                                int n = this.$timerIdx.element;
                                this.$timerIdx.element = n + 1;
                                String string = this.$progressAction.completeIndicatorText(n);
                                if (string == null) break block1;
                                String string2 = string;
                                ProgressIndicator progressIndicator = this.$indicator;
                                String it = string2;
                                boolean bl = false;
                                progressIndicator.setText(it);
                            }
                        }
                    }, 0L, 1000L);
                    Object object = futureTask.get();
                    return (T)object;
                }
                finally {
                    timer.cancel();
                }
            }

            private static final Object compute$lambda$0(CanceledProgressAction $progressAction) {
                return $progressAction.compute();
            }
        });
    }

    public void dispose() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(HProgressManager $this) {
        return $this.executor;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/core/util/HProgressManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/core/util/HProgressManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model.core"})
    @SourceDebugExtension(value={"SMAP\nHProgressManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HProgressManager.kt\ncom/intellij/jpa/jpb/model/core/util/HProgressManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n30#2,2:74\n*S KotlinDebug\n*F\n+ 1 HProgressManager.kt\ncom/intellij/jpa/jpb/model/core/util/HProgressManager$Companion\n*L\n20#1:74,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HProgressManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HProgressManager> serviceClass$iv = HProgressManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (HProgressManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

