/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.repository;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.model.PartTree;
import com.intellij.jpa.jpb.model.repository.BasicRepositoryAttribute;
import com.intellij.jpa.jpb.model.repository.RepositoryMethod;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodCacheProvider;
import com.intellij.jpa.jpb.model.repository.RepositoryMethodModel;
import com.intellij.jpa.jpb.model.repository.RepositoryModelParser;
import com.intellij.jpa.jpb.model.repository.RepositorySearch;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastSmartPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002<=B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001fJ\b\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010$\u001a\u0004\u0018\u00010\u0011J\u0006\u0010%\u001a\u00020\u001fJ\b\u0010&\u001a\u0004\u0018\u00010\u0011J\u0006\u0010'\u001a\u00020\u001fJ\b\u0010(\u001a\u00020\u001fH\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020,H\u0016J\u0006\u0010/\u001a\u00020\u001fJ\u0006\u00100\u001a\u00020\u001fJ\u0006\u00101\u001a\u00020\u001fJ\u0006\u00102\u001a\u00020\u001fJ\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u0011H\u0002J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020\u001fJ\b\u0010:\u001a\u0004\u0018\u00010;R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi;", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethod;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "<init>", "(Lorg/jetbrains/uast/UMethod;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "methodCacheProvider", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodCacheProvider;", "psiMethodPointer", "Lcom/intellij/uast/UastSmartPointer;", "getPsiMethod", "Lcom/intellij/psi/PsiMethod;", "getName", "", "getFullReturnType", "Lcom/intellij/psi/PsiType;", "getReturnTypeFqn", "getReturnType", "getAsyncType", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$AsyncType;", "getWrapType", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$WrapType;", "getFullReturnTypeInfo", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi$FullReturnTypeInfo;", "getParameterTypes", "", "isCollectionWrapType", "", "isInstanceWrapType", "getType", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethod$MethodType;", "getLimitPrefix", "getLimitSize", "isFindPrefix", "getMethodPrefix", "isAllIgnoreCase", "isQueryDistinct", "getPartTree", "Lcom/intellij/jpa/jpb/model/model/PartTree;", "getParametersCount", "", "getParameterName", "parameterIdx", "isPageable", "isSortable", "isModifying", "isDynamicProjection", "hasParameterType", "typeFqn", "getReturnNullability", "Lcom/intellij/jpa/jpb/model/repository/BasicRepositoryAttribute$Nullability;", "getRepositoryDomainType", "Lcom/intellij/psi/PsiClassType;", "isExpired", "getPsiElement", "Lcom/intellij/psi/PsiElement;", "Companion", "FullReturnTypeInfo", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nRepositoryMethodPsi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryMethodPsi.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi\n+ 2 UastSmartPointer.kt\ncom/intellij/uast/UastSmartPointerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,262:1\n20#2:263\n11705#3:264\n12052#3,3:265\n13225#3:268\n13225#3,2:269\n13226#3:271\n13225#3,2:272\n37#4,2:274\n*S KotlinDebug\n*F\n+ 1 RepositoryMethodPsi.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi\n*L\n35#1:263\n101#1:264\n101#1:265,3\n205#1:268\n215#1:269,2\n205#1:271\n223#1:272,2\n247#1:274,2\n*E\n"})
public final class RepositoryMethodPsi
extends RepositoryMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RepositoryMethodCacheProvider methodCacheProvider;
    @NotNull
    private final UastSmartPointer<UMethod> psiMethodPointer;

    private RepositoryMethodPsi(UMethod uMethod) {
        Project project = uMethod.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.methodCacheProvider = RepositoryMethodCacheProvider.Companion.getInstance(this.project);
        UElement $this$createUastSmartPointer$iv = (UElement)uMethod;
        boolean $i$f$createUastSmartPointer = false;
        this.psiMethodPointer = new UastSmartPointer($this$createUastSmartPointer$iv, UMethod.class);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiMethod getPsiMethod() {
        PsiMethod psiMethod = (PsiMethod)EntityUtil.ra(() -> RepositoryMethodPsi.getPsiMethod$lambda$0(this));
        if (psiMethod == null) {
            throw new IllegalStateException("Repository method from SmartPsiElementPointer is null. The PsiMethod reparse has completely invalidated the pointer (for example, the element referenced by the pointer has been deleted). This may be due to misuse of the cache.");
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getPsiMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Nullable
    public final PsiType getFullReturnType() {
        PsiMethod psiMethod = this.getPsiMethod();
        return (PsiType)EntityUtil.ra(() -> RepositoryMethodPsi.getFullReturnType$lambda$0(psiMethod));
    }

    @Nullable
    public final String getReturnTypeFqn() {
        PsiType type = this.getReturnType();
        return type == null ? null : (String)EntityUtil.ra(() -> RepositoryMethodPsi.getReturnTypeFqn$lambda$0(type));
    }

    @Nullable
    public final PsiType getReturnType() {
        FullReturnTypeInfo fullReturnTypeInfo = this.getFullReturnTypeInfo();
        return fullReturnTypeInfo != null ? fullReturnTypeInfo.getReturnType() : null;
    }

    @Nullable
    public final RepositoryMethodModel.AsyncType getAsyncType() {
        FullReturnTypeInfo fullReturnTypeInfo = this.getFullReturnTypeInfo();
        return fullReturnTypeInfo != null ? fullReturnTypeInfo.getAsyncType() : null;
    }

    @Nullable
    public final RepositoryMethodModel.WrapType getWrapType() {
        FullReturnTypeInfo fullReturnTypeInfo = this.getFullReturnTypeInfo();
        return fullReturnTypeInfo != null ? fullReturnTypeInfo.getWrapType() : null;
    }

    private final FullReturnTypeInfo getFullReturnTypeInfo() {
        PsiMethod psiMethod = this.getPsiMethod();
        return (FullReturnTypeInfo)EntityUtil.ra(() -> RepositoryMethodPsi.getFullReturnTypeInfo$lambda$0(psiMethod));
    }

    @NotNull
    public final List<PsiType> getParameterTypes() {
        PsiMethod psiMethod = this.getPsiMethod();
        Object t = EntityUtil.ra(() -> RepositoryMethodPsi.getParameterTypes$lambda$0(psiMethod));
        Intrinsics.checkNotNullExpressionValue(t, (String)"ra(...)");
        return (List)t;
    }

    @Override
    public boolean isCollectionWrapType() {
        return ArraysKt.contains((Object[])RepositoryMethodModel.WrapType.Companion.collectionValues(), (Object)((Object)this.getWrapType()));
    }

    public final boolean isInstanceWrapType() {
        RepositoryMethodModel.WrapType wrapType = this.getWrapType();
        if (wrapType == null) {
            PsiType returnType = this.getReturnType();
            return returnType != null && !(returnType instanceof PsiPrimitiveType) && !returnType.equalsToText("java.lang.Long") && !returnType.equalsToText("java.lang.Boolean");
        }
        return ArraysKt.contains((Object[])RepositoryMethodModel.WrapType.Companion.instanceValues(), (Object)((Object)wrapType));
    }

    @Override
    @NotNull
    public RepositoryMethod.MethodType getType() {
        String[] stringArray = new String[]{"org.springframework.data.jpa.repository.Query"};
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)this.getPsiMethod()), (String[])stringArray) != null) {
            return RepositoryMethod.MethodType.Query;
        }
        stringArray = new String[]{"org.springframework.data.jpa.repository.query.Procedure"};
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)this.getPsiMethod()), (String[])stringArray) != null) {
            return RepositoryMethod.MethodType.Procedure;
        }
        PartTree partTree = this.getPartTree();
        return partTree.isDelete() ? RepositoryMethod.MethodType.Delete : (partTree.isUpdate() ? RepositoryMethod.MethodType.Update : (partTree.isCountProjection() ? RepositoryMethod.MethodType.Count : (partTree.isExistsProjection() ? RepositoryMethod.MethodType.Exists : RepositoryMethod.MethodType.Find)));
    }

    @Override
    @Nullable
    public String getLimitPrefix() {
        return this.getPartTree().getLimitPrefix();
    }

    @Nullable
    public final String getLimitSize() {
        Integer n = this.getPartTree().getMaxResults();
        return n != null ? String.valueOf(n) : null;
    }

    public final boolean isFindPrefix() {
        Object[] objectArray = new String[]{RepositoryMethodModel.MethodPrefix.Find.getCaption(), RepositoryMethodModel.MethodPrefix.Read.getCaption(), RepositoryMethodModel.MethodPrefix.Get.getCaption(), RepositoryMethodModel.MethodPrefix.Query.getCaption(), RepositoryMethodModel.MethodPrefix.Stream.getCaption()};
        return ArraysKt.contains((Object[])objectArray, (Object)this.getMethodPrefix());
    }

    @Nullable
    public final String getMethodPrefix() {
        return this.getPartTree().getMethodPrefix();
    }

    public final boolean isAllIgnoreCase() {
        return this.getPartTree().isAllIgnoreCase();
    }

    @Override
    public boolean isQueryDistinct() {
        return this.getPartTree().isDistinct();
    }

    @Override
    @NotNull
    public PartTree getPartTree() {
        return this.methodCacheProvider.getPartTree(this.getPsiMethod());
    }

    @Override
    public int getParametersCount() {
        return this.getPsiMethod().getParameterList().getParameters().length;
    }

    @Override
    @NotNull
    public String getParameterName(int parameterIdx) {
        PsiParameter[] psiParameterArray = this.getPsiMethod().getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] methodParameters = psiParameterArray;
        PsiParameter psiParameter = methodParameters[parameterIdx];
        String paramValue = StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)psiParameter, "org.springframework.data.repository.query.Param", "value");
        CharSequence charSequence = paramValue;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return paramValue;
        }
        String string = psiParameter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public final boolean isPageable() {
        return this.hasParameterType("org.springframework.data.domain.Pageable");
    }

    public final boolean isSortable() {
        return this.hasParameterType("org.springframework.data.domain.Sort");
    }

    public final boolean isModifying() {
        return this.getPsiMethod().hasAnnotation("org.springframework.data.jpa.repository.Modifying");
    }

    public final boolean isDynamicProjection() {
        PsiMethod psiMethod = this.getPsiMethod();
        Object t = EntityUtil.ra(() -> RepositoryMethodPsi.isDynamicProjection$lambda$0(this, psiMethod));
        Intrinsics.checkNotNullExpressionValue(t, (String)"ra(...)");
        return (Boolean)t;
    }

    private final boolean hasParameterType(String typeFqn) {
        PsiMethod psiMethod = this.getPsiMethod();
        Object t = EntityUtil.ra(() -> RepositoryMethodPsi.hasParameterType$lambda$0(psiMethod, typeFqn));
        Intrinsics.checkNotNullExpressionValue(t, (String)"ra(...)");
        return (Boolean)t;
    }

    @NotNull
    public final BasicRepositoryAttribute.Nullability getReturnNullability() {
        PsiMethod member = this.getPsiMethod();
        Object object = (RepositoryModelParser)RepositoryModelParser.Companion.getInstance((PsiElement)member);
        if (object == null || (object = object.getReturnValueNullability(member)) == null) {
            object = BasicRepositoryAttribute.Nullability.NotSet;
        }
        return object;
    }

    @NotNull
    public final PsiClassType getRepositoryDomainType() {
        PsiClass repositoryClass = this.getPsiMethod().getContainingClass();
        PsiClassType psiClassType = RepositorySearch.Companion.getInstance(this.project).getDomainType((Function0<? extends PsiType[]>)((Function0)() -> RepositoryMethodPsi.getRepositoryDomainType$lambda$0(repositoryClass)));
        if (psiClassType == null) {
            PsiClass psiClass = repositoryClass;
            throw new IllegalStateException("Domain type not found for '" + (psiClass != null ? psiClass.getQualifiedName() : null) + "' repository");
        }
        return psiClassType;
    }

    public final boolean isExpired() {
        return EntityUtil.ra(() -> RepositoryMethodPsi.isExpired$lambda$0(this)) == null;
    }

    @Nullable
    public final PsiElement getPsiElement() {
        return this.isExpired() ? null : (PsiElement)this.getPsiMethod();
    }

    private static final PsiMethod getPsiMethod$lambda$0(RepositoryMethodPsi this$0) {
        UMethod uMethod = (UMethod)this$0.psiMethodPointer.getElement();
        return uMethod != null ? uMethod.getJavaPsi() : null;
    }

    private static final PsiType getFullReturnType$lambda$0(PsiMethod $psiMethod) {
        return $psiMethod.getReturnType();
    }

    private static final String getReturnTypeFqn$lambda$0(PsiType $type) {
        return $type.getCanonicalText();
    }

    private static final FullReturnTypeInfo getFullReturnTypeInfo$lambda$0(PsiMethod $psiMethod) {
        PsiType psiType = $psiMethod.getReturnType();
        if (psiType == null) {
            return null;
        }
        PsiType returnType = psiType;
        if (!(returnType instanceof PsiClassType)) {
            return new FullReturnTypeInfo(null, null, returnType);
        }
        if (((PsiClassType)returnType).getParameterCount() <= 0) {
            return new FullReturnTypeInfo(null, null, (PsiType)((PsiClassType)returnType).rawType());
        }
        PsiType genericType = ((PsiClassType)returnType).getParameters()[0];
        String string = ((PsiClassType)returnType).rawType().getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        String returnRawTypeFqn = string;
        if (genericType instanceof PsiClassType && ((PsiClassType)genericType).getParameterCount() > 0) {
            String string2 = ((PsiClassType)genericType).rawType().getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
            RepositoryMethodModel.WrapType wrapType = RepositoryMethodModel.WrapType.Companion.findByFqn(string2);
            RepositoryMethodModel.AsyncType asyncType = RepositoryMethodModel.AsyncType.Companion.findByFqn(returnRawTypeFqn);
            return new FullReturnTypeInfo(asyncType, wrapType, ((PsiClassType)genericType).getParameters()[0]);
        }
        RepositoryMethodModel.WrapType wrapType = RepositoryMethodModel.WrapType.Companion.findByFqn(returnRawTypeFqn);
        RepositoryMethodModel.AsyncType asyncType = RepositoryMethodModel.AsyncType.Companion.findByFqn(returnRawTypeFqn);
        return new FullReturnTypeInfo(asyncType, wrapType, genericType);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getParameterTypes$lambda$0(PsiMethod $psiMethod) {
        void $this$mapTo$iv$iv;
        PsiParameter[] psiParameterArray = $psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object[] $this$map$iv = psiParameterArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    private static final Boolean isDynamicProjection$lambda$0(RepositoryMethodPsi this$0, PsiMethod $psiMethod) {
        boolean bl;
        block8: {
            PsiType psiType = this$0.getReturnType();
            if (psiType == null) {
                return false;
            }
            PsiType returnType = psiType;
            PsiParameter[] psiParameterArray = $psiMethod.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            Object[] $this$any$iv = psiParameterArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                boolean bl2;
                block7: {
                    PsiType paramType;
                    PsiParameter psiParam = (PsiParameter)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)psiParam.getType(), (String)"getType(...)");
                    if (!(paramType instanceof PsiClassType)) {
                        bl2 = false;
                    } else {
                        PsiClass typeClass = ((PsiClassType)paramType).resolve();
                        if (typeClass == null || !InheritanceUtil.isInheritor((PsiClass)typeClass, (String)"java.lang.Class")) {
                            bl2 = false;
                        } else {
                            PsiType[] psiTypeArray = ((PsiClassType)paramType).getParameters();
                            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
                            Object[] $this$any$iv2 = psiTypeArray;
                            boolean $i$f$any2 = false;
                            for (Object element$iv2 : $this$any$iv2) {
                                PsiType paramGenericType = (PsiType)element$iv2;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)paramGenericType, (Object)returnType)) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                }
                if (!bl2) continue;
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    private static final Boolean hasParameterType$lambda$0(PsiMethod $psiMethod, String $typeFqn) {
        boolean bl;
        block1: {
            PsiParameter[] psiParameterArray = $psiMethod.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            Object[] $this$any$iv = psiParameterArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiClass typeClass;
                PsiType paramType;
                PsiParameter psiParam = (PsiParameter)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)psiParam.getType(), (String)"getType(...)");
                boolean bl3 = paramType instanceof PsiClassType ? (typeClass = ((PsiClassType)paramType).resolve()) != null && InheritanceUtil.isInheritor((PsiClass)typeClass, (String)$typeFqn) : false;
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final PsiType[] getRepositoryDomainType$lambda$0(PsiClass $repositoryClass) {
        List repoClasses = new ArrayList();
        PsiClass psiClass = $repositoryClass;
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)$repositoryClass);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getClassType(...)");
            repoClasses.add(psiClassType);
            Collection collection = repoClasses;
            PsiClassType[] psiClassTypeArray = $repositoryClass.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getSuperTypes(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])psiClassTypeArray);
        }
        Collection $this$toTypedArray$iv = repoClasses;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (PsiType[])thisCollection$iv.toArray(new PsiClassType[0]);
    }

    private static final PsiMethod isExpired$lambda$0(RepositoryMethodPsi this$0) {
        UMethod uMethod = (UMethod)this$0.psiMethodPointer.getElement();
        return uMethod != null ? uMethod.getJavaPsi() : null;
    }

    public /* synthetic */ RepositoryMethodPsi(UMethod uMethod, DefaultConstructorMarker $constructor_marker) {
        this(uMethod);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nRepositoryMethodPsi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryMethodPsi.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi$Companion\n+ 2 SUastUtils.kt\ncom/intellij/jpa/jpb/model/util/SUastUtils\n*L\n1#1,262:1\n108#2:263\n*S KotlinDebug\n*F\n+ 1 RepositoryMethodPsi.kt\ncom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi$Companion\n*L\n30#1:263\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RepositoryMethodPsi getInstance(@NotNull PsiMethod psiMethod) {
            Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
            Object t = EntityUtil.raPsiCached((PsiElement)psiMethod, () -> Companion.getInstance$lambda$0(psiMethod));
            Intrinsics.checkNotNullExpressionValue(t, (String)"raPsiCached(...)");
            return (RepositoryMethodPsi)t;
        }

        private static final RepositoryMethodPsi getInstance$lambda$0(PsiMethod $psiMethod) {
            PsiElement $this$toUElementWithType$iv = (PsiElement)$psiMethod;
            boolean $i$f$toUElementWithType = false;
            UElement uElement = UastContextKt.toUElement((PsiElement)$this$toUElementWithType$iv, UMethod.class);
            Intrinsics.checkNotNull((Object)uElement);
            return new RepositoryMethodPsi((UMethod)uElement, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodPsi$FullReturnTypeInfo;", "", "asyncType", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$AsyncType;", "wrapType", "Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$WrapType;", "returnType", "Lcom/intellij/psi/PsiType;", "<init>", "(Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$AsyncType;Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$WrapType;Lcom/intellij/psi/PsiType;)V", "getAsyncType", "()Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$AsyncType;", "getWrapType", "()Lcom/intellij/jpa/jpb/model/repository/RepositoryMethodModel$WrapType;", "getReturnType", "()Lcom/intellij/psi/PsiType;", "intellij.javaee.jpa.jpb.model"})
    private static final class FullReturnTypeInfo {
        @Nullable
        private final RepositoryMethodModel.AsyncType asyncType;
        @Nullable
        private final RepositoryMethodModel.WrapType wrapType;
        @Nullable
        private final PsiType returnType;

        public FullReturnTypeInfo(@Nullable RepositoryMethodModel.AsyncType asyncType, @Nullable RepositoryMethodModel.WrapType wrapType, @Nullable PsiType returnType) {
            this.asyncType = asyncType;
            this.wrapType = wrapType;
            this.returnType = returnType;
        }

        @Nullable
        public final RepositoryMethodModel.AsyncType getAsyncType() {
            return this.asyncType;
        }

        @Nullable
        public final RepositoryMethodModel.WrapType getWrapType() {
            return this.wrapType;
        }

        @Nullable
        public final PsiType getReturnType() {
            return this.returnType;
        }
    }
}

