/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.service;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.JoinTableAttribute;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.orm.jpa.model.CustomJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.service.JpabGeneratorManager;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 72\u00020\u0001:\u000278B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000fJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u000fJ\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJK\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001d\"\b\b\u0001\u0010\u001c*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u001d0\u001e2 \u0010\u001f\u001a\u001c\u0012\u0004\u0012\u0002H\u001d\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u0001H\u001c0!0 H\u0002\u00a2\u0006\u0002\u0010#J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J \u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0014H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0015H\u0002J\u0010\u0010+\u001a\u0004\u0018\u00010\u00192\u0006\u0010,\u001a\u00020\u0015J\u0010\u0010-\u001a\u0004\u0018\u00010\u00102\u0006\u0010.\u001a\u00020\u000fJ\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014J\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0014J\f\u00102\u001a\b\u0012\u0004\u0012\u0002010\u0014J\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0014J\u000e\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "entitySearch", "Lcom/intellij/jpa/jpb/model/backend/ed/indexing/EntitySearch;", "kotlin.jvm.PlatformType", "ddlGeneratorManager", "Lcom/intellij/jpa/jpb/model/service/JpabGeneratorManager;", "getAllTables", "", "", "Lcom/intellij/psi/PsiElement;", "findTableOwnerElementByTableName", "tableName", "getTableAttributes", "", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "findEntityClassByTableName", "Lcom/intellij/psi/PsiClass;", "findAttributeMember", "Lcom/intellij/psi/PsiMember;", "columnName", "findWithTransform", "R", "T", "", "mappingPredicate", "Lkotlin/Function1;", "Lkotlin/Pair;", "", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getEntityTables", "findJoinOrCollectionTableElement", "entities", "Lcom/intellij/jpa/jpb/model/model/Entity;", "getReferenceToAnnotationOrAttr", "annotationFqn", "attribute", "getAttributeMember", "attr", "findSequenceBySequenceName", "sequenceName", "getSequenceNames", "getSequenceNamesWithEntities", "Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager$SequenceInfo;", "getSequenceGeneratorsWithEntities", "getSequenceGenerators", "Lcom/intellij/jpa/jpb/model/model/SequenceGenerator;", "isSuitableGenerator", "entity", "Companion", "SequenceInfo", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nJpabReferenceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpabReferenceManager.kt\ncom/intellij/jpa/jpb/model/service/JpabReferenceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,297:1\n1586#2:298\n1661#2,3:299\n1586#2:302\n1661#2,3:303\n1915#2,2:308\n1586#2:310\n1661#2,3:311\n1586#2:314\n1661#2,3:315\n1586#2:318\n1661#2,3:319\n221#3,2:306\n*S KotlinDebug\n*F\n+ 1 JpabReferenceManager.kt\ncom/intellij/jpa/jpb/model/service/JpabReferenceManager\n*L\n43#1:298\n43#1:299,3\n47#1:302\n47#1:303,3\n53#1:308,2\n69#1:310\n69#1:311,3\n121#1:314\n121#1:315,3\n172#1:318\n172#1:319,3\n47#1:306,2\n*E\n"})
public final class JpabReferenceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final EntitySearch entitySearch;
    private final JpabGeneratorManager ddlGeneratorManager;

    public JpabReferenceManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.entitySearch = EntitySearch.getInstance(this.project);
        this.ddlGeneratorManager = JpabGeneratorManager.getInstance(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, PsiElement> getAllTables() {
        Object object;
        void $this$mapTo$iv$iv;
        PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.Companion.getInstance(this.project);
        Map result = MapsKt.toMutableMap(this.getEntityTables());
        Collection<PsiClass> collection = this.entitySearch.getEntities(GlobalSearchScope.allScope((Project)this.project));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getEntities(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            PsiClass psiClass = (PsiClass)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(EntityPsi.getInstance((PsiClass)it2));
        }
        List entities = (List)destination$iv$iv;
        for (Module module : ProjectUtil.getModules((Project)this.project)) {
            PsiElement psiElement;
            String tableName;
            Object it;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            String joinTableFqn = JpaAttributeAnnotation.JoinTable.getFqn(this.project, module);
            String collectionTableFqn = JpaAttributeAnnotation.CollectionTable.getFqn(this.project, module);
            Iterable it2 = entities;
            object = this.ddlGeneratorManager;
            boolean $i$f$map2 = false;
            void var13_20 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                EntityPsi entityPsi = (EntityPsi)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(it3.getFqn());
            }
            Map<String, JoinTableAttribute> map = ((JpabGeneratorManager)object).getJoinTables((List)destination$iv$iv2, false);
            Intrinsics.checkNotNullExpressionValue(map, (String)"getJoinTables(...)");
            Object $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            for (Map.Entry<String, JoinTableAttribute> element$iv : $this$forEach$iv.entrySet()) {
                EntityAttribute joinAttribute;
                it = element$iv;
                boolean bl = false;
                if (it.getValue().getAttribute() == null) continue;
                Intrinsics.checkNotNull((Object)namingStrategy.toTableName(it.getKey()));
                if (this.getReferenceToAnnotationOrAttr(joinTableFqn, joinAttribute) == null) continue;
                result.put(tableName, psiElement);
            }
            List<CollectionTableAttribute> list = this.ddlGeneratorManager.getCollectionTables(entities);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCollectionTables(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            Iterator<Map.Entry<String, JoinTableAttribute>> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, JoinTableAttribute> element$iv;
                element$iv = iterator.next();
                it = (CollectionTableAttribute)((Object)element$iv);
                boolean bl = false;
                EntityAttribute collectionAttribute = ((CollectionTableAttribute)it).getAttribute();
                Intrinsics.checkNotNull((Object)namingStrategy.toTableName(((CollectionTableAttribute)it).getTableName()));
                if (this.getReferenceToAnnotationOrAttr(collectionTableFqn, collectionAttribute) == null) continue;
                result.put(tableName, psiElement);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiElement findTableOwnerElementByTableName(@NotNull String tableName) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        PsiClass entityClass = this.findEntityClassByTableName(tableName);
        if (entityClass != null) {
            psiElement = (PsiElement)entityClass;
        } else {
            void $this$mapTo$iv$iv;
            Collection<PsiClass> collection = this.entitySearch.getEntities(GlobalSearchScope.allScope((Project)this.project));
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getEntities(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiClass psiClass = (PsiClass)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(EntityPsi.getInstance((PsiClass)it));
            }
            List entities = (List)destination$iv$iv;
            psiElement = this.findJoinOrCollectionTableElement(tableName, entities);
        }
        return psiElement;
    }

    @NotNull
    public final List<EntityAttribute> getTableAttributes(@NotNull String tableName) {
        List<EntityAttribute> list;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        PsiClass entityClass = this.findEntityClassByTableName(tableName);
        if (entityClass != null) {
            List<EntityAttribute> list2 = this.ddlGeneratorManager.getTableAttributes(EntityPsi.getInstance(entityClass), null);
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            List<EntityAttribute> list3 = this.ddlGeneratorManager.getJoinOrCollectionTableAttributes(tableName, false);
            Intrinsics.checkNotNull(list3);
            list = list3;
        }
        return list;
    }

    @Nullable
    public final PsiClass findEntityClassByTableName(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return this.entitySearch.findByTableName(tableName, EntitySearch.SearchScope.ALL);
    }

    @Nullable
    public final PsiMember findAttributeMember(@NotNull String tableName, @NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.Companion.getInstance(this.project);
        return (PsiMember)this.findWithTransform((Iterable)this.getTableAttributes(tableName), arg_0 -> JpabReferenceManager.findAttributeMember$lambda$0(namingStrategy, columnName, this, arg_0));
    }

    private final <T, R> R findWithTransform(Iterable<? extends T> $this$findWithTransform, Function1<? super T, ? extends Pair<Boolean, ? extends R>> mappingPredicate) {
        for (T element : $this$findWithTransform) {
            Pair pair = (Pair)mappingPredicate.invoke(element);
            boolean found = (Boolean)pair.component1();
            Object mapped = pair.component2();
            if (!found) continue;
            return (R)mapped;
        }
        return null;
    }

    private final Map<String, PsiElement> getEntityTables() {
        PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.Companion.getInstance(this.project);
        Map result = new LinkedHashMap();
        this.entitySearch.walkEntityClasses(GlobalSearchScope.allScope((Project)this.project), (Processor<PsiClass>)((Processor)arg_0 -> JpabReferenceManager.getEntityTables$lambda$0(result, namingStrategy, arg_0)));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findJoinOrCollectionTableElement(String tableName, List<? extends Entity> entities) {
        CollectionTableAttribute collectionAttribute;
        JoinTableAttribute joinAttribute;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = entities;
        String string = tableName;
        JpabGeneratorManager jpabGeneratorManager = this.ddlGeneratorManager;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entity entity = (Entity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFqn());
        }
        collection = (List)destination$iv$iv;
        JoinTableAttribute joinTableAttribute = joinAttribute = jpabGeneratorManager.findJoinTableAttribute(string, (List<String>)collection, false);
        if ((joinTableAttribute != null ? joinTableAttribute.getAttribute() : null) != null) {
            String joinTableFqn = JpaAttributeAnnotation.JoinTable.getFqn(this.project, joinAttribute.getEntity().getModule());
            EntityAttribute entityAttribute = joinAttribute.getAttribute();
            Intrinsics.checkNotNullExpressionValue((Object)entityAttribute, (String)"getAttribute(...)");
            return this.getReferenceToAnnotationOrAttr(joinTableFqn, entityAttribute);
        }
        CollectionTableAttribute collectionTableAttribute = collectionAttribute = this.ddlGeneratorManager.findCollectionTableAttribute(tableName, entities);
        if ((collectionTableAttribute != null ? collectionTableAttribute.getAttribute() : null) != null) {
            String collectionTableFqn = JpaAttributeAnnotation.CollectionTable.getFqn(this.project, collectionAttribute.getEntity().getModule());
            return this.getReferenceToAnnotationOrAttr(collectionTableFqn, collectionAttribute.getAttribute());
        }
        return null;
    }

    private final PsiElement getReferenceToAnnotationOrAttr(String annotationFqn, EntityAttribute attribute) {
        PsiElement psiElement = attribute.getPsiElement();
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null || (psiElement2 = (UField)UastContextKt.toUElement((PsiElement)psiElement2, UField.class)) == null || (psiElement2 = psiElement2.findAnnotation(annotationFqn)) == null || (psiElement2 = psiElement2.getSourcePsi()) == null) {
            psiElement2 = psiElement;
        }
        return psiElement2;
    }

    @Nullable
    public final PsiMember getAttributeMember(@NotNull EntityAttribute attr) {
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        if (attr instanceof EntityAttributePsi) {
            return ((EntityAttributePsi)attr).getMember();
        }
        if (attr instanceof EntityAttributeModel) {
            return ((EntityAttributeModel)attr).findMember(this.project);
        }
        return null;
    }

    @Nullable
    public final PsiElement findSequenceBySequenceName(@NotNull String sequenceName) {
        Intrinsics.checkNotNullParameter((Object)sequenceName, (String)"sequenceName");
        for (PsiElement psiElement : this.getAllTables().values()) {
            UField toUElement;
            EntityAttribute idAttr;
            String generatedFqn;
            String sequenceGeneratorFqn;
            EntityPsi entity;
            block7: {
                PsiClass entityClass;
                block6: {
                    if (SUastUtils.getContainingClass(psiElement) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)EntityPsi.getInstance(entityClass), (String)"getInstance(...)");
                    SequenceGenerator sequenceGenerator = entity.getSequenceGenerator();
                    sequenceGeneratorFqn = JpaAttributeAnnotation.SequenceGenerator.getFqn(this.project, entity.getModule());
                    generatedFqn = JpaAttributeAnnotation.GeneratedValue.getFqn(this.project, entity.getModule());
                    SequenceGenerator sequenceGenerator2 = sequenceGenerator;
                    if (Intrinsics.areEqual((Object)(sequenceGenerator2 != null ? sequenceGenerator2.getSequenceName() : null), (Object)sequenceName)) break block6;
                    SequenceGenerator sequenceGenerator3 = sequenceGenerator;
                    if (!Intrinsics.areEqual((Object)(sequenceGenerator3 != null ? sequenceGenerator3.getName() : null), (Object)sequenceName)) break block7;
                }
                PsiAnnotation psiAnnotation = entityClass.getAnnotation(sequenceGeneratorFqn);
                return psiAnnotation != null ? (PsiElement)psiAnnotation : (PsiElement)entityClass.getAnnotation(generatedFqn);
            }
            if (entity.getIdAttributeOrNull() == null) {
                return null;
            }
            if (!EntityUtil.isIdAttrWithSequenceOrAutoStrategy(idAttr, this.project).booleanValue() || (UField)UastContextKt.toUElement((PsiElement)idAttr.getPsiElement(), UField.class) == null || !Intrinsics.areEqual((Object)idAttr.getSequenceOrTableGeneratorName(), (Object)sequenceName) && !Intrinsics.areEqual((Object)idAttr.getGeneratorName(), (Object)sequenceName)) continue;
            Object object = toUElement.findAnnotation(sequenceGeneratorFqn);
            if (object == null || (object = object.getSourcePsi()) == null) {
                UAnnotation uAnnotation = toUElement.findAnnotation(generatedFqn);
                object = uAnnotation != null ? uAnnotation.getSourcePsi() : null;
            }
            return object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSequenceNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSequenceGenerators();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SequenceGenerator sequenceGenerator = (SequenceGenerator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSequenceName());
        }
        List result = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (JpaUtils.isHibernateProject(this.project)) {
            result.add("hibernate_sequence");
        } else if (JpaUtils.isEclipseLinkProject(this.project)) {
            result.add("seq_gen");
        }
        return CollectionsKt.sorted((Iterable)result);
    }

    @NotNull
    public final List<SequenceInfo> getSequenceNamesWithEntities() {
        List result = new ArrayList();
        for (PsiElement psiElement : this.getAllTables().values()) {
            EntityAttribute idAttr;
            EntityPsi entity;
            PsiClass entityClass;
            if (SUastUtils.getContainingClass(psiElement) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)EntityPsi.getInstance(entityClass), (String)"getInstance(...)");
            SequenceGenerator entitySeqGenerator = entity.getSequenceGenerator();
            if (this.isSuitableGenerator(entity) && entitySeqGenerator != null) {
                String entitySeqName = entitySeqGenerator.getSequenceName();
                String generatorName = entitySeqGenerator.getName();
                if (((CharSequence)entitySeqName).length() > 0) {
                    result.add(new SequenceInfo(entitySeqName, entity, false, 4, null));
                    continue;
                }
                if (!(((CharSequence)generatorName).length() > 0)) continue;
                result.add(new SequenceInfo(generatorName, entity, false, 4, null));
                continue;
            }
            if (entity.getIdAttributeOrNull() == null || !EntityUtil.isIdAttrWithSequenceOrAutoStrategy(idAttr, this.project).booleanValue()) continue;
            String attrGenName = idAttr.getGeneratorName();
            CharSequence charSequence = attrGenName;
            if (charSequence == null || charSequence.length() == 0) {
                if (JpaUtils.isHibernateProject(this.project)) {
                    result.add(new SequenceInfo("hibernate_sequence", entity, false, 4, null));
                    continue;
                }
                if (!JpaUtils.isEclipseLinkProject(this.project)) continue;
                result.add(new SequenceInfo("seq_gen", entity, false, 4, null));
                continue;
            }
            String attrSeqName = idAttr.getSequenceOrTableGeneratorName();
            CharSequence charSequence2 = attrSeqName;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                result.add(new SequenceInfo(attrSeqName, entity, false, 4, null));
                continue;
            }
            if (!(((CharSequence)attrGenName).length() > 0)) continue;
            result.add(new SequenceInfo(attrGenName, entity, false, 4, null));
        }
        return result;
    }

    @NotNull
    public final List<SequenceInfo> getSequenceGeneratorsWithEntities() {
        List result = new ArrayList();
        List<Entity> entities = this.entitySearch.getProjectWrapEntities();
        for (Entity entity : entities) {
            String attrSeqName;
            CharSequence charSequence;
            EntityAttribute idAttr;
            SequenceGenerator entitySeqGenerator = entity.getSequenceGenerator();
            if (entitySeqGenerator != null) {
                String entityGenName = entitySeqGenerator.getName();
                if (!(((CharSequence)entityGenName).length() > 0)) continue;
                result.add(new SequenceInfo(entityGenName, entity, true));
                continue;
            }
            if (entity.getIdAttributeOrNull() == null || !EntityUtil.isIdAttrWithSequenceOrAutoStrategy(idAttr, this.project).booleanValue() || (charSequence = (CharSequence)(attrSeqName = idAttr.getGeneratorName())) == null || charSequence.length() == 0) continue;
            result.add(new SequenceInfo(attrSeqName, entity, true));
        }
        return result;
    }

    @NotNull
    public final List<SequenceGenerator> getSequenceGenerators() {
        List result = new ArrayList();
        List<Entity> entities = this.entitySearch.getProjectWrapEntities();
        for (Entity entity : entities) {
            String attrGenName;
            EntityAttribute idAttr;
            SequenceGenerator entitySeqGenerator = entity.getSequenceGenerator();
            Intrinsics.checkNotNull((Object)entity);
            if (this.isSuitableGenerator(entity) && entitySeqGenerator != null) {
                String generatorName = entitySeqGenerator.getName();
                String entitySeqName = entitySeqGenerator.getSequenceName();
                int initialValue = entitySeqGenerator.getInitialValue();
                int allocationSize = entitySeqGenerator.getAllocationSize();
                boolean bl = ((CharSequence)entitySeqName).length() > 0 ? result.add(new SequenceGenerator(generatorName, entitySeqName, initialValue, allocationSize)) : result.add(new SequenceGenerator(generatorName, generatorName, initialValue, allocationSize));
                continue;
            }
            if (entity.getIdAttributeOrNull() == null || !EntityUtil.isIdAttrWithSequenceOrAutoStrategy(idAttr, this.project).booleanValue() || idAttr.getGeneratorName() == null) continue;
            String attrSeqName = idAttr.getSequenceOrTableGeneratorName();
            int initialValue = idAttr.getInitialValue();
            int allocationSize = idAttr.getAllocationSize();
            CharSequence charSequence = attrSeqName;
            if (!(charSequence == null || charSequence.length() == 0)) {
                result.add(new SequenceGenerator(attrGenName, attrSeqName, initialValue, allocationSize));
                continue;
            }
            if (!(((CharSequence)attrGenName).length() > 0)) continue;
            result.add(new SequenceGenerator(attrGenName, attrGenName, initialValue, allocationSize));
        }
        return result;
    }

    public final boolean isSuitableGenerator(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        EntityAttribute entityAttribute = entity.getIdAttributeOrNull();
        if (entityAttribute == null) {
            return false;
        }
        EntityAttribute idAttr = entityAttribute;
        if (!EntityUtil.isIdAttrWithSequenceOrAutoStrategy(idAttr, this.project).booleanValue()) {
            return false;
        }
        String attrGenName = idAttr.getGeneratorName();
        String attrSeqGen = idAttr.getSequenceOrTableGeneratorName();
        CharSequence charSequence = attrSeqGen;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return false;
        }
        SequenceGenerator entitySeqGenerator = entity.getSequenceGenerator();
        if (entitySeqGenerator != null) {
            String entityGenName = entitySeqGenerator.getName();
            return Intrinsics.areEqual((Object)entityGenName, (Object)attrGenName);
        }
        return false;
    }

    private static final Pair findAttributeMember$lambda$0(PhysicalNamingStrategy $namingStrategy, String $columnName, JpabReferenceManager this$0, EntityAttribute attr) {
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        return TuplesKt.to((Object)$namingStrategy.compareColumn(attr.getColumn(), $columnName), (Object)this$0.getAttributeMember(attr));
    }

    private static final boolean getEntityTables$lambda$0(Map $result, PhysicalNamingStrategy $namingStrategy, PsiClass psiClass) {
        String string;
        String string2 = EntityUtil.getTable(psiClass, false);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = $namingStrategy.toTableName(it);
        } else {
            string = null;
        }
        String tableName = string;
        CharSequence charSequence = tableName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !$result.containsKey(tableName)) {
            $result.put(tableName, psiClass);
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final JpabReferenceManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JpabReferenceManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JpabReferenceManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JpabReferenceManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager$SequenceInfo;", "", "name", "", "entity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "isGenerator", "", "<init>", "(Ljava/lang/String;Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;Z)V", "Lcom/intellij/jpa/jpb/model/model/Entity;", "(Ljava/lang/String;Lcom/intellij/jpa/jpb/model/model/Entity;Z)V", "getName", "()Ljava/lang/String;", "getEntity", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nJpabReferenceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpabReferenceManager.kt\ncom/intellij/jpa/jpb/model/service/JpabReferenceManager$SequenceInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
    public static final class SequenceInfo {
        @NotNull
        private final String name;
        @Nullable
        private final OrmEntity entity;
        private final boolean isGenerator;

        public SequenceInfo(@NotNull String name, @Nullable OrmEntity entity, boolean isGenerator) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.entity = entity;
            this.isGenerator = isGenerator;
        }

        public /* synthetic */ SequenceInfo(String string, OrmEntity ormEntity, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, ormEntity, bl);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final OrmEntity getEntity() {
            return this.entity;
        }

        public final boolean isGenerator() {
            return this.isGenerator;
        }

        /*
         * WARNING - void declaration
         */
        public SequenceInfo(@NotNull String name, @Nullable Entity entity, boolean isGenerator) {
            CustomJpaOrmEntity customJpaOrmEntity;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            SequenceInfo sequenceInfo = this;
            String string = name;
            Entity entity2 = entity;
            if (entity2 != null) {
                void it;
                Entity entity3 = entity2;
                String string2 = string;
                SequenceInfo sequenceInfo2 = sequenceInfo;
                boolean bl = false;
                CustomJpaOrmEntity customJpaOrmEntity2 = new CustomJpaOrmEntity((Entity)it);
                sequenceInfo = sequenceInfo2;
                string = string2;
                customJpaOrmEntity = customJpaOrmEntity2;
            } else {
                customJpaOrmEntity = null;
            }
            sequenceInfo(string, customJpaOrmEntity, isGenerator);
        }

        public /* synthetic */ SequenceInfo(String string, Entity entity, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string, entity, bl);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final OrmEntity component2() {
            return this.entity;
        }

        public final boolean component3() {
            return this.isGenerator;
        }

        @NotNull
        public final SequenceInfo copy(@NotNull String name, @Nullable OrmEntity entity, boolean isGenerator) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new SequenceInfo(name, entity, isGenerator);
        }

        public static /* synthetic */ SequenceInfo copy$default(SequenceInfo sequenceInfo, String string, OrmEntity ormEntity, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = sequenceInfo.name;
            }
            if ((n & 2) != 0) {
                ormEntity = sequenceInfo.entity;
            }
            if ((n & 4) != 0) {
                bl = sequenceInfo.isGenerator;
            }
            return sequenceInfo.copy(string, ormEntity, bl);
        }

        @NotNull
        public String toString() {
            return "SequenceInfo(name=" + this.name + ", entity=" + this.entity + ", isGenerator=" + this.isGenerator + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.entity == null ? 0 : this.entity.hashCode());
            result = result * 31 + Boolean.hashCode(this.isGenerator);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SequenceInfo)) {
                return false;
            }
            SequenceInfo sequenceInfo = (SequenceInfo)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)sequenceInfo.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.entity, (Object)sequenceInfo.entity)) {
                return false;
            }
            return this.isGenerator == sequenceInfo.isGenerator;
        }
    }
}

