/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.service;

import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0000H\u0002J\u001c\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jpa/jpb/model/service/ScriptService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "searchHelper", "Lcom/intellij/jpa/jpb/model/util/SearchHelper;", "kotlin.jvm.PlatformType", "evaluateScript", "psiClass", "Lcom/intellij/psi/PsiClass;", "scriptText", "", "createClassLoader", "Ljava/lang/ClassLoader;", "dependencies", "Lcom/intellij/jpa/jpb/model/service/ScriptService$Dependencies;", "createFullScript", "userScript", "Companion", "Dependencies", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nScriptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptService.kt\ncom/intellij/jpa/jpb/model/service/ScriptService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,112:1\n1642#2,10:113\n1915#2:123\n1916#2:125\n1652#2:126\n1#3:124\n37#4,2:127\n*S KotlinDebug\n*F\n+ 1 ScriptService.kt\ncom/intellij/jpa/jpb/model/service/ScriptService\n*L\n41#1:113,10\n41#1:123\n41#1:125\n41#1:126\n41#1:124\n46#1:127,2\n*E\n"})
public final class ScriptService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final SearchHelper searchHelper;

    public ScriptService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.searchHelper = SearchHelper.getInstance(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Object evaluateScript(@NotNull PsiClass psiClass, @NotNull String scriptText) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)scriptText, (String)"scriptText");
        Dependencies dependencies = new Dependencies(this, null, null, null, 7, null);
        dependencies.collectForClass(psiClass);
        ClassLoader classLoader = this.createClassLoader(dependencies);
        String fullScript = this.createFullScript(dependencies, scriptText);
        Object object = new GroovyScriptEngineImpl(new GroovyClassLoader(classLoader)).eval(fullScript);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"eval(...)");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ClassLoader createClassLoader(Dependencies dependencies) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = dependencies.getLibraries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            URL uRL;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Library library = (Library)element$iv$iv;
            boolean bl2 = false;
            Object object = VfsUtil.getVirtualFileForJar((VirtualFile)library.getFiles(OrderRootType.CLASSES)[0]);
            if (object == null || (object = object.getPresentableUrl()) == null) {
                uRL = null;
            } else {
                Object path = object;
                uRL = new File((String)path).toURI().toURL();
            }
            if (uRL == null) continue;
            URL it$iv$iv = uRL;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] libraryUrls = thisCollection$iv.toArray(new URL[0]);
        return new URLClassLoader(libraryUrls, ScriptService.class.getClassLoader());
    }

    private final String createFullScript(Dependencies dependencies, String userScript) {
        return StringsKt.trimIndent((String)("\n            " + CollectionsKt.joinToString$default((Iterable)dependencies.getLibraryClassFqns(), (CharSequence)"\n", null, null, (int)0, null, ScriptService::createFullScript$lambda$0, (int)30, null) + "\n            " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)dependencies.getProjectClasses().entrySet()), (CharSequence)"\n\n", null, null, (int)0, null, ScriptService::createFullScript$lambda$1, (int)30, null) + "\n            \n            " + userScript + "\n        "));
    }

    private static final CharSequence createFullScript$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "import " + it + ";";
    }

    private static final CharSequence createFullScript$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getValue();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/service/ScriptService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/service/ScriptService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nScriptService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptService.kt\ncom/intellij/jpa/jpb/model/service/ScriptService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,112:1\n30#2,2:113\n*S KotlinDebug\n*F\n+ 1 ScriptService.kt\ncom/intellij/jpa/jpb/model/service/ScriptService$Companion\n*L\n25#1:113,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ScriptService> serviceClass$iv = ScriptService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ScriptService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B=\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jpa/jpb/model/service/ScriptService$Dependencies;", "", "projectClasses", "", "", "libraryClassFqns", "", "libraries", "Lcom/intellij/openapi/roots/libraries/Library;", "<init>", "(Lcom/intellij/jpa/jpb/model/service/ScriptService;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;)V", "getProjectClasses", "()Ljava/util/Map;", "getLibraryClassFqns", "()Ljava/util/Set;", "getLibraries", "parentClassLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "collectForClass", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "walkThroughProjectClass", "isProcessed", "", "fqn", "isClassInParentClassLoader", "intellij.javaee.jpa.jpb.model"})
    private final class Dependencies {
        @NotNull
        private final Map<String, String> projectClasses;
        @NotNull
        private final Set<String> libraryClassFqns;
        @NotNull
        private final Set<Library> libraries;
        private final ClassLoader parentClassLoader;
        final /* synthetic */ ScriptService this$0;

        public Dependencies(@NotNull ScriptService this$0, @NotNull Map<String, String> projectClasses, @NotNull Set<String> libraryClassFqns, Set<Library> libraries) {
            Intrinsics.checkNotNullParameter(projectClasses, (String)"projectClasses");
            Intrinsics.checkNotNullParameter(libraryClassFqns, (String)"libraryClassFqns");
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            this.this$0 = this$0;
            this.projectClasses = projectClasses;
            this.libraryClassFqns = libraryClassFqns;
            this.libraries = libraries;
            this.parentClassLoader = Dependencies.class.getClassLoader();
        }

        public /* synthetic */ Dependencies(ScriptService scriptService, Map map, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 2) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 4) != 0) {
                set2 = new LinkedHashSet();
            }
            this(scriptService, map, set, set2);
        }

        @NotNull
        public final Map<String, String> getProjectClasses() {
            return this.projectClasses;
        }

        @NotNull
        public final Set<String> getLibraryClassFqns() {
            return this.libraryClassFqns;
        }

        @NotNull
        public final Set<Library> getLibraries() {
            return this.libraries;
        }

        public final void collectForClass(@NotNull PsiClass psiClass) {
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            this.walkThroughProjectClass(psiClass);
            Object[] objectArray = LibraryTablesRegistrar.getInstance().getLibraryTable(this.this$0.getProject()).getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getLibraries(...)");
            Object[] transitiveLibraries = objectArray;
            CollectionsKt.addAll((Collection)this.libraries, (Object[])transitiveLibraries);
        }

        private final void walkThroughProjectClass(PsiClass psiClass) {
            String string = psiClass.getQualifiedName();
            if (string == null) {
                return;
            }
            String fqn = string;
            if (this.projectClasses.containsKey(fqn)) {
                return;
            }
            this.projectClasses.put(fqn, psiClass.getText());
            for (PsiJavaCodeReferenceElement reference : PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)psiClass), PsiJavaCodeReferenceElement.class)) {
                PsiClass referenceClass;
                PsiElement psiElement;
                String referenceFqn = reference.getQualifiedName();
                Intrinsics.checkNotNull((Object)referenceFqn);
                if (this.isProcessed(referenceFqn) || this.isClassInParentClassLoader(referenceFqn) || ((psiElement = reference.resolve()) instanceof PsiClass ? (PsiClass)psiElement : null) == null) continue;
                referenceClass = referenceClass;
                Library library = this.this$0.searchHelper.findLibraryContainingFile(referenceClass.getContainingFile().getVirtualFile());
                if (library == null) {
                    this.walkThroughProjectClass(referenceClass);
                    continue;
                }
                this.libraryClassFqns.add(referenceFqn);
            }
        }

        private final boolean isProcessed(String fqn) {
            return this.projectClasses.containsKey(fqn) || this.libraryClassFqns.contains(fqn);
        }

        private final boolean isClassInParentClassLoader(String fqn) {
            boolean bl;
            try {
                this.parentClassLoader.loadClass(fqn);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            return bl;
        }
    }
}

