/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.editor;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImplKt;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.ui.components.JBScrollPane;
import java.util.UUID;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/PreviewTextEditor;", "", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "getTextEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "setText", "", "text", "", "dispose", "Companion", "intellij.javaee.jpa.jpb.model.ui"})
public final class PreviewTextEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextEditor textEditor;

    public PreviewTextEditor(@NotNull TextEditor textEditor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        this.textEditor = textEditor;
    }

    @NotNull
    public final TextEditor getTextEditor() {
        return this.textEditor;
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.textEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    public final void setText(@Nullable String text) {
        Document document = this.textEditor.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        boolean isWritable = document2.isWritable();
        document2.setReadOnly(false);
        WriteAction.run(() -> PreviewTextEditor.setText$lambda$0(document2, text));
        document2.setReadOnly(!isWritable);
    }

    public final void dispose() {
        TextEditorProvider.Companion.getInstance().disposeEditor((FileEditor)this.textEditor);
    }

    private static final void setText$lambda$0(Document $document, String $text) {
        String string = $text;
        if (string == null) {
            string = "";
        }
        $document.setText((CharSequence)string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/jpa/jpb/model/ui/editor/PreviewTextEditor$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/jpa/jpb/model/ui/editor/PreviewTextEditor;", "project", "Lcom/intellij/openapi/project/Project;", "fileExt", "", "intellij.javaee.jpa.jpb.model.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PreviewTextEditor create(@NotNull Project project, @NotNull String fileExt) {
            EditorImpl editor;
            BinaryLightVirtualFile tempSqlVirtualFile;
            block0: {
                JBScrollPane jBScrollPane;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)fileExt, (String)"fileExt");
                String string = UUID.randomUUID() + "." + fileExt;
                String string2 = "";
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                tempSqlVirtualFile = new BinaryLightVirtualFile(string, byArray);
                tempSqlVirtualFile.setWritable(false);
                UndoUtil.disableUndoFor((VirtualFile)((VirtualFile)tempSqlVirtualFile));
                Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)tempSqlVirtualFile, project);
                Intrinsics.checkNotNull((Object)document);
                Document document2 = document;
                EditorFactory editorFactory = EditorFactory.getInstance();
                Intrinsics.checkNotNull((Object)editorFactory, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorFactoryImpl");
                Editor editor2 = ((EditorFactoryImpl)editorFactory).createViewer(document2);
                Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                editor = (EditorImpl)editor2;
                EditorSettings editorSettings = editor.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
                EditorSettings settings = editorSettings;
                settings.setFoldingOutlineShown(false);
                settings.setLineMarkerAreaShown(false);
                settings.setGutterIconsShown(false);
                settings.setIndentGuidesShown(false);
                EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
                JComponent jComponent = editorEx != null ? editorEx.getScrollPane() : null;
                JBScrollPane jBScrollPane2 = jBScrollPane = jComponent instanceof JBScrollPane ? (JBScrollPane)jComponent : null;
                if (jBScrollPane == null || (jComponent = jBScrollPane.getStatusComponent()) == null) break block0;
                JComponent it = jComponent;
                boolean bl = false;
                it.setVisible(false);
            }
            return new PreviewTextEditor((TextEditor)new TextEditorImpl(project, (VirtualFile)tempSqlVirtualFile, TuplesKt.to((Object)new TextEditorComponent((VirtualFile)tempSqlVirtualFile, editor), (Object)TextEditorImplKt.createAsyncEditorLoader((TextEditorProvider)TextEditorProvider.Companion.getInstance(), (Project)project, (VirtualFile)((VirtualFile)tempSqlVirtualFile), null))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

