/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.settings;

import com.intellij.jpa.jpb.model.config.DatabaseDriversConfigState;
import com.intellij.jpa.jpb.model.config.DbDriver;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MssqlJtdsType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MssqlType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.ui.settings.DbDriverPanel;
import com.intellij.jpa.jpb.model.util.JpaUiUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.framework.base.IRdBindableKt;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jpa/jpb/model/ui/settings/DatabaseDriversConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "<init>", "()V", "state", "Lcom/intellij/jpa/jpb/model/config/DatabaseDriversConfigState;", "getState", "()Lcom/intellij/jpa/jpb/model/config/DatabaseDriversConfigState;", "driversCopy", "", "Lcom/intellij/jpa/jpb/model/config/DbDriver;", "getDriversCopy", "()Ljava/util/List;", "itemPanel", "Lcom/intellij/jpa/jpb/model/ui/settings/DbDriverPanel;", "itemPanelWrapper", "Ljavax/swing/JPanel;", "splitter", "Lcom/intellij/openapi/ui/Splitter;", "driversModel", "Lcom/intellij/ui/CollectionListModel;", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "apply", "", "reset", "getId", "", "getDisplayName", "getHelpTopic", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nDatabaseDriversConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDriversConfigurable.kt\ncom/intellij/jpa/jpb/model/ui/settings/DatabaseDriversConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1807#2,2:139\n1809#2:142\n777#2:143\n873#2,2:144\n1586#2:146\n1661#2,3:147\n1586#2:150\n1661#2,3:151\n1586#2:154\n1661#2,3:155\n1#3:141\n*S KotlinDebug\n*F\n+ 1 DatabaseDriversConfigurable.kt\ncom/intellij/jpa/jpb/model/ui/settings/DatabaseDriversConfigurable\n*L\n105#1:139,2\n105#1:142\n115#1:143\n115#1:144,2\n115#1:146\n115#1:147,3\n123#1:150\n123#1:151,3\n125#1:154\n125#1:155,3\n*E\n"})
public final class DatabaseDriversConfigurable
implements Configurable,
SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseDriversConfigState state = DatabaseDriversConfigState.Companion.getInstance();
    @NotNull
    private final List<DbDriver> driversCopy = (List)IRdBindableKt.deepClonePolymorphic(this.state.getDrivers());
    @NotNull
    private final DbDriverPanel itemPanel;
    @NotNull
    private final JPanel itemPanelWrapper;
    @NotNull
    private final Splitter splitter = new Splitter(false, 0.3f);
    @NotNull
    private final CollectionListModel<DbDriver> driversModel = new CollectionListModel((Object[])new DbDriver[0]);
    @NotNull
    public static final String EMPTY = "empty";
    @NotNull
    public static final String PANEL = "panel";
    @NotNull
    private static final String ID = "com.intellij.jpa.jpb.model.databaseDrivers";
    @Nls
    @NotNull
    private static final String DISPLAY_NAME;

    public DatabaseDriversConfigurable() {
        CardLayout cardLayout = new CardLayout();
        this.itemPanelWrapper = new JPanel(cardLayout);
        Object object = ReadAction.compute(DatabaseDriversConfigurable::_init_$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        this.itemPanel = (DbDriverPanel)((Object)object);
        JBList driversList = new JBList((ListModel)this.driversModel);
        driversList.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1));
        driversList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> DatabaseDriversConfigurable._init_$lambda$2(DatabaseDriversConfigurable::_init_$lambda$1, arg_0, arg_1, arg_2)));
        driversList.addListSelectionListener(arg_0 -> DatabaseDriversConfigurable._init_$lambda$3(driversList, cardLayout, this, arg_0));
        JLabel descLabel = new JLabel(JpaModelBundle.message("database.driver.not.selected", new Object[0]));
        descLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)25));
        this.itemPanelWrapper.add((Component)descLabel, EMPTY);
        this.itemPanelWrapper.add((Component)((Object)this.itemPanel), PANEL);
        this.splitter.setFirstComponent((JComponent)driversList);
        this.splitter.setSecondComponent((JComponent)this.itemPanelWrapper);
    }

    @NotNull
    public final DatabaseDriversConfigState getState() {
        return this.state;
    }

    @NotNull
    public final List<DbDriver> getDriversCopy() {
        return this.driversCopy;
    }

    @NotNull
    public JComponent createComponent() {
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel $this$createComponent_u24lambda_u240 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        $this$createComponent_u24lambda_u240.addToCenter((Component)this.splitter);
        return (JComponent)borderLayoutPanel;
    }

    public boolean isModified() {
        boolean bl;
        block5: {
            this.itemPanel.save();
            List list = this.driversModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DbDriver stateDriver;
                    Object v2;
                    DbDriver editableDriver;
                    block4: {
                        editableDriver = (DbDriver)element$iv;
                        boolean bl2 = false;
                        Iterable iterable = this.state.getDrivers();
                        for (Object t : iterable) {
                            DbDriver it = (DbDriver)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)editableDriver.getId(), (Object)it.getId())) continue;
                            v2 = t;
                            break block4;
                        }
                        v2 = null;
                    }
                    boolean bl4 = (DbDriver)v2 == null ? !editableDriver.isEmpty() : !Intrinsics.areEqual((Object)stateDriver.getVersion(), (Object)editableDriver.getVersion()) || !Intrinsics.areEqual(stateDriver.getLibraries(), editableDriver.getLibraries());
                    if (!bl4) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void apply() {
        this.itemPanel.save();
        if (this.isModified()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DbDriver it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List list = this.driversModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            Iterable iterable = list;
            DatabaseDriversConfigState databaseDriversConfigState = this.state;
            boolean $i$f$filter = false;
            void var3_4 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DbDriver)element$iv$iv;
                boolean bl = false;
                if (!(!it.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DbDriver)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.clone());
            }
            databaseDriversConfigState.setDrivers(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reset() {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        this.driversModel.removeAll();
        Iterable $this$map$iv = DbType.Companion.allTypes(true);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DbType dbType = (DbType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDriverClass());
        }
        $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Object v0;
            void driverClass;
            Object object2;
            block4: {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object2 = this.state.getDrivers();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    DbDriver it2 = (DbDriver)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)driverClass)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            if ((object = (DbDriver)v0) == null || (object = ((DbDriver)object).clone()) == null) {
                Object $this$reset_u24lambda_u241_u241 = object2 = new DbDriver();
                boolean bl = false;
                ((DbDriver)$this$reset_u24lambda_u241_u241).setId((String)driverClass);
                object = object2;
            }
            collection.add(object);
        }
        List drivers = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        this.driversModel.add(drivers);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getHelpTopic() {
        return JpaHelpConstants.PluginDoc.INSTANCE.getDatabaseDrivers();
    }

    private static final DbDriverPanel _init_$lambda$0() {
        return new DbDriverPanel();
    }

    private static final Unit _init_$lambda$1(JBLabel label, DbDriver value, int n) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            if (value == null) {
                return Unit.INSTANCE;
            }
            Iterable iterable = DbType.Companion.allTypes(true);
            for (Object t : iterable) {
                DbType it = (DbType)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDriverClass(), (Object)value.getId())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        DbType dbType = v0;
        if (dbType == null) {
            label.setText(value.getId());
            return Unit.INSTANCE;
        }
        label.setIcon(JpaUiUtil.getDbTypeIcon(dbType));
        if (dbType instanceof MssqlType) {
            label.setText(dbType instanceof MssqlJtdsType ? JpaModelBundle.message("microsoft.sql.server.jtds", new Object[0]) : JpaModelBundle.message("microsoft.sql.server", new Object[0]));
        } else {
            label.setText(dbType.getCaption());
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$2(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final void _init_$lambda$3(JBList $driversList, CardLayout $cardLayout, DatabaseDriversConfigurable this$0, ListSelectionEvent it) {
        DbDriver selectedDriver = (DbDriver)$driversList.getSelectedValue();
        if (selectedDriver == null) {
            $cardLayout.show(this$0.itemPanelWrapper, EMPTY);
            this$0.itemPanel.setDbDriver(null);
        } else {
            $cardLayout.show(this$0.itemPanelWrapper, PANEL);
            this$0.itemPanel.setDbDriver(selectedDriver);
        }
    }

    static {
        String string = JpaModelBundle.message("database.drivers", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DISPLAY_NAME = string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/jpa/jpb/model/ui/settings/DatabaseDriversConfigurable$Companion;", "", "<init>", "()V", "EMPTY", "", "PANEL", "ID", "getID", "()Ljava/lang/String;", "DISPLAY_NAME", "getDISPLAY_NAME", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getID() {
            return ID;
        }

        @NotNull
        public final String getDISPLAY_NAME() {
            return DISPLAY_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

