/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.auto;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@Service
public final class ChangeTracker
implements Disposable {
    private static final int RANGES_THRESHOLD = 100;
    private static final Key<Deque<RecentChange>> DATA_KEY = Key.create((String)"Grazie.Pro.RecentChanges");
    private static final Key<List<RangeMarker>> UNDONE_RANGES = Key.create((String)"Grazie.Pro.UndoneChanges");

    ChangeTracker() {
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Editor[] editors;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editors = EditorFactory.getInstance().getEditors(event.getDocument())).length == 0) {
                    return;
                }
                if (ChangeTracker.isEditing(editors)) {
                    ChangeTracker.this.registerChange(event);
                } else if (ChangeTracker.isUndoInProgress(editors)) {
                    ChangeTracker.this.registerUndo(event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/grazie/ide/inspection/auto/ChangeTracker$1", "documentChanged"));
            }
        }, (Disposable)this);
    }

    private static boolean isEditing(Editor[] editors) {
        String cmdName = CommandProcessor.getInstance().getCurrentCommandName();
        return EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]).equals(cmdName) || CodeInsightBundle.message((String)"completion.automatic.command.name", (Object[])new Object[0]).equals(cmdName) || ContainerUtil.exists((Object[])editors, e -> LookupManager.getActiveLookup((Editor)e) != null);
    }

    private static boolean isUndoInProgress(Editor[] editors) {
        return ContainerUtil.exists((Object[])editors, e -> e.getProject() != null && UndoManager.getInstance((Project)e.getProject()).isUndoInProgress());
    }

    private synchronized void registerChange(DocumentEvent event) {
        Document document = event.getDocument();
        ArrayDeque<RecentChange> changes = (ArrayDeque<RecentChange>)document.getUserData(DATA_KEY);
        if (changes == null) {
            changes = new ArrayDeque<RecentChange>(100);
            document.putUserData(DATA_KEY, changes);
        }
        long now = System.nanoTime();
        Iterator iterator = changes.iterator();
        while (iterator.hasNext()) {
            RecentChange change2 = (RecentChange)iterator.next();
            if (change2.isRelevant(now)) continue;
            change2.marker.dispose();
            iterator.remove();
        }
        while (changes.size() >= 100) {
            ((RecentChange)changes.removeFirst()).marker.dispose();
        }
        if (!ContainerUtil.exists(changes, change -> ChangeTracker.coversSameRange(change.marker, event))) {
            changes.addLast(new RecentChange(now, ChangeTracker.createMarker(event)));
        }
    }

    private static boolean coversSameRange(RangeMarker marker, DocumentEvent event) {
        return marker.getStartOffset() == event.getOffset() && marker.getEndOffset() == event.getOffset() + event.getNewLength();
    }

    @NotNull
    private static RangeMarker createMarker(DocumentEvent event) {
        RangeMarker rangeMarker = event.getDocument().createRangeMarker(TextRange.from((int)event.getOffset(), (int)event.getNewLength()));
        if (rangeMarker == null) {
            ChangeTracker.$$$reportNull$$$0(0);
        }
        return rangeMarker;
    }

    private synchronized void registerUndo(DocumentEvent event) {
        Document document = event.getDocument();
        ArrayList<RangeMarker> ranges = (ArrayList<RangeMarker>)document.getUserData(UNDONE_RANGES);
        if (ranges == null) {
            ranges = new ArrayList<RangeMarker>();
            document.putUserData(UNDONE_RANGES, ranges);
        }
        ranges.removeIf(r -> !r.isValid());
        ranges.add(ChangeTracker.createMarker(event));
    }

    public static ChangeTracker getInstance() {
        return (ChangeTracker)ApplicationManager.getApplication().getService(ChangeTracker.class);
    }

    synchronized boolean mayAutoChange(Document document, TextRange range) {
        Deque changes = (Deque)document.getUserData(DATA_KEY);
        if (changes == null) {
            return false;
        }
        long now = System.nanoTime();
        return ContainerUtil.exists((Iterable)changes, c -> c.isRelevant(now) && c.marker.getTextRange().intersects(range));
    }

    synchronized boolean isExplicitlyUndone(Document document, TextRange range) {
        List undone = (List)document.getUserData(UNDONE_RANGES);
        return undone != null && ContainerUtil.exists((Iterable)undone, r -> r.isValid() && r.getTextRange().intersects(range));
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/grazie/ide/inspection/auto/ChangeTracker", "createMarker"));
    }

    private record RecentChange(long time, RangeMarker marker) {
        private static final long TRACKING_INTERVAL = TimeUnit.MINUTES.toNanos(1L);

        boolean isRelevant(long now) {
            return this.marker.isValid() && now - this.time <= TRACKING_INTERVAL;
        }
    }
}

