/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.hunspell;

import com.intellij.grazie.spellcheck.hunspell.HunspellBundle;
import com.intellij.grazie.spellcheck.hunspell.HunspellDictionary;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.ui.SpellCheckingNotifier;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0016J\r\u0010\f\u001a\u00070\t\u00a2\u0006\u0002\b\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/spellcheck/hunspell/HunspellDictionaryProvider;", "Lcom/intellij/spellchecker/dictionary/CustomDictionaryProvider;", "<init>", "()V", "isHunspellPluginInstalled", "", "get", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "dicPath", "", "isApplicable", "path", "getDictionaryType", "Lorg/jetbrains/annotations/Nls;", "isHungarian", "isIncompleteHunspell", "intellij.grazie.core"})
public final class HunspellDictionaryProvider
implements CustomDictionaryProvider {
    private final boolean isHunspellPluginInstalled() {
        PluginId hunspellId = PluginId.Companion.getId("hunspell");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)hunspellId);
        return PluginManagerCore.isPluginInstalled((PluginId)hunspellId) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled();
    }

    @Nullable
    public Dictionary get(@NotNull String dicPath) {
        Intrinsics.checkNotNullParameter((Object)dicPath, (String)"dicPath");
        try {
            if (this.isIncompleteHunspell(dicPath)) {
                HunspellBundle hunspellBundle = HunspellDictionary.Companion.getHunspellBundle(dicPath);
                File dic = hunspellBundle.component1();
                File aff = hunspellBundle.component2();
                String string = SpellCheckerBundle.message((String)"dictionary.hunspell.incomplete.title", (Object[])new Object[0]);
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)dic.toPath().getFileName(), (String)"getFileName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)aff.toPath().getFileName(), (String)"getFileName(...)");
                SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(string, SpellCheckerBundle.message((String)"dictionary.hunspell.incomplete", (Object[])objectArray));
                return null;
            }
            if (this.isHungarian(dicPath)) {
                Object[] objectArray = new Object[]{dicPath};
                SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(SpellCheckerBundle.message((String)"dictionary.unsupported.language.title", (Object[])new Object[0]), SpellCheckerBundle.message((String)"dictionary.unsupported.language", (Object[])objectArray));
                return null;
            }
            return new HunspellDictionary(dicPath, null, null, 6, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{dicPath};
            SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(SpellCheckerBundle.message((String)"dictionary.not.found.title", (Object[])new Object[0]), SpellCheckerBundle.message((String)"dictionary.not.found", (Object[])objectArray));
        }
        catch (ParseException parseException) {
            Object[] objectArray = new Object[]{dicPath};
            SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(SpellCheckerBundle.message((String)"dictionary.unsupported.format.title", (Object[])new Object[0]), SpellCheckerBundle.message((String)"dictionary.unsupported.format", (Object[])objectArray));
        }
        return null;
    }

    public boolean isApplicable(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !(!HunspellDictionary.Companion.isHunspell(path) && !this.isIncompleteHunspell(path) || this.isHunspellPluginInstalled() && this.isHungarian(path));
    }

    @NotNull
    public String getDictionaryType() {
        return SpellCheckerBundle.message((String)"hunspell.dictionary", (Object[])new Object[0]);
    }

    private final boolean isHungarian(String path) {
        if (!Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)path), (Object)"dic")) {
            return false;
        }
        File aff = HunspellDictionary.Companion.getHunspellBundle(path).component2();
        if (!aff.exists()) {
            return false;
        }
        try {
            Iterator iterator = FilesKt.readLines$default((File)aff, null, (int)1, null).iterator();
            while (iterator.hasNext()) {
                int n;
                Regex regex = new Regex("\\s+");
                String line = (String)iterator.next();
                Object[] objectArray = (Object[])line;
                List args = regex.split((CharSequence)objectArray, n = 0);
                if (args.size() != 2 || !Intrinsics.areEqual(args.get(0), (Object)"LANG")) continue;
                objectArray = new String[]{"hu", "HU", "hu_HU"};
                return SetsKt.setOf((Object[])objectArray).contains(args.get(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private final boolean isIncompleteHunspell(String path) {
        if (!Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)path), (Object)"dic")) {
            return false;
        }
        HunspellBundle hunspellBundle = HunspellDictionary.Companion.getHunspellBundle(path);
        File dic = hunspellBundle.component1();
        File aff = hunspellBundle.component2();
        if (dic.exists() && !aff.exists()) {
            try {
                for (String line : FilesKt.readLines$default((File)dic, null, (int)1, null)) {
                    if (!StringsKt.contains$default((CharSequence)line, (char)'/', (boolean)false, (int)2, null)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

