/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import ai.grazie.nlp.langs.Language;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.GrazieUtilsKt;
import com.intellij.grazie.utils.Text;
import com.intellij.util.containers.ContainerUtil;

public final class ProblemFilterUtil {
    public static boolean isInitialCasingIssue(TextProblem problem) {
        return ContainerUtil.exists(problem.getHighlightRanges(), r -> r.getStartOffset() == 0) && problem.fitsGroup(RuleGroup.CASING);
    }

    public static boolean isUndecoratedSingleSentenceIssue(TextProblem problem) {
        return Text.isSingleSentence(problem.getText()) && problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE);
    }

    public static boolean isMissingArticleIssue(TextProblem problem) {
        Rule rule = problem.getRule();
        if (rule.getLanguage() != Language.ENGLISH) {
            return false;
        }
        return ProblemFilterUtil.getAssociatedRuleGlobalId(rule).endsWith(".MISSING_ARTICLE");
    }

    private static String getAssociatedRuleGlobalId(Rule rule) {
        ai.grazie.rules.Rule grazieRule = GrazieUtilsKt.getAssociatedGrazieRule(rule);
        return grazieRule == null ? rule.getGlobalId() : grazieRule.globalId();
    }
}

