/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.execution.logging;

import com.intellij.jupyter.execution.logging.NotebookLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/execution/logging/NotebookLoggerFactory;", "", "<init>", "()V", "isUnitTestMode", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logs", "", "Lcom/intellij/jupyter/execution/logging/NotebookLogger$LogEntry;", "getTrackedLogs", "", "getInstance", "Lcom/intellij/openapi/diagnostic/Logger;", "type", "Lkotlin/reflect/KClass;", "intellij.jupyter.execution"})
public final class NotebookLoggerFactory {
    @NotNull
    public static final NotebookLoggerFactory INSTANCE = new NotebookLoggerFactory();
    @NotNull
    private static final AtomicBoolean isUnitTestMode = new AtomicBoolean(false);
    @NotNull
    private static final List<NotebookLogger.LogEntry> logs = new ArrayList();

    private NotebookLoggerFactory() {
    }

    @NotNull
    public final List<NotebookLogger.LogEntry> getTrackedLogs() {
        return CollectionsKt.toList((Iterable)logs);
    }

    @NotNull
    public final Logger getInstance(@NotNull KClass<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Logger logger = Logger.getInstance((Class)JvmClassMappingKt.getJavaClass(type));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger systemLogger = logger;
        return isUnitTestMode.get() ? (Logger)new NotebookLogger(systemLogger, (Function1<? super NotebookLogger.LogEntry, Unit>)((Function1)NotebookLoggerFactory::getInstance$lambda$0)) : systemLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit getInstance$lambda$0(NotebookLogger.LogEntry logEntry) {
        Intrinsics.checkNotNullParameter((Object)logEntry, (String)"logEntry");
        List<NotebookLogger.LogEntry> list = logs;
        synchronized (list) {
            boolean bl = false;
            logs.add(logEntry);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

