/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol.comms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.Comm;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommCloseCallback;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommMsgCallback;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommOpenCallback;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.comms.CommCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.protocol.comms.CommManagerInternal;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0016J:\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002J \u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J0\u0010#\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u000e\u0010$\u001a\u00020\"2\u0006\u0010 \u001a\u00020\bJ\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130&2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J0\u0010'\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0018\u0010(\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010)\u001a\u00020\tH\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\rR\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerImpl;", "Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerInternal;", "connection", "Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommCommunicationFacility;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommCommunicationFacility;)V", "commOpenCallbacks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommOpenCallback;", "commTargetToIds", "Ljava/util/concurrent/CopyOnWriteArrayList;", "commIdToComm", "Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerImpl$CommImpl;", "contextMessage", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "getContextMessage", "()Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "openComm", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Comm;", "target", "data", "Lkotlinx/serialization/json/JsonObject;", "metadata", "buffers", "", "", "processCommOpen", "commId", "targetName", "Lkotlinx/serialization/json/JsonElement;", "registerNewComm", "id", "closeComm", "", "processCommClose", "removeComm", "getComms", "", "processCommMessage", "registerCommTarget", "callback", "unregisterCommTarget", "CommImpl", "Companion", "protocol"})
@SourceDebugExtension(value={"SMAP\nCommManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerImpl\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n72#2,2:238\n1#3:240\n1#3:252\n1642#4,10:241\n1915#4:251\n1916#4:253\n1652#4:254\n*S KotlinDebug\n*F\n+ 1 CommManagerImpl.kt\norg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerImpl\n*L\n82#1:238,2\n82#1:240\n119#1:252\n119#1:241,10\n119#1:251\n119#1:253\n119#1:254\n*E\n"})
public final class CommManagerImpl
implements CommManagerInternal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommCommunicationFacility connection;
    @NotNull
    private final ConcurrentHashMap<String, CommOpenCallback> commOpenCallbacks;
    @NotNull
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<String>> commTargetToIds;
    @NotNull
    private final ConcurrentHashMap<String, CommImpl> commIdToComm;

    public CommManagerImpl(@NotNull CommCommunicationFacility connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.commOpenCallbacks = new ConcurrentHashMap();
        this.commTargetToIds = new ConcurrentHashMap();
        this.commIdToComm = new ConcurrentHashMap();
    }

    @Override
    @Nullable
    public RawMessage getContextMessage() {
        return this.connection.getContextMessage();
    }

    @Override
    @NotNull
    public Comm openComm(@NotNull String target, @NotNull JsonObject data, @NotNull JsonObject metadata, @Nullable List<byte[]> buffers) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        Comm newComm = this.registerNewComm(target, id);
        JsonElement jsonElement = (JsonElement)metadata;
        List list = buffers;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.connection.sendCommOpen(id, target, data, jsonElement, list);
        return newComm;
    }

    @Override
    @Nullable
    public Comm processCommOpen(@NotNull String commId, @NotNull String targetName, @NotNull JsonObject data, @Nullable JsonElement metadata, @NotNull List<byte[]> buffers) {
        Intrinsics.checkNotNullParameter((Object)commId, (String)"commId");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        CommOpenCallback callback = this.commOpenCallbacks.get(targetName);
        if (callback == null) {
            CommCommunicationFacility.sendCommClose$default(this.connection, commId, CommManagerImpl.Companion.commFailureJson("Target " + targetName + " was not registered"), null, null, 12, null);
            return null;
        }
        Comm newComm = this.registerNewComm(targetName, commId);
        try {
            callback.messageReceived(newComm, data, metadata, buffers);
        }
        catch (Throwable e) {
            CommCommunicationFacility.sendCommClose$default(this.connection, commId, CommManagerImpl.Companion.commFailureJson("Unable to crete comm " + commId + " (with target " + targetName + "), exception was thrown: " + ExceptionsKt.stackTraceToString((Throwable)e)), null, null, 12, null);
            this.removeComm(commId);
        }
        return newComm;
    }

    /*
     * WARNING - void declaration
     */
    private final Comm registerNewComm(String target, String id) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.commTargetToIds;
        String key$iv = target;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArrayList default$iv = new CopyOnWriteArrayList();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArrayList commIds = (CopyOnWriteArrayList)object;
        CommImpl newComm = new CommImpl(target, id);
        commIds.add(id);
        ((Map)this.commIdToComm).put(id, newComm);
        return newComm;
    }

    @Override
    public void closeComm(@NotNull String id, @NotNull JsonObject data, @NotNull JsonObject metadata) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        CommImpl commImpl = this.commIdToComm.get(id);
        if (commImpl == null) {
            return;
        }
        CommImpl comm = commImpl;
        Comm.close$default(comm, data, null, true, 2, null);
    }

    @Override
    public void processCommClose(@NotNull String commId, @NotNull JsonObject data, @Nullable JsonElement metadata, @NotNull List<byte[]> buffers) {
        Intrinsics.checkNotNullParameter((Object)commId, (String)"commId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        CommImpl commImpl = this.commIdToComm.get(commId);
        if (commImpl == null) {
            return;
        }
        CommImpl comm = commImpl;
        Comm.close$default(comm, data, null, false, 2, null);
    }

    public final void removeComm(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CommImpl commImpl = this.commIdToComm.get(id);
        if (commImpl == null) {
            return;
        }
        CommImpl comm = commImpl;
        CopyOnWriteArrayList<String> copyOnWriteArrayList = this.commTargetToIds.get(comm.getTarget());
        Intrinsics.checkNotNull(copyOnWriteArrayList);
        CopyOnWriteArrayList<String> commIds = copyOnWriteArrayList;
        commIds.remove(id);
        this.commIdToComm.remove(id);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Comm> getComms(@Nullable String target) {
        Collection collection;
        if (target == null) {
            Collection<CommImpl> collection2 = this.commIdToComm.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            collection = CollectionsKt.toList((Iterable)collection2);
        } else {
            void $this$mapNotNullTo$iv$iv;
            List list = this.commTargetToIds.get(target);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                CommImpl it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.commIdToComm.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        }
        return collection;
    }

    @Override
    public void processCommMessage(@NotNull String commId, @NotNull JsonObject data, @Nullable JsonElement metadata, @NotNull List<byte[]> buffers) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)commId, (String)"commId");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
            CommImpl commImpl = this.commIdToComm.get(commId);
            if (commImpl == null) break block0;
            commImpl.messageReceived(data, metadata, buffers);
        }
    }

    @Override
    public void registerCommTarget(@NotNull String target, @NotNull CommOpenCallback callback) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ((Map)this.commOpenCallbacks).put(target, callback);
    }

    @Override
    public void unregisterCommTarget(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.commOpenCallbacks.remove(target);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\"\u0010!\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\"\u001a\u00020\u0010H\u0016J&\u0010#\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerImpl$CommImpl;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Comm;", "target", "", "id", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerImpl;Ljava/lang/String;Ljava/lang/String;)V", "getTarget", "()Ljava/lang/String;", "getId", "onMessageCallbacks", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommMsgCallback;", "onCloseCallbacks", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommCloseCallback;", "closed", "", "assertOpen", "", "send", "data", "Lkotlinx/serialization/json/JsonObject;", "metadata", "Lkotlinx/serialization/json/JsonElement;", "buffers", "", "", "onMessage", "action", "removeMessageCallback", "callback", "onClose", "removeCloseCallback", "close", "notifyClient", "messageReceived", "protocol"})
    public final class CommImpl
    implements Comm {
        @NotNull
        private final String target;
        @NotNull
        private final String id;
        @NotNull
        private final List<CommMsgCallback> onMessageCallbacks;
        @NotNull
        private final List<CommCloseCallback> onCloseCallbacks;
        private boolean closed;

        public CommImpl(@NotNull String target, String id) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.target = target;
            this.id = id;
            this.onMessageCallbacks = new ArrayList();
            this.onCloseCallbacks = new ArrayList();
        }

        @Override
        @NotNull
        public String getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        private final void assertOpen() {
            if (this.closed) {
                throw new AssertionError((Object)("Comm '" + this.getTarget() + "' has been already closed"));
            }
        }

        @Override
        public void send(@NotNull JsonObject data, @Nullable JsonElement metadata, @Nullable List<byte[]> buffers) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.assertOpen();
            CommCommunicationFacility commCommunicationFacility = CommManagerImpl.this.connection;
            String string = this.getId();
            List list = buffers;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            commCommunicationFacility.sendCommMessage(string, data, metadata, list);
        }

        @Override
        @NotNull
        public CommMsgCallback onMessage(@NotNull CommMsgCallback action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            this.assertOpen();
            this.onMessageCallbacks.add(action);
            return action;
        }

        @Override
        public void removeMessageCallback(@NotNull CommMsgCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.onMessageCallbacks.remove(callback);
        }

        @Override
        @NotNull
        public CommCloseCallback onClose(@NotNull CommCloseCallback action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            this.assertOpen();
            this.onCloseCallbacks.add(action);
            return action;
        }

        @Override
        public void removeCloseCallback(@NotNull CommCloseCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.onCloseCallbacks.remove(callback);
        }

        @Override
        public void close(@NotNull JsonObject data, @Nullable JsonElement metadata, boolean notifyClient) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.assertOpen();
            this.closed = true;
            this.onMessageCallbacks.clear();
            CommManagerImpl.this.removeComm(this.getId());
            for (CommCloseCallback callback : this.onCloseCallbacks) {
                callback.messageReceived(data, metadata);
            }
            if (notifyClient) {
                CommCommunicationFacility.sendCommClose$default(CommManagerImpl.this.connection, this.getId(), data, metadata, null, 8, null);
            }
        }

        public final void messageReceived(@NotNull JsonObject data, @Nullable JsonElement metadata, @NotNull List<byte[]> buffers) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
            if (this.closed) {
                return;
            }
            CommManagerImpl.this.connection.processCallbacks((Function0<Unit>)((Function0)() -> CommImpl.messageReceived$lambda$0(this, data, metadata, buffers)));
        }

        private static final Unit messageReceived$lambda$0(CommImpl this$0, JsonObject $data, JsonElement $metadata, List $buffers) {
            for (CommMsgCallback callback : this$0.onMessageCallbacks) {
                callback.messageReceived($data, $metadata, $buffers);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/comms/CommManagerImpl$Companion;", "", "<init>", "()V", "commFailureJson", "Lkotlinx/serialization/json/JsonObject;", "errorMessage", "", "protocol"})
    public static final class Companion {
        private Companion() {
        }

        private final JsonObject commFailureJson(String errorMessage) {
            return new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)JsonElementKt.JsonPrimitive((String)errorMessage))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

