/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraCollectionTypeBase;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.dialects.oracle.types.OraAssociativeArrayType;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.dialects.oracle.types.OraVaryingArrayType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedType;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a,\u0010\r\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"getSchema", "Lcom/intellij/database/model/DasObject;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "name", "", "getChild", "kind", "Lcom/intellij/database/model/ObjectKind;", "getChildType", "Lcom/intellij/database/types/DasType;", "resolveTypeInSchema", "schemaName", "resolveTypeReference", "dasType", "context", "Lcom/intellij/database/model/basic/BasicElement;", "resolveTypeDefinition", "Lcom/intellij/database/model/DasUserDefinedType;", "packageName", "typeName", "createCollectionType", "typeDef", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "intellij.database.dialects.oracle"})
@JvmName(name="OraModelUtils")
@SourceDebugExtension(value={"SMAP\nOraModelUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraModelUtils.kt\ncom/intellij/database/dialects/oracle/model/OraModelUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n296#2,2:104\n296#2,2:106\n1#3:108\n*S KotlinDebug\n*F\n+ 1 OraModelUtils.kt\ncom/intellij/database/dialects/oracle/model/OraModelUtils\n*L\n28#1:104,2\n30#1:106,2\n*E\n"})
public final class OraModelUtils {
    private static final DasObject getSchema(BasicModel model, String name2) {
        Object v1;
        block1: {
            Collection collection = model.getNameIndex().getObjectsByName(name2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getObjectsByName(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasObject it = (DasObject)element$iv;
                boolean bl = false;
                if (!(it instanceof OraSchema)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final DasObject getChild(DasObject $this$getChild, BasicModel model, ObjectKind kind, String name2) {
        Object v1;
        block1: {
            Collection collection = model.getNameIndex().getObjectsByName(name2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getObjectsByName(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasObject it = (DasObject)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getDasParent(), (Object)$this$getChild) && (kind == null || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)kind, (Object)it.getKind())))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final DasType getChildType(DasObject $this$getChildType, BasicModel model, String name2) {
        for (DasObject obj : model.getNameIndex().getObjectsByNameInsensitive(name2)) {
            if (!Intrinsics.areEqual((Object)obj.getDasParent(), (Object)$this$getChildType)) continue;
            if (obj instanceof DasUserDefinedType) {
                return ((DasUserDefinedType)obj).getSelfDasType();
            }
            if (!(obj instanceof DasTypeAwareObject)) continue;
            return ((DasTypeAwareObject)obj).getDasType();
        }
        return null;
    }

    private static final DasType resolveTypeInSchema(BasicModel model, String name2, String schemaName) {
        DasType dasType;
        DasObject dasObject = OraModelUtils.getSchema(model, schemaName);
        if (dasObject != null && (dasType = OraModelUtils.getChildType(dasObject, model, name2)) != null) {
            DasType it = dasType;
            boolean bl = false;
            return it;
        }
        String expectedSchema = OraTypeSystem.extraPredefinedTypeSchemas.get(name2);
        DasType predefinedType = Intrinsics.areEqual((Object)expectedSchema, (Object)schemaName) ? OraTypeSystem.predefinedTypes.get(name2) : null;
        DasType dasType2 = predefinedType;
        if (dasType2 == null) {
            dasType2 = (DasType)DasUnresolvedType.Companion.of(schemaName + "." + name2);
        }
        return dasType2;
    }

    @NotNull
    public static final DasType resolveTypeReference(@NotNull DasType dasType, @Nullable BasicElement context) {
        Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
        return OraModelUtils.resolveTypeReference(DasTypeUtilsKt.getSchemaName((DasType)dasType), DasTypeUtilsKt.getPackageName((DasType)dasType), DasTypeUtilsKt.getTypeName((DasType)dasType), context);
    }

    @Nullable
    public static final DasUserDefinedType resolveTypeDefinition(@NotNull DasType dasType, @NotNull BasicElement context) {
        Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DasType dasType2 = OraModelUtils.resolveTypeReference(dasType, context);
        DasDefinedType dasDefinedType = dasType2 instanceof DasDefinedType ? (DasDefinedType)dasType2 : null;
        return dasDefinedType != null && (dasDefinedType = dasDefinedType.getTypeClass()) != null ? dasDefinedType.getDefinition() : null;
    }

    @NotNull
    public static final DasType resolveTypeReference(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @Nullable BasicElement context) {
        DasType predefinedType;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String canonicalTypeName = StringUtil.toUpperCase((String)typeName);
        if ((schemaName == null || Intrinsics.areEqual((Object)"SYS", (Object)schemaName) && OraTypeSystem.predefinedSysTypeNames.contains(canonicalTypeName)) && (predefinedType = OraTypeSystem.predefinedTypes.get(canonicalTypeName)) != null) {
            return predefinedType;
        }
        BasicElement basicElement = context;
        if (basicElement == null || (basicElement = basicElement.getModel()) == null) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        BasicElement model = basicElement;
        CharSequence charSequence = schemaName;
        if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)packageName) == null || charSequence.length() == 0)) {
            DasObject dasObject = OraModelUtils.getSchema((BasicModel)model, schemaName);
            if (dasObject == null || (dasObject = OraModelUtils.getChild(dasObject, (BasicModel)model, ObjectKind.PACKAGE, packageName)) == null || (dasObject = OraModelUtils.getChildType(dasObject, (BasicModel)model, typeName)) == null) {
                dasObject = (DasType)DasUnresolvedType.Companion.of(schemaName + "." + packageName + "." + typeName);
            }
            return dasObject;
        }
        CharSequence charSequence2 = schemaName;
        String qualifierName = !(charSequence2 == null || charSequence2.length() == 0) ? schemaName : packageName;
        charSequence2 = qualifierName;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            DasObject container;
            DasObject dasObject;
            DasObject schema = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.SCHEMA, (boolean)false);
            Object object = schema;
            if (object == null || (object = OraModelUtils.getChild(object, (BasicModel)model, ObjectKind.PACKAGE, qualifierName)) == null) {
                DasObject dasObject2 = schema;
                object = dasObject2 != null ? OraModelUtils.getChild(dasObject2, (BasicModel)model, ObjectKind.OBJECT_TYPE, qualifierName) : null;
            }
            if ((dasObject = (container = object)) == null || (dasObject = OraModelUtils.getChildType(dasObject, (BasicModel)model, typeName)) == null) {
                dasObject = OraModelUtils.resolveTypeInSchema((BasicModel)model, typeName, qualifierName);
            }
            return dasObject;
        }
        DasObject dasObject = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.PACKAGE, (boolean)false);
        if (dasObject == null || (dasObject = OraModelUtils.getChildType(dasObject, (BasicModel)model, typeName)) == null) {
            DasObject dasObject3 = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.OBJECT_TYPE, (boolean)false);
            dasObject = dasObject3 != null ? OraModelUtils.getChildType(dasObject3, (BasicModel)model, typeName) : null;
            if (dasObject == null) {
                DasObject dasObject4 = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.SCHEMA, (boolean)false);
                dasObject = dasObject4 != null ? OraModelUtils.getChildType(dasObject4, (BasicModel)model, typeName) : null;
                if (dasObject == null) {
                    dasObject = (DasType)DasUnresolvedType.Companion.of(typeName);
                }
            }
        }
        return dasObject;
    }

    @NotNull
    public static final DasType createCollectionType(@NotNull OraCollectionTypeBase typeDef) {
        DasType dasType;
        Intrinsics.checkNotNullParameter((Object)typeDef, (String)"typeDef");
        OraCollectionTypeKind oraCollectionTypeKind = typeDef.getTypeKind();
        if (oraCollectionTypeKind == null) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        OraCollectionTypeKind kind = oraCollectionTypeKind;
        DasTypeSystemBase typeSystem = DasTypeUtilsKt.getTypeSystem((BasicElement)((BasicElement)typeDef));
        DataType dataType = typeDef.getElementType().toDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
        DasType elementType = DasTypeUtilsKt.resolve((DasType)typeSystem.createDasType(dataType), (DasObject)((DasObject)typeDef));
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                if (!(typeDef instanceof OraPackageCollectionType)) {
                    return (DasType)DasTypeSystemBase.UNKNOWN;
                }
                DataType dataType2 = ((OraPackageCollectionType)typeDef).getIndexElementType().toDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"toDataType(...)");
                DasType indexType = typeSystem.createDasType(dataType2);
                dasType = (DasType)new OraAssociativeArrayType(elementType, indexType);
                break;
            }
            case 2: {
                dasType = (DasType)new OraNestedTableType(elementType);
                break;
            }
            case 3: {
                dasType = (DasType)new OraVaryingArrayType(typeDef.getUpperBound(), elementType);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dasType;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OraCollectionTypeKind.values().length];
            try {
                nArray[OraCollectionTypeKind.ASSOCIATIVE_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraCollectionTypeKind.NESTED_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraCollectionTypeKind.VARIABLE_SIZE_ARRAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

