/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.types;

import com.intellij.database.types.DasCallableType;
import com.intellij.database.types.DasCollectionType;
import com.intellij.database.types.DasSimpleTypeClass;
import com.intellij.database.types.DasType;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u0004H\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraVaryingArrayType;", "Lcom/intellij/database/types/DasCallableType;", "Lcom/intellij/database/types/DasCollectionType;", "maxSize", "", "elementType", "Lcom/intellij/database/types/DasType;", "<init>", "(ILcom/intellij/database/types/DasType;)V", "getMaxSize", "()I", "getElementType", "()Lcom/intellij/database/types/DasType;", "getTypeClass", "Lcom/intellij/database/types/DasSimpleTypeClass;", "innerType", "getInnerType", "getReturnType", "getDescription", "", "transform", "transformer", "Ljava/util/function/Function;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "Companion", "intellij.database.dialects.oracle"})
public final class OraVaryingArrayType
implements DasCallableType,
DasCollectionType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSize;
    @NotNull
    private final DasType elementType;
    @NotNull
    private static final DasSimpleTypeClass TYPE_CLASS = new DasSimpleTypeClass("<varray>");

    public OraVaryingArrayType(int maxSize, @NotNull DasType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        this.maxSize = maxSize;
        this.elementType = elementType;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    @NotNull
    public final DasType getElementType() {
        return this.elementType;
    }

    @NotNull
    public DasSimpleTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @NotNull
    public DasType getInnerType() {
        return this.elementType;
    }

    @NotNull
    public DasType getReturnType() {
        return this.elementType;
    }

    @NotNull
    public String getDescription() {
        return "VARRAY (" + this.maxSize + ") OF " + this.elementType.getDescription();
    }

    @NotNull
    public DasType transform(@NotNull Function<DasType, DasType> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        DasType dasType = transformer.apply(this.elementType);
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"apply(...)");
        return (DasType)new OraVaryingArrayType(this.maxSize, dasType);
    }

    public final int component1() {
        return this.maxSize;
    }

    @NotNull
    public final DasType component2() {
        return this.elementType;
    }

    @NotNull
    public final OraVaryingArrayType copy(int maxSize, @NotNull DasType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        return new OraVaryingArrayType(maxSize, elementType);
    }

    public static /* synthetic */ OraVaryingArrayType copy$default(OraVaryingArrayType oraVaryingArrayType, int n, DasType dasType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = oraVaryingArrayType.maxSize;
        }
        if ((n2 & 2) != 0) {
            dasType = oraVaryingArrayType.elementType;
        }
        return oraVaryingArrayType.copy(n, dasType);
    }

    @NotNull
    public String toString() {
        return "OraVaryingArrayType(maxSize=" + this.maxSize + ", elementType=" + this.elementType + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.maxSize);
        result = result * 31 + this.elementType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OraVaryingArrayType)) {
            return false;
        }
        OraVaryingArrayType oraVaryingArrayType = (OraVaryingArrayType)other;
        if (this.maxSize != oraVaryingArrayType.maxSize) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.elementType, (Object)oraVaryingArrayType.elementType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraVaryingArrayType$Companion;", "", "<init>", "()V", "TYPE_CLASS", "Lcom/intellij/database/types/DasSimpleTypeClass;", "getTYPE_CLASS", "()Lcom/intellij/database/types/DasSimpleTypeClass;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasSimpleTypeClass getTYPE_CLASS() {
            return TYPE_CLASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

