/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraIntervalType;
import com.intellij.database.dialects.oracle.types.OraTimeAwareType;
import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeClassWithSuffix;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.base.SqlCommonTypes;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlBuiltinTypeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0018\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/dialects/oracle/psi/OraBuiltinTypeElementImpl;", "Lcom/intellij/sql/psi/impl/SqlBuiltinTypeElementImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "lengthUnit", "Lcom/intellij/database/model/LengthUnit;", "getLengthUnit", "()Lcom/intellij/database/model/LengthUnit;", "adjustTimeAwareType", "Lcom/intellij/database/dialects/oracle/types/OraTimeAwareType;", "dasType", "adjustYMInterval", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType$YearToMonth;", "adjustDSInterval", "Lcom/intellij/database/dialects/oracle/types/OraIntervalType$DayToSecond;", "parseBuiltinTypeBase", "Lcom/intellij/database/types/DasType;", "adjustType", "Lcom/intellij/database/types/DasBuiltinType;", "Companion", "intellij.database.dialects.oracle"})
public final class OraBuiltinTypeElementImpl
extends SqlBuiltinTypeElementImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public OraBuiltinTypeElementImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    protected LengthUnit getLengthUnit() {
        LengthUnit lengthUnit;
        PsiElement psiElement = this.findPsiChildByType(SqlCommonTypes.SQL_LEFT_PAREN);
        if (psiElement == null) {
            LengthUnit lengthUnit2 = LengthUnit.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit2, (String)"NONE");
            return lengthUnit2;
        }
        PsiElement lParen = psiElement;
        if (PsiTreeUtil.findSiblingForward((PsiElement)lParen, (IElementType)OraTypes.ORA_BYTE, null) != null) {
            LengthUnit lengthUnit3 = LengthUnit.BYTE;
            lengthUnit = lengthUnit3;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit3, (String)"BYTE");
        } else if (PsiTreeUtil.findSiblingForward((PsiElement)lParen, (IElementType)OraTypes.ORA_CHAR, null) != null) {
            LengthUnit lengthUnit4 = LengthUnit.CHAR;
            lengthUnit = lengthUnit4;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit4, (String)"CHAR");
        } else {
            LengthUnit lengthUnit5 = LengthUnit.NONE;
            lengthUnit = lengthUnit5;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit5, (String)"NONE");
        }
        return lengthUnit;
    }

    private final OraTimeAwareType adjustTimeAwareType(OraTimeAwareType dasType) {
        return dasType.copy(dasType.getTypeClass(), this.getIntAttribute());
    }

    private final OraIntervalType.YearToMonth adjustYMInterval(OraIntervalType.YearToMonth dasType) {
        return dasType.copy(this.getIntAttribute());
    }

    private final OraIntervalType.DayToSecond adjustDSInterval(OraIntervalType.DayToSecond dasType) {
        PsiElement secondPsi;
        PsiElement dayKeyword = this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_DAY);
        PsiElement secondKeyword = this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_SECOND);
        PsiElement dayPsi = this.getIntAttributePsi(dayKeyword);
        if (Intrinsics.areEqual((Object)dayPsi, (Object)(secondPsi = this.getIntAttributePsi(secondKeyword)))) {
            dayPsi = null;
        }
        int dayLength = SqlBuiltinTypeElementImpl.parseIntAttribute((PsiElement)dayPsi, (int)-1);
        int secondLength = SqlBuiltinTypeElementImpl.parseIntAttribute((PsiElement)secondPsi, (int)0);
        return dasType.copy(dayLength, secondLength);
    }

    @Nullable
    protected DasType parseBuiltinTypeBase() {
        PsiElement starter = this.getFirstChild();
        IElementType starterType = PsiTreeUtilKt.getElementType((PsiElement)starter);
        Object name2 = null;
        if (Intrinsics.areEqual((Object)starterType, (Object)OraTypes.ORA_INTERVAL)) {
            PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)starter);
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement next = psiElement;
            name2 = starter.getText() + " " + next.getText();
        } else {
            JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)this)).filter(arg_0 -> OraBuiltinTypeElementImpl.parseBuiltinTypeBase$lambda$1(OraBuiltinTypeElementImpl::parseBuiltinTypeBase$lambda$0, arg_0)).takeWhile(arg_0 -> OraBuiltinTypeElementImpl.parseBuiltinTypeBase$lambda$3(OraBuiltinTypeElementImpl::parseBuiltinTypeBase$lambda$2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"takeWhile(...)");
            JBIterable keywords = jBIterable;
            name2 = CollectionsKt.joinToString$default((Iterable)((Iterable)keywords), (CharSequence)" ", null, null, (int)0, null, OraBuiltinTypeElementImpl::parseBuiltinTypeBase$lambda$4, (int)30, null);
        }
        String string = ((String)name2).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        DasType dasType = OraTypeSystem.predefinedTypes.get(string);
        if (dasType instanceof DasBuiltinType && !Intrinsics.areEqual((Object)((DasTypeClass)((DasBuiltinType)dasType).getTypeClass()).getName(), (Object)name2)) {
            dasType = (DasType)DasTypeUtilsKt.withName((DasBuiltinType)((DasBuiltinType)dasType), (String)name2);
        }
        return dasType;
    }

    @NotNull
    protected DasBuiltinType<?> adjustType(@NotNull DasBuiltinType<?> dasType) {
        Intrinsics.checkNotNullParameter(dasType, (String)"dasType");
        DasBuiltinType<?> dasBuiltinType = dasType;
        DasBuiltinType adjustedType = dasBuiltinType instanceof OraTimeAwareType ? (DasBuiltinType)this.adjustTimeAwareType((OraTimeAwareType)dasType) : (dasBuiltinType instanceof OraIntervalType.YearToMonth ? (DasBuiltinType)this.adjustYMInterval((OraIntervalType.YearToMonth)dasType) : (dasBuiltinType instanceof OraIntervalType.DayToSecond ? (DasBuiltinType)this.adjustDSInterval((OraIntervalType.DayToSecond)dasType) : super.adjustType(dasType)));
        IElementType starterType = PsiTreeUtilKt.getElementType((PsiElement)this.getFirstChild());
        if (adjustedType.getTypeClass() instanceof DasBuiltinTypeClassWithSuffix) {
            JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)this)).filter(arg_0 -> OraBuiltinTypeElementImpl.adjustType$lambda$1(OraBuiltinTypeElementImpl::adjustType$lambda$0, arg_0)).skip(starterType == SqlCommonKeywords.SQL_INTERVAL ? 2 : 1);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"skip(...)");
            JBIterable suffixKeywords = jBIterable;
            String suffix = CollectionsKt.joinToString$default((Iterable)((Iterable)suffixKeywords), (CharSequence)" ", null, null, (int)0, null, OraBuiltinTypeElementImpl::adjustType$lambda$2, (int)30, null);
            DasBuiltinType dasBuiltinType2 = adjustedType;
            Intrinsics.checkNotNull((Object)dasBuiltinType2, (String)"null cannot be cast to non-null type com.intellij.database.types.DasBuiltinType<com.intellij.database.types.DasBuiltinTypeClassWithSuffix>");
            adjustedType = DasTypeUtilsKt.withSuffix((DasBuiltinType)dasBuiltinType2, (String)suffix);
        }
        return adjustedType;
    }

    private static final boolean parseBuiltinTypeBase$lambda$0(PsiElement it) {
        if (it instanceof PsiWhiteSpace || it instanceof PsiComment) {
            return false;
        }
        IElementType elementType = PsiTreeUtilKt.getElementType((PsiElement)it);
        return !Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_SYS) && !Intrinsics.areEqual((Object)elementType, (Object)SqlCommonTokens.SQL_PERIOD);
    }

    private static final boolean parseBuiltinTypeBase$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean parseBuiltinTypeBase$lambda$2(PsiElement it) {
        Intrinsics.checkNotNull((Object)it);
        if (OraBuiltinTypeElementImpl.Companion.isCharacterSet(it)) {
            return false;
        }
        IElementType elementType = PsiTreeUtilKt.getElementType((PsiElement)it);
        return Intrinsics.areEqual((Object)elementType, (Object)SqlTokens.SQL_IDENT) || elementType instanceof SqlKeywordTokenType && !Intrinsics.areEqual((Object)elementType, (Object)OraTypes.ORA_WITH);
    }

    private static final boolean parseBuiltinTypeBase$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence parseBuiltinTypeBase$lambda$4(PsiElement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean adjustType$lambda$0(PsiElement it) {
        return PsiTreeUtilKt.getElementType((PsiElement)it) instanceof SqlKeywordTokenType;
    }

    private static final boolean adjustType$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence adjustType$lambda$2(PsiElement it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/dialects/oracle/psi/OraBuiltinTypeElementImpl$Companion;", "", "<init>", "()V", "isCharacterSet", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isCharacterSet(PsiElement element) {
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)OraTypes.ORA_CHARACTER) && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element)), (Object)OraTypes.ORA_SET);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

