/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.api;

import com.intellij.collaboration.api.ServerPath;
import com.intellij.collaboration.util.URIUtilKt;
import com.intellij.openapi.util.NlsSafe;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath$;

@Serializable
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 (2\u00020\u0001:\u0002()B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B%\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\n\u0010\u001b\u001a\u00020\u0005H\u0097\u0080\u0004J\u0014\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0082\u0004J\n\u0010\u001f\u001a\u00020\bH\u0096\u0080\u0004J%\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b'R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "Lcom/intellij/collaboration/api/ServerPath;", "<init>", "()V", "uri", "", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "value", "getUri", "()Ljava/lang/String;", "gqlApiUri", "Ljava/net/URI;", "getGqlApiUri", "()Ljava/net/URI;", "restApiUri", "getRestApiUri", "isDefault", "", "()Z", "toURL", "Ljava/net/URL;", "toURI", "toString", "equals", "other", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_vcs_gitlab", "Companion", "$serializer", "intellij.vcs.gitlab"})
public final class GitLabServerPath
implements ServerPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String uri;
    @NotNull
    private static final GitLabServerPath DEFAULT_SERVER = new GitLabServerPath("https://gitlab.com");

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    public GitLabServerPath() {
        this.uri = "";
    }

    public GitLabServerPath(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = "";
        if (!(((CharSequence)uri).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!StringsKt.endsWith$default((CharSequence)uri, (char)'/', (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        URI validation = URI.create(uri);
        if (!(validation.getScheme() != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = validation.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"http", (boolean)false, (int)2, null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.uri = uri;
    }

    @NotNull
    public final URI getGqlApiUri() {
        return URIUtilKt.resolveRelative((URI)this.toURI(), (String)"api/graphql/");
    }

    @NotNull
    public final URI getRestApiUri() {
        return URIUtilKt.resolveRelative((URI)this.toURI(), (String)"api/v4/");
    }

    public final boolean isDefault() {
        String string = this.toURI().getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        return StringsKt.startsWith((String)string, (String)"gitlab.com", (boolean)true) || StringsKt.contains((CharSequence)this.uri, (CharSequence)"/gitlab.com", (boolean)true);
    }

    @NotNull
    public final URL toURL() {
        return new URL(this.uri + "/");
    }

    @NotNull
    public URI toURI() {
        URI uRI = URI.create(this.uri + "/");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.uri;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabServerPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uri, (Object)((GitLabServerPath)other).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_vcs_gitlab(GitLabServerPath self, CompositeEncoder output, SerialDescriptor serialDesc) {
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.uri, (Object)"")) {
            output.encodeStringElement(serialDesc, 0, self.uri);
        }
    }

    public /* synthetic */ GitLabServerPath(int seen0, String uri, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen0) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.uri = (seen0 & 1) == 0 ? "" : uri;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath$Companion;", "", "<init>", "()V", "DEFAULT_SERVER", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "getDEFAULT_SERVER", "()Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitLabServerPath getDEFAULT_SERVER() {
            return DEFAULT_SERVER;
        }

        @NotNull
        public final KSerializer<GitLabServerPath> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

