/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.data;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabMergeRequestDraftNoteRestDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabNoteRestDTO;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u000f2\u00020\u0001:\u0004\f\r\u000e\u000fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0014\u0010\n\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u0082\u0001\u0002\u0010\u0011\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "", "parentSha", "", "getParentSha", "()Ljava/lang/String;", "sha", "getSha", "filePathBefore", "getFilePathBefore", "filePathAfter", "getFilePathAfter", "WithLine", "Text", "Image", "Companion", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Image;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$WithLine;", "intellij.vcs.gitlab"})
public sealed interface GitLabNotePosition {
    @NotNull
    public static final Companion Companion = org.jetbrains.plugins.gitlab.mergerequest.data.GitLabNotePosition$Companion.$$INSTANCE;

    @NotNull
    public String getParentSha();

    @NotNull
    public String getSha();

    @Nullable
    public String getFilePathBefore();

    @Nullable
    public String getFilePathAfter();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "from", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "position", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabNoteRestDTO$Position;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabMergeRequestDraftNoteRestDTO$Position;", "intellij.vcs.gitlab"})
    @SourceDebugExtension(value={"SMAP\nGitLabNotePosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabNotePosition.kt\norg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n13#2:81\n*S KotlinDebug\n*F\n+ 1 GitLabNotePosition.kt\norg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Companion\n*L\n38#1:81\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger LOG;

        private Companion() {
        }

        @Nullable
        public final GitLabNotePosition from(@NotNull GitLabNoteRestDTO.Position position) {
            GitLabNotePosition gitLabNotePosition;
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            if (position.getBaseSha() == null) {
                LOG.debug("Missing merge base in note position: " + position);
                return null;
            }
            String parentSha = position.getBaseSha();
            String sha = position.getHeadSha();
            if (Intrinsics.areEqual((Object)position.getPositionType(), (Object)"text")) {
                Integer n = position.getOldLine();
                Integer n2 = position.getNewLine();
                gitLabNotePosition = new Text(parentSha, sha, position.getOldPath(), position.getNewPath(), n != null ? Integer.valueOf(n + -1) : null, n2 != null ? Integer.valueOf(n2 + -1) : null);
            } else {
                gitLabNotePosition = new Image(parentSha, sha, position.getOldPath(), position.getNewPath());
            }
            return gitLabNotePosition;
        }

        @Nullable
        public final GitLabNotePosition from(@NotNull GitLabMergeRequestDraftNoteRestDTO.Position position) {
            GitLabNotePosition gitLabNotePosition;
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            if (position.getBaseSha() == null) {
                LOG.debug("Missing merge base in note position: " + position);
                return null;
            }
            String parentSha = position.getBaseSha();
            String string = position.getHeadSha();
            if (string == null) {
                return null;
            }
            String sha = string;
            if (Intrinsics.areEqual((Object)position.getPositionType(), (Object)"text")) {
                Integer n = position.getOldLine();
                Integer n2 = position.getNewLine();
                gitLabNotePosition = new Text(parentSha, sha, position.getOldPath(), position.getNewPath(), n != null ? Integer.valueOf(n + -1) : null, n2 != null ? Integer.valueOf(n2 + -1) : null);
            } else {
                gitLabNotePosition = new Image(parentSha, sha, position.getOldPath(), position.getNewPath());
            }
            return gitLabNotePosition;
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GitLabNotePosition.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Image;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getParentSha", "()Ljava/lang/String;", "getSha", "getFilePathBefore", "getFilePathAfter", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.gitlab"})
    public static final class Image
    implements GitLabNotePosition {
        @NotNull
        private final String parentSha;
        @NotNull
        private final String sha;
        @Nullable
        private final String filePathBefore;
        @Nullable
        private final String filePathAfter;

        public Image(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            this.parentSha = parentSha;
            this.sha = sha;
            this.filePathBefore = filePathBefore;
            this.filePathAfter = filePathAfter;
        }

        @Override
        @NotNull
        public String getParentSha() {
            return this.parentSha;
        }

        @Override
        @NotNull
        public String getSha() {
            return this.sha;
        }

        @Override
        @Nullable
        public String getFilePathBefore() {
            return this.filePathBefore;
        }

        @Override
        @Nullable
        public String getFilePathAfter() {
            return this.filePathAfter;
        }

        @NotNull
        public final String component1() {
            return this.parentSha;
        }

        @NotNull
        public final String component2() {
            return this.sha;
        }

        @Nullable
        public final String component3() {
            return this.filePathBefore;
        }

        @Nullable
        public final String component4() {
            return this.filePathAfter;
        }

        @NotNull
        public final Image copy(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            return new Image(parentSha, sha, filePathBefore, filePathAfter);
        }

        public static /* synthetic */ Image copy$default(Image image, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = image.parentSha;
            }
            if ((n & 2) != 0) {
                string2 = image.sha;
            }
            if ((n & 4) != 0) {
                string3 = image.filePathBefore;
            }
            if ((n & 8) != 0) {
                string4 = image.filePathAfter;
            }
            return image.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Image(parentSha=" + this.parentSha + ", sha=" + this.sha + ", filePathBefore=" + this.filePathBefore + ", filePathAfter=" + this.filePathAfter + ")";
        }

        public int hashCode() {
            int result2 = this.parentSha.hashCode();
            result2 = result2 * 31 + this.sha.hashCode();
            result2 = result2 * 31 + (this.filePathBefore == null ? 0 : this.filePathBefore.hashCode());
            result2 = result2 * 31 + (this.filePathAfter == null ? 0 : this.filePathAfter.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Image)) {
                return false;
            }
            Image image = (Image)other;
            if (!Intrinsics.areEqual((Object)this.parentSha, (Object)image.parentSha)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sha, (Object)image.sha)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filePathBefore, (Object)image.filePathBefore)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filePathAfter, (Object)image.filePathAfter);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012JR\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0083\u0004J\n\u0010!\u001a\u00020\bH\u00d6\u0081\u0004J\n\u0010\"\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\t\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Text;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$WithLine;", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "lineIndexLeft", "", "lineIndexRight", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getParentSha", "()Ljava/lang/String;", "getSha", "getFilePathBefore", "getFilePathAfter", "getLineIndexLeft", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getLineIndexRight", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Text;", "equals", "", "other", "", "hashCode", "toString", "intellij.vcs.gitlab"})
    public static final class Text
    implements WithLine {
        @NotNull
        private final String parentSha;
        @NotNull
        private final String sha;
        @Nullable
        private final String filePathBefore;
        @Nullable
        private final String filePathAfter;
        @Nullable
        private final Integer lineIndexLeft;
        @Nullable
        private final Integer lineIndexRight;

        public Text(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter, @Nullable Integer lineIndexLeft, @Nullable Integer lineIndexRight) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            this.parentSha = parentSha;
            this.sha = sha;
            this.filePathBefore = filePathBefore;
            this.filePathAfter = filePathAfter;
            this.lineIndexLeft = lineIndexLeft;
            this.lineIndexRight = lineIndexRight;
        }

        @Override
        @NotNull
        public String getParentSha() {
            return this.parentSha;
        }

        @Override
        @NotNull
        public String getSha() {
            return this.sha;
        }

        @Override
        @Nullable
        public String getFilePathBefore() {
            return this.filePathBefore;
        }

        @Override
        @Nullable
        public String getFilePathAfter() {
            return this.filePathAfter;
        }

        @Override
        @Nullable
        public Integer getLineIndexLeft() {
            return this.lineIndexLeft;
        }

        @Override
        @Nullable
        public Integer getLineIndexRight() {
            return this.lineIndexRight;
        }

        @NotNull
        public final String component1() {
            return this.parentSha;
        }

        @NotNull
        public final String component2() {
            return this.sha;
        }

        @Nullable
        public final String component3() {
            return this.filePathBefore;
        }

        @Nullable
        public final String component4() {
            return this.filePathAfter;
        }

        @Nullable
        public final Integer component5() {
            return this.lineIndexLeft;
        }

        @Nullable
        public final Integer component6() {
            return this.lineIndexRight;
        }

        @NotNull
        public final Text copy(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter, @Nullable Integer lineIndexLeft, @Nullable Integer lineIndexRight) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            return new Text(parentSha, sha, filePathBefore, filePathAfter, lineIndexLeft, lineIndexRight);
        }

        public static /* synthetic */ Text copy$default(Text text2, String string, String string2, String string3, String string4, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = text2.parentSha;
            }
            if ((n3 & 2) != 0) {
                string2 = text2.sha;
            }
            if ((n3 & 4) != 0) {
                string3 = text2.filePathBefore;
            }
            if ((n3 & 8) != 0) {
                string4 = text2.filePathAfter;
            }
            if ((n3 & 0x10) != 0) {
                n = text2.lineIndexLeft;
            }
            if ((n3 & 0x20) != 0) {
                n2 = text2.lineIndexRight;
            }
            return text2.copy(string, string2, string3, string4, n, n2);
        }

        @NotNull
        public String toString() {
            return "Text(parentSha=" + this.parentSha + ", sha=" + this.sha + ", filePathBefore=" + this.filePathBefore + ", filePathAfter=" + this.filePathAfter + ", lineIndexLeft=" + this.lineIndexLeft + ", lineIndexRight=" + this.lineIndexRight + ")";
        }

        public int hashCode() {
            int result2 = this.parentSha.hashCode();
            result2 = result2 * 31 + this.sha.hashCode();
            result2 = result2 * 31 + (this.filePathBefore == null ? 0 : this.filePathBefore.hashCode());
            result2 = result2 * 31 + (this.filePathAfter == null ? 0 : this.filePathAfter.hashCode());
            result2 = result2 * 31 + (this.lineIndexLeft == null ? 0 : ((Object)this.lineIndexLeft).hashCode());
            result2 = result2 * 31 + (this.lineIndexRight == null ? 0 : ((Object)this.lineIndexRight).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Text)) {
                return false;
            }
            Text text2 = (Text)other;
            if (!Intrinsics.areEqual((Object)this.parentSha, (Object)text2.parentSha)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sha, (Object)text2.sha)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filePathBefore, (Object)text2.filePathBefore)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filePathAfter, (Object)text2.filePathAfter)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lineIndexLeft, (Object)text2.lineIndexLeft)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lineIndexRight, (Object)text2.lineIndexRight);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$WithLine;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "lineIndexLeft", "", "getLineIndexLeft", "()Ljava/lang/Integer;", "lineIndexRight", "getLineIndexRight", "intellij.vcs.gitlab"})
    public static non-sealed interface WithLine
    extends GitLabNotePosition {
        @Nullable
        public Integer getLineIndexLeft();

        @Nullable
        public Integer getLineIndexRight();
    }
}

