/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui;

import com.intellij.collaboration.ui.codereview.issues.IssueIdsProcessorKt;
import com.intellij.collaboration.util.URIUtilKt;
import com.intellij.markdown.utils.CodeFenceSyntaxHighlighterGeneratingProvider;
import com.intellij.markdown.utils.MarkdownToHtmlConverter;
import com.intellij.markdown.utils.lang.CodeBlockHtmlSyntaxHighlighter;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import git4idea.repo.GitRepository;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughDelimiterParser;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.ImageGeneratingProvider;
import org.intellij.markdown.html.LinkGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.XssSafeLinksKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.MathParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabId;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.api.UtilKt;
import org.jetbrains.plugins.gitlab.util.GitLabProjectPath;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00162\u00020\u0001:\t\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0012\u001a\u00020\r2\u000b\u0010\u0013\u001a\u00070\r\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "projectCoordinates", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "projectId", "Lorg/jetbrains/plugins/gitlab/api/GitLabId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Lorg/jetbrains/plugins/gitlab/api/GitLabId;)V", "projectWebUrlBase", "", "projectApiUri", "Ljava/net/URI;", "projectPath", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "convertToHtml", "markdownSource", "Lorg/jetbrains/annotations/NonNls;", "preprocessMergeRequestIds", "Companion", "GitLabFlavourDescriptor", "GitLabImageParser", "GitLabImageWithSettingsGeneratingProvider", "GitLabReferenceLinksGeneratingProvider", "GitLabLinkGeneratingProvider", "DestinationProcessor", "LinkDestinationProcessor", "ImageLinkDestinationProcessor", "intellij.vcs.gitlab"})
@ApiStatus.Internal
public final class GitLabMarkdownToHtmlConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final String projectWebUrlBase;
    @NotNull
    private final URI projectApiUri;
    @NotNull
    private final GitLabProjectPath projectPath;
    @NotNull
    private static final MarkdownElementType MARKDOWN_IMAGE_SETTINGS = new MarkdownElementType("MARKDOWN_IMAGE_SETTINGS", false, 2, null);
    @NotNull
    private static final String UPLOADS_PATH = "/uploads/";
    @NotNull
    public static final String OPEN_FILE_LINK_PREFIX = "glfilelink:";
    @NotNull
    public static final String OPEN_MR_LINK_PREFIX = "glmergerequest:";

    public GitLabMarkdownToHtmlConverter(@NotNull Project project, @NotNull GitRepository repository, @NotNull GitLabProjectCoordinates projectCoordinates, @NotNull GitLabId projectId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)projectCoordinates, (String)"projectCoordinates");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        this.project = project;
        this.repository = repository;
        this.projectWebUrlBase = projectCoordinates.getServerPath() + "/-/project/" + projectId.guessRestId();
        this.projectApiUri = UtilKt.getRestApiUri(projectCoordinates);
        this.projectPath = projectCoordinates.getProjectPath();
    }

    @NotNull
    public final String convertToHtml(@NotNull String markdownSource) {
        Intrinsics.checkNotNullParameter((Object)markdownSource, (String)"markdownSource");
        if (StringsKt.isBlank((CharSequence)markdownSource)) {
            return markdownSource;
        }
        String text2 = StringsKt.replace$default((String)this.preprocessMergeRequestIds(IssueIdsProcessorKt.processIssueIdsMarkdown((Project)this.project, (String)markdownSource)), (String)"\r", (String)"", (boolean)false, (int)4, null);
        GitLabFlavourDescriptor flavourDescriptor = new GitLabFlavourDescriptor(this.repository, this.projectPath, (HtmlSyntaxHighlighter)new CodeBlockHtmlSyntaxHighlighter(this.project), this.projectWebUrlBase, this.projectApiUri);
        return new MarkdownToHtmlConverter((MarkdownFlavourDescriptor)flavourDescriptor).convertMarkdownToHtml(text2, null);
    }

    private final String preprocessMergeRequestIds(String markdownSource) {
        CharSequence charSequence = markdownSource;
        Regex regex = new Regex("(!\\d+)");
        String string = "[$1]($1)";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$Companion;", "", "<init>", "()V", "MARKDOWN_IMAGE_SETTINGS", "Lorg/intellij/markdown/MarkdownElementType;", "UPLOADS_PATH", "", "OPEN_FILE_LINK_PREFIX", "OPEN_MR_LINK_PREFIX", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$DestinationProcessor;", "", "<init>", "()V", "processDestination", "", "linkDestination", "", "intellij.vcs.gitlab"})
    private static abstract class DestinationProcessor {
        @NotNull
        public abstract CharSequence processDestination(@NotNull String var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabFlavourDescriptor;", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "gitRepository", "Lgit4idea/repo/GitRepository;", "projectPath", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "projectWebUrlBase", "", "projectApiUri", "Ljava/net/URI;", "<init>", "(Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;Ljava/lang/String;Ljava/net/URI;)V", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "intellij.vcs.gitlab"})
    private static final class GitLabFlavourDescriptor
    extends GFMFlavourDescriptor {
        @NotNull
        private final GitRepository gitRepository;
        @NotNull
        private final GitLabProjectPath projectPath;
        @NotNull
        private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;
        @NotNull
        private final String projectWebUrlBase;
        @NotNull
        private final URI projectApiUri;
        @NotNull
        private final SequentialParserManager sequentialParserManager;

        public GitLabFlavourDescriptor(@NotNull GitRepository gitRepository, @NotNull GitLabProjectPath projectPath, @NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter, @NotNull String projectWebUrlBase, @NotNull URI projectApiUri) {
            Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"gitRepository");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
            Intrinsics.checkNotNullParameter((Object)projectWebUrlBase, (String)"projectWebUrlBase");
            Intrinsics.checkNotNullParameter((Object)projectApiUri, (String)"projectApiUri");
            super(false, false, false, 7, null);
            this.gitRepository = gitRepository;
            this.projectPath = projectPath;
            this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
            this.projectWebUrlBase = projectWebUrlBase;
            this.projectApiUri = projectApiUri;
            this.sequentialParserManager = new SequentialParserManager(){

                public List<SequentialParser> getParserSequence() {
                    Object[] objectArray = new SequentialParser[7];
                    Object[] objectArray2 = new IElementType[]{MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK};
                    objectArray[0] = new AutolinkParser(CollectionsKt.listOf((Object[])objectArray2));
                    objectArray[1] = new BacktickParser();
                    objectArray[2] = new MathParser();
                    objectArray[3] = new GitLabImageParser();
                    objectArray[4] = new InlineLinkParser();
                    objectArray[5] = new ReferenceLinkParser();
                    objectArray2 = new DelimiterParser[]{new EmphStrongDelimiterParser(), new StrikeThroughDelimiterParser()};
                    objectArray[6] = new EmphasisLikeParser((DelimiterParser[])objectArray2);
                    return CollectionsKt.listOf((Object[])objectArray);
                }
            };
        }

        @NotNull
        public SequentialParserManager getSequentialParserManager() {
            return this.sequentialParserManager;
        }

        @NotNull
        public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
            Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
            Map map2 = super.createHtmlGeneratingProviders(linkMap, baseURI);
            LinkDestinationProcessor linkProcessor = new LinkDestinationProcessor(this.gitRepository, this.projectPath, this.projectWebUrlBase);
            LinkGeneratingProvider referenceLinkProvider = XssSafeLinksKt.makeXssSafe((LinkGeneratingProvider)((LinkGeneratingProvider)new GitLabReferenceLinksGeneratingProvider(linkMap, baseURI, this.getAbsolutizeAnchorLinks(), linkProcessor)), (boolean)this.getUseSafeLinks());
            LinkGeneratingProvider inlineLinkProvider = XssSafeLinksKt.makeXssSafe((LinkGeneratingProvider)new GitLabLinkGeneratingProvider(linkProcessor), (boolean)this.getUseSafeLinks());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.IMAGE, (Object)XssSafeLinksKt.makeXssSafe((LinkGeneratingProvider)((LinkGeneratingProvider)new GitLabImageWithSettingsGeneratingProvider(linkMap, baseURI, this.projectApiUri, this.getAbsolutizeAnchorLinks(), inlineLinkProvider, referenceLinkProvider)), (boolean)this.getUseSafeLinks())), TuplesKt.to((Object)GFMElementTypes.STRIKETHROUGH, (Object)new SimpleInlineTagProvider("strike", 2, -2)), TuplesKt.to((Object)MarkdownElementTypes.CODE_FENCE, (Object)new CodeFenceSyntaxHighlighterGeneratingProvider(this.htmlSyntaxHighlighter)), TuplesKt.to((Object)MarkdownElementTypes.INLINE_LINK, (Object)inlineLinkProvider), TuplesKt.to((Object)MarkdownElementTypes.FULL_REFERENCE_LINK, (Object)referenceLinkProvider), TuplesKt.to((Object)MarkdownElementTypes.SHORT_REFERENCE_LINK, (Object)referenceLinkProvider)};
            return MapsKt.plus((Map)map2, (Map)MapsKt.hashMapOf((Pair[])pairArray));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabImageParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "<init>", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "parseImageSettings", "Lorg/intellij/markdown/parser/sequentialparsers/LocalParsingResult;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "intellij.vcs.gitlab"})
    @SourceDebugExtension(value={"SMAP\nGitLabMarkdownToHtmlConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMarkdownToHtmlConverter.kt\norg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabImageParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,395:1\n1#2:396\n1807#3,3:397\n*S KotlinDebug\n*F\n+ 1 GitLabMarkdownToHtmlConverter.kt\norg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabImageParser\n*L\n200#1:397,3\n*E\n"})
    private static final class GitLabImageParser
    implements SequentialParser {
        @NotNull
        public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
            SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
            RangesListBuilder delegateIndices = new RangesListBuilder();
            TokensCache.Iterator iterator = (TokensCache.Iterator)new TokensCache.RangesListIterator(tokens, rangesToGlue);
            while (iterator.getType() != null) {
                if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.EXCLAMATION_MARK) && Intrinsics.areEqual((Object)iterator.rawLookup(1), (Object)MarkdownTokenTypes.LBRACKET)) {
                    LocalParsingResult link;
                    LocalParsingResult localParsingResult = InlineLinkParser.Companion.parseInlineLink(iterator.advance());
                    if (localParsingResult == null) {
                        localParsingResult = ReferenceLinkParser.Companion.parseReferenceLink(iterator.advance());
                    }
                    if ((link = localParsingResult) != null) {
                        int index = iterator.getIndex();
                        LocalParsingResult parsedSettings = this.parseImageSettings(link.getIteratorPosition().advance(), tokens);
                        LocalParsingResult localParsingResult2 = parsedSettings;
                        if (localParsingResult2 == null || (localParsingResult2 = localParsingResult2.getIteratorPosition()) == null) {
                            localParsingResult2 = link.getIteratorPosition();
                        }
                        LocalParsingResult lastIteratorPosition = localParsingResult2;
                        result2.withNode(new SequentialParser.Node(new IntRange(index, lastIteratorPosition.getIndex() + 1), MarkdownElementTypes.IMAGE)).withOtherParsingResult((SequentialParser.ParsingResult)link);
                        if (parsedSettings != null) {
                            LocalParsingResult it;
                            boolean bl = false;
                            result2.withOtherParsingResult((SequentialParser.ParsingResult)it);
                        }
                        iterator = lastIteratorPosition.advance();
                        continue;
                    }
                }
                delegateIndices.put(iterator.getIndex());
                iterator = iterator.advance();
            }
            return (SequentialParser.ParsingResult)result2.withFurtherProcessing(delegateIndices.get());
        }

        private final LocalParsingResult parseImageSettings(TokensCache.Iterator iterator, TokensCache tokens) {
            block9: {
                if (!Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.TEXT) || iterator.getFirstChar() != '{') break block9;
                TokensCache.Iterator it = iterator;
                while (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL) && it.getType() != null) {
                    block11: {
                        block10: {
                            boolean bl;
                            block8: {
                                if (tokens.getRawCharAt(it.getEnd() - 1) == '}') break block10;
                                Iterable $this$any$iv = (Iterable)RangesKt.until((int)it.getStart(), (int)(it.getEnd() - 1));
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    Iterator iterator2 = $this$any$iv.iterator();
                                    while (iterator2.hasNext()) {
                                        int element$iv;
                                        int it2 = element$iv = ((IntIterator)iterator2).nextInt();
                                        boolean bl2 = false;
                                        if (!(tokens.getRawCharAt(it2) == '}')) continue;
                                        bl = true;
                                        break block8;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) break block11;
                        }
                        IntRange range = new IntRange(iterator.getIndex(), it.getIndex() + 1);
                        return new LocalParsingResult(it, (Collection)CollectionsKt.listOf((Object)new SequentialParser.Node(range, (IElementType)MARKDOWN_IMAGE_SETTINGS)));
                    }
                    it = it.advance();
                }
            }
            return null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060$R\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001bH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabImageWithSettingsGeneratingProvider;", "Lorg/intellij/markdown/html/ImageGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "projectApiUri", "absolutizeAnchorLinks", "", "customInlineLinkProvider", "Lorg/intellij/markdown/html/LinkGeneratingProvider;", "customReferenceLinkProvider", "<init>", "(Lorg/intellij/markdown/parser/LinkMap;Ljava/net/URI;Ljava/net/URI;ZLorg/intellij/markdown/html/LinkGeneratingProvider;Lorg/intellij/markdown/html/LinkGeneratingProvider;)V", "imageLinkProcessor", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$ImageLinkDestinationProcessor;", "getImageLinkProcessor", "()Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$ImageLinkDestinationProcessor;", "inlineLinkImageProvider", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabLinkGeneratingProvider;", "getInlineLinkImageProvider", "()Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabLinkGeneratingProvider;", "referenceLinkImageProvider", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabReferenceLinksGeneratingProvider;", "getReferenceLinkImageProvider", "()Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabReferenceLinksGeneratingProvider;", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "getLinkRenderInfo", "renderLink", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "info", "intellij.vcs.gitlab"})
    private static final class GitLabImageWithSettingsGeneratingProvider
    extends ImageGeneratingProvider {
        @NotNull
        private final LinkGeneratingProvider customInlineLinkProvider;
        @NotNull
        private final LinkGeneratingProvider customReferenceLinkProvider;
        @NotNull
        private final ImageLinkDestinationProcessor imageLinkProcessor;
        @NotNull
        private final GitLabLinkGeneratingProvider inlineLinkImageProvider;
        @NotNull
        private final GitLabReferenceLinksGeneratingProvider referenceLinkImageProvider;

        public GitLabImageWithSettingsGeneratingProvider(@NotNull LinkMap linkMap, @Nullable URI baseURI, @NotNull URI projectApiUri, boolean absolutizeAnchorLinks, @NotNull LinkGeneratingProvider customInlineLinkProvider, @NotNull LinkGeneratingProvider customReferenceLinkProvider) {
            Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
            Intrinsics.checkNotNullParameter((Object)projectApiUri, (String)"projectApiUri");
            Intrinsics.checkNotNullParameter((Object)customInlineLinkProvider, (String)"customInlineLinkProvider");
            Intrinsics.checkNotNullParameter((Object)customReferenceLinkProvider, (String)"customReferenceLinkProvider");
            super(linkMap, baseURI);
            this.customInlineLinkProvider = customInlineLinkProvider;
            this.customReferenceLinkProvider = customReferenceLinkProvider;
            this.imageLinkProcessor = new ImageLinkDestinationProcessor(projectApiUri);
            this.inlineLinkImageProvider = new GitLabLinkGeneratingProvider(this.imageLinkProcessor);
            this.referenceLinkImageProvider = new GitLabReferenceLinksGeneratingProvider(linkMap, baseURI, absolutizeAnchorLinks, this.imageLinkProcessor);
        }

        @NotNull
        public final ImageLinkDestinationProcessor getImageLinkProcessor() {
            return this.imageLinkProcessor;
        }

        @NotNull
        public final GitLabLinkGeneratingProvider getInlineLinkImageProvider() {
            return this.inlineLinkImageProvider;
        }

        @NotNull
        public final GitLabReferenceLinksGeneratingProvider getReferenceLinkImageProvider() {
            return this.referenceLinkImageProvider;
        }

        @Nullable
        public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text2, @NotNull ASTNode node) {
            ASTNode aSTNode;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ASTNode aSTNode2 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.INLINE_LINK);
            if (aSTNode2 != null) {
                ASTNode linkNode = aSTNode2;
                boolean bl = false;
                return this.inlineLinkImageProvider.getRenderInfo(text2, linkNode);
            }
            ASTNode aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.FULL_REFERENCE_LINK);
            if (aSTNode3 == null) {
                aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.SHORT_REFERENCE_LINK);
            }
            if ((aSTNode = aSTNode3) != null) {
                ASTNode linkNode = aSTNode;
                boolean bl = false;
                return this.referenceLinkImageProvider.getRenderInfo(text2, linkNode);
            }
            return null;
        }

        private final LinkGeneratingProvider.RenderInfo getLinkRenderInfo(String text2, ASTNode node) {
            ASTNode aSTNode;
            ASTNode aSTNode2 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.INLINE_LINK);
            if (aSTNode2 != null) {
                ASTNode linkNode = aSTNode2;
                boolean bl = false;
                return this.customInlineLinkProvider.getRenderInfo(text2, linkNode);
            }
            ASTNode aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.FULL_REFERENCE_LINK);
            if (aSTNode3 == null) {
                aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.SHORT_REFERENCE_LINK);
            }
            if ((aSTNode = aSTNode3) != null) {
                ASTNode linkNode = aSTNode;
                boolean bl = false;
                return this.customReferenceLinkProvider.getRenderInfo(text2, linkNode);
            }
            return null;
        }

        public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text2, @NotNull ASTNode node, @NotNull LinkGeneratingProvider.RenderInfo info) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                LinkGeneratingProvider.RenderInfo linkInfo = this.getLinkRenderInfo(text2, node);
                if (linkInfo == null) {
                    super.renderLink(visitor, text2, node, info);
                    return;
                }
                CharSequence[] charSequenceArray = new CharSequence[]{"class=\"custom_image\""};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"p", (CharSequence[])charSequenceArray, (boolean)false, (int)8, null);
                charSequenceArray = new CharSequence[]{"href=\"" + this.makeAbsoluteUrl(linkInfo.getDestination()) + "\""};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"a", (CharSequence[])charSequenceArray, (boolean)false, (int)8, null);
                super.renderLink(visitor, text2, node, info);
                visitor.consumeTagClose((CharSequence)"a");
                visitor.consumeTagClose((CharSequence)"p");
                ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)((IElementType)MARKDOWN_IMAGE_SETTINGS));
                if (aSTNode == null) break block2;
                ASTNode linkNode = aSTNode;
                boolean bl = false;
                CharSequence textInNode = ASTUtilKt.getTextInNode((ASTNode)linkNode, (CharSequence)text2);
                int closingIndex = StringsKt.indexOf$default((CharSequence)textInNode, (char)'}', (int)0, (boolean)false, (int)6, null);
                if (closingIndex > 0 && closingIndex < textInNode.length() - 1) {
                    CharSequence charSequence = textInNode;
                    int n = closingIndex + 1;
                    int n2 = charSequence.length();
                    visitor.consumeHtml((CharSequence)((Object)charSequence.subSequence(n, n2)).toString());
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabLinkGeneratingProvider;", "Lorg/intellij/markdown/html/LinkGeneratingProvider;", "destinationProcessor", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$DestinationProcessor;", "<init>", "(Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$DestinationProcessor;)V", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.vcs.gitlab"})
    @SourceDebugExtension(value={"SMAP\nGitLabMarkdownToHtmlConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMarkdownToHtmlConverter.kt\norg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabLinkGeneratingProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1#2:396\n*E\n"})
    private static final class GitLabLinkGeneratingProvider
    extends LinkGeneratingProvider {
        @NotNull
        private final DestinationProcessor destinationProcessor;

        public GitLabLinkGeneratingProvider(@NotNull DestinationProcessor destinationProcessor) {
            Intrinsics.checkNotNullParameter((Object)destinationProcessor, (String)"destinationProcessor");
            super(null, false);
            this.destinationProcessor = destinationProcessor;
        }

        @Nullable
        public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text2, @NotNull ASTNode node) {
            Object object;
            CharSequence linkText;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_TEXT);
            if (aSTNode == null) {
                return null;
            }
            ASTNode linkTextNode = aSTNode;
            Object object2 = ASTUtilKt.findChildOfType((ASTNode)linkTextNode, (IElementType)MarkdownTokenTypes.TEXT);
            if (object2 != null && (object2 = ASTUtilKt.getTextInNode((ASTNode)object2, (CharSequence)text2)) != null) {
                Object it = object2;
                boolean bl = false;
                v2 = LinkMap.Builder.normalizeTitle((CharSequence)it);
            } else {
                v2 = linkText = null;
            }
            if ((object = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_DESTINATION)) == null || (object = ASTUtilKt.getTextInNode((ASTNode)object, (CharSequence)text2)) == null || (object = object.toString()) == null) {
                object = "";
            }
            Object linkDestination = object;
            CharSequence processedDestination = this.destinationProcessor.processDestination((String)linkDestination);
            if (StringsKt.startsWith$default((CharSequence)((CharSequence)linkDestination), (char)'!', (boolean)false, (int)2, null)) {
                return new LinkGeneratingProvider.RenderInfo(linkTextNode, processedDestination, (CharSequence)linkDestination);
            }
            return new LinkGeneratingProvider.RenderInfo(linkTextNode, processedDestination, linkText);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabReferenceLinksGeneratingProvider;", "Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "resolveAnchors", "", "destinationProcessor", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$DestinationProcessor;", "<init>", "(Lorg/intellij/markdown/parser/LinkMap;Ljava/net/URI;ZLorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$DestinationProcessor;)V", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.vcs.gitlab"})
    @SourceDebugExtension(value={"SMAP\nGitLabMarkdownToHtmlConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMarkdownToHtmlConverter.kt\norg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabReferenceLinksGeneratingProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n296#2,2:396\n296#2,2:398\n231#2,2:400\n1#3:402\n*S KotlinDebug\n*F\n+ 1 GitLabMarkdownToHtmlConverter.kt\norg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$GitLabReferenceLinksGeneratingProvider\n*L\n291#1:396,2\n293#1:398,2\n297#1:400,2\n*E\n"})
    private static final class GitLabReferenceLinksGeneratingProvider
    extends ReferenceLinksGeneratingProvider {
        @NotNull
        private final LinkMap linkMap;
        @NotNull
        private final DestinationProcessor destinationProcessor;

        public GitLabReferenceLinksGeneratingProvider(@NotNull LinkMap linkMap, @Nullable URI baseURI, boolean resolveAnchors, @NotNull DestinationProcessor destinationProcessor) {
            Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
            Intrinsics.checkNotNullParameter((Object)destinationProcessor, (String)"destinationProcessor");
            super(linkMap, baseURI, resolveAnchors);
            this.linkMap = linkMap;
            this.destinationProcessor = destinationProcessor;
        }

        public /* synthetic */ GitLabReferenceLinksGeneratingProvider(LinkMap linkMap, URI uRI, boolean bl, DestinationProcessor destinationProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(linkMap, uRI, bl, destinationProcessor);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text2, @NotNull ASTNode node) {
            String string;
            Object it;
            Object element$iv4;
            ASTNode linkTextNode;
            LinkMap.LinkInfo linkInfo;
            ASTNode label;
            block10: {
                void $this$first$iv;
                Object v3;
                block9: {
                    Object v0;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Iterable $this$firstOrNull$iv = node.getChildren();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            ASTNode it2 = (ASTNode)element$iv2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownElementTypes.LINK_LABEL)) continue;
                            v0 = element$iv2;
                            break block8;
                        }
                        v0 = null;
                    }
                    ASTNode aSTNode = v0;
                    if (aSTNode == null) {
                        return null;
                    }
                    label = aSTNode;
                    LinkMap.LinkInfo linkInfo2 = this.linkMap.getLinkInfo(ASTUtilKt.getTextInNode((ASTNode)label, (CharSequence)text2));
                    if (linkInfo2 == null) {
                        return null;
                    }
                    linkInfo = linkInfo2;
                    Iterable $this$firstOrNull$iv = node.getChildren();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv3 : $this$firstOrNull$iv) {
                        ASTNode it3 = (ASTNode)element$iv3;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it3.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                        v3 = element$iv3;
                        break block9;
                    }
                    v3 = null;
                }
                linkTextNode = v3;
                Iterable $i$f$firstOrNull = linkInfo.getNode().getChildren();
                boolean $i$f$first = false;
                for (Object element$iv4 : $this$first$iv) {
                    it = (ASTNode)element$iv4;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_DESTINATION)) continue;
                    break block10;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            CharSequence destinationText = ASTUtilKt.getTextInNode((ASTNode)((ASTNode)element$iv4), (CharSequence)text2);
            String destination = EntityConverter.INSTANCE.replaceEntities(destinationText, true, true);
            CharSequence processedDestination = this.destinationProcessor.processDestination(destination);
            ASTNode aSTNode = linkTextNode;
            if (aSTNode == null) {
                aSTNode = label;
            }
            CharSequence charSequence = processedDestination;
            CharSequence charSequence2 = linkInfo.getTitle();
            if (charSequence2 != null) {
                it = charSequence2;
                CharSequence charSequence3 = charSequence;
                ASTNode aSTNode2 = aSTNode;
                boolean bl = false;
                String string2 = EntityConverter.INSTANCE.replaceEntities((CharSequence)it, true, true);
                aSTNode = aSTNode2;
                charSequence = charSequence3;
                string = string2;
            } else {
                string = null;
            }
            CharSequence charSequence4 = string;
            CharSequence charSequence5 = charSequence;
            ASTNode aSTNode3 = aSTNode;
            return new LinkGeneratingProvider.RenderInfo(aSTNode3, charSequence5, charSequence4);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$ImageLinkDestinationProcessor;", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$DestinationProcessor;", "projectApiUri", "Ljava/net/URI;", "<init>", "(Ljava/net/URI;)V", "processDestination", "", "linkDestination", "", "intellij.vcs.gitlab"})
    private static final class ImageLinkDestinationProcessor
    extends DestinationProcessor {
        @NotNull
        private final URI projectApiUri;

        public ImageLinkDestinationProcessor(@NotNull URI projectApiUri) {
            Intrinsics.checkNotNullParameter((Object)projectApiUri, (String)"projectApiUri");
            this.projectApiUri = projectApiUri;
        }

        @Override
        @NotNull
        public CharSequence processDestination(@NotNull String linkDestination) {
            Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
            if (StringsKt.startsWith$default((String)linkDestination, (String)GitLabMarkdownToHtmlConverter.UPLOADS_PATH, (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'/'};
                String string = URIUtilKt.resolveRelative((URI)this.projectApiUri, (String)StringsKt.trimStart((String)linkDestination, (char[])cArray)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            return LinkMap.Builder.normalizeDestination((CharSequence)linkDestination, true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$LinkDestinationProcessor;", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter$DestinationProcessor;", "gitRepository", "Lgit4idea/repo/GitRepository;", "projectPath", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "projectWebUrlBase", "", "<init>", "(Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;Ljava/lang/String;)V", "getGitRepository", "()Lgit4idea/repo/GitRepository;", "getProjectPath", "()Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "getProjectWebUrlBase", "()Ljava/lang/String;", "processDestination", "", "linkDestination", "intellij.vcs.gitlab"})
    private static final class LinkDestinationProcessor
    extends DestinationProcessor {
        @NotNull
        private final GitRepository gitRepository;
        @NotNull
        private final GitLabProjectPath projectPath;
        @NotNull
        private final String projectWebUrlBase;

        public LinkDestinationProcessor(@NotNull GitRepository gitRepository, @NotNull GitLabProjectPath projectPath, @NotNull String projectWebUrlBase) {
            Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"gitRepository");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)projectWebUrlBase, (String)"projectWebUrlBase");
            this.gitRepository = gitRepository;
            this.projectPath = projectPath;
            this.projectWebUrlBase = projectWebUrlBase;
        }

        @NotNull
        public final GitRepository getGitRepository() {
            return this.gitRepository;
        }

        @NotNull
        public final GitLabProjectPath getProjectPath() {
            return this.projectPath;
        }

        @NotNull
        public final String getProjectWebUrlBase() {
            return this.projectWebUrlBase;
        }

        @Override
        @NotNull
        public CharSequence processDestination(@NotNull String linkDestination) {
            Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
            if (StringsKt.startsWith$default((CharSequence)linkDestination, (char)'!', (boolean)false, (int)2, null)) {
                String string = linkDestination.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String mrIid = string;
                String mrUrl = GitLabMarkdownToHtmlConverter.OPEN_MR_LINK_PREFIX + mrIid;
                return mrUrl;
            }
            if (StringsKt.startsWith$default((String)linkDestination, (String)"http:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)linkDestination, (String)"https:", (boolean)false, (int)2, null)) {
                return LinkMap.Builder.normalizeDestination((CharSequence)linkDestination, true);
            }
            String fullProjectPath = GitLabProjectPath.fullPath$default(this.projectPath, false, 1, null);
            char[] mrUrl = new char[]{'/'};
            if (StringsKt.startsWith$default((String)StringsKt.trimStart((String)linkDestination, (char[])mrUrl), (String)fullProjectPath, (boolean)false, (int)2, null)) {
                return linkDestination;
            }
            if (StringsKt.startsWith$default((String)linkDestination, (String)GitLabMarkdownToHtmlConverter.UPLOADS_PATH, (boolean)false, (int)2, null)) {
                return this.projectWebUrlBase + linkDestination;
            }
            try {
                Path path = this.gitRepository.getRoot().toNioPath().resolve(StringsKt.replace$default((String)linkDestination, (char)'\\', (char)'/', (boolean)false, (int)4, null));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                String fileDestination = NioPathUtil.toCanonicalPath((Path)path);
                String fileDescription = GitLabMarkdownToHtmlConverter.OPEN_FILE_LINK_PREFIX + fileDestination;
                return fileDescription;
            }
            catch (InvalidPathException invalidPathException) {
                return LinkMap.Builder.normalizeDestination((CharSequence)linkDestination, true);
            }
        }
    }
}

