/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.ui.JsonPathEvaluateView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J,\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0014J\b\u0010\u0019\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateSnippetView;", "Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "expressionHighlightingQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "sourceEditor", "Lcom/intellij/openapi/editor/Editor;", "setSource", "", "json", "", "getJsonFile", "Lcom/intellij/json/psi/JsonFile;", "processKeyBinding", "", "ks", "Ljavax/swing/KeyStroke;", "e", "Ljava/awt/event/KeyEvent;", "condition", "", "pressed", "dispose", "intellij.jsonpath"})
public final class JsonPathEvaluateSnippetView
extends JsonPathEvaluateView {
    @NotNull
    private final MergingUpdateQueue expressionHighlightingQueue;
    @NotNull
    private final Editor sourceEditor;

    public JsonPathEvaluateSnippetView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.expressionHighlightingQueue = new MergingUpdateQueue("JSONPATH_EVALUATE", 1000, true, null, (Disposable)this, null, false, 96, null);
        this.sourceEditor = this.initJsonEditor("source.json", false, EditorKind.UNTYPED);
        BorderLayoutPanel sourcePanel = new BorderLayoutPanel();
        sourcePanel.addToTop((Component)this.getSearchWrapper());
        BorderLayoutPanel sourceWrapper = new BorderLayoutPanel();
        JBLabel sourceLabel = new JBLabel(JsonPathBundle.message("jsonpath.evaluate.input", new Object[0]));
        sourceLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)6));
        sourceWrapper.addToTop((Component)sourceLabel);
        sourceWrapper.addToCenter((Component)this.sourceEditor.getComponent());
        sourcePanel.addToCenter((Component)sourceWrapper);
        final OnePixelSplitter splitter = new OnePixelSplitter(0.5f);
        splitter.setFirstComponent((JComponent)sourcePanel);
        splitter.setSecondComponent((JComponent)this.getResultWrapper());
        this.setContent((JComponent)splitter);
        this.setSource("{\n\n}");
        this.sourceEditor.getComponent().setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        this.sourceEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                expressionHighlightingQueue.queue(Update.Companion.create((Object)this, () -> 1.documentChanged$lambda$0(this)));
            }

            private static final void documentChanged$lambda$0(JsonPathEvaluateSnippetView this$0) {
                this$0.resetExpressionHighlighting();
            }
        });
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow toolWindow = toolWindowManager.getToolWindow("JSONPathEvaluate");
                if (toolWindow != null) {
                    splitter.setOrientation(!toolWindow.getAnchor().isHorizontal());
                }
            }
        });
        this.initToolbar();
    }

    private final void setSource(String json) {
        WriteAction.run(() -> JsonPathEvaluateSnippetView.setSource$lambda$0(this, json));
    }

    @Override
    @Nullable
    protected JsonFile getJsonFile() {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.sourceEditor.getDocument());
        return psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
    }

    protected boolean processKeyBinding(@Nullable KeyStroke ks, @Nullable KeyEvent e, int condition, boolean pressed) {
        if (pressed) {
            Component focusOwner;
            KeyEvent keyEvent = e;
            boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 27 : false;
            if (bl && SwingUtilities.isDescendingFrom(focusOwner = FocusManager.getCurrentManager().getFocusOwner(), this.sourceEditor.getComponent())) {
                this.getSearchTextField().requestFocus();
                return true;
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.sourceEditor);
    }

    private static final void setSource$lambda$0(JsonPathEvaluateSnippetView this$0, String $json) {
        this$0.sourceEditor.getDocument().setText((CharSequence)$json);
    }
}

