/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.legacy;

import com.intellij.openapi.progress.ProgressManager;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LegacyJsonSchemaObjectMerger {
    public static ExclusionAndTypesInfo mergeTypeVariantSets(@Nullable Set<JsonSchemaType> self, @Nullable Set<JsonSchemaType> other) {
        Boolean exclusionType = null;
        if (self == null) {
            return new ExclusionAndTypesInfo(exclusionType, other);
        }
        if (other == null) {
            return new ExclusionAndTypesInfo(exclusionType, self);
        }
        EnumSet<JsonSchemaType> resultSet = EnumSet.noneOf(JsonSchemaType.class);
        for (JsonSchemaType type : self) {
            ProgressManager.checkCanceled();
            ExclusionAndTypeInfo mergedExclusionAndType = LegacyJsonSchemaObjectMerger.computeMergedExclusionAndType(type, null, other);
            if (mergedExclusionAndType != null && mergedExclusionAndType.type != null) {
                resultSet.add(mergedExclusionAndType.type);
            }
            exclusionType = mergedExclusionAndType != null ? mergedExclusionAndType.isValidByExclusion : exclusionType;
        }
        if (resultSet.isEmpty()) {
            return new ExclusionAndTypesInfo(false, other);
        }
        return new ExclusionAndTypesInfo(exclusionType, resultSet);
    }

    @Nullable
    public static ExclusionAndTypeInfo computeMergedExclusionAndType(@Nullable JsonSchemaType selfType, @Nullable JsonSchemaType otherType, @Nullable Set<JsonSchemaType> otherTypeVariants) {
        if (selfType == null) {
            return new ExclusionAndTypeInfo(null, otherType);
        }
        if (otherType == null) {
            if (otherTypeVariants != null && !otherTypeVariants.isEmpty()) {
                EnumSet<JsonSchemaType> filteredVariants = EnumSet.noneOf(JsonSchemaType.class);
                for (JsonSchemaType variant : otherTypeVariants) {
                    ProgressManager.checkCanceled();
                    JsonSchemaType subtype = LegacyJsonSchemaObjectMerger.getSubtypeOfBoth(selfType, variant);
                    if (subtype == null) continue;
                    filteredVariants.add(subtype);
                }
                if (filteredVariants.isEmpty()) {
                    return new ExclusionAndTypeInfo(false, selfType);
                }
                if (filteredVariants.size() == 1) {
                    return new ExclusionAndTypeInfo(null, (JsonSchemaType)((Object)filteredVariants.iterator().next()));
                }
                return null;
            }
            return new ExclusionAndTypeInfo(null, selfType);
        }
        JsonSchemaType subtypeOfBoth = LegacyJsonSchemaObjectMerger.getSubtypeOfBoth(selfType, otherType);
        if (subtypeOfBoth == null) {
            return new ExclusionAndTypeInfo(false, otherType);
        }
        return new ExclusionAndTypeInfo(null, subtypeOfBoth);
    }

    @Nullable
    public static JsonSchemaType getSubtypeOfBoth(@NotNull JsonSchemaType selfType, @NotNull JsonSchemaType otherType) {
        if (selfType == null) {
            LegacyJsonSchemaObjectMerger.$$$reportNull$$$0(0);
        }
        if (otherType == null) {
            LegacyJsonSchemaObjectMerger.$$$reportNull$$$0(1);
        }
        if (otherType == JsonSchemaType._any) {
            return selfType;
        }
        if (selfType == JsonSchemaType._any) {
            return otherType;
        }
        return switch (selfType) {
            case JsonSchemaType._string -> {
                if (otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number) {
                    yield JsonSchemaType._string;
                }
                yield null;
            }
            case JsonSchemaType._number -> {
                if (otherType == JsonSchemaType._integer) {
                    yield JsonSchemaType._integer;
                }
                if (otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number) {
                    yield JsonSchemaType._number;
                }
                yield null;
            }
            case JsonSchemaType._integer -> {
                if (otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number || otherType == JsonSchemaType._integer) {
                    yield JsonSchemaType._integer;
                }
                yield null;
            }
            case JsonSchemaType._object -> {
                if (otherType == JsonSchemaType._object) {
                    yield JsonSchemaType._object;
                }
                yield null;
            }
            case JsonSchemaType._array -> {
                if (otherType == JsonSchemaType._array) {
                    yield JsonSchemaType._array;
                }
                yield null;
            }
            case JsonSchemaType._boolean -> {
                if (otherType == JsonSchemaType._boolean) {
                    yield JsonSchemaType._boolean;
                }
                yield null;
            }
            case JsonSchemaType._null -> {
                if (otherType == JsonSchemaType._null) {
                    yield JsonSchemaType._null;
                }
                yield null;
            }
            case JsonSchemaType._string_number -> {
                if (otherType == JsonSchemaType._integer || otherType == JsonSchemaType._number || otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number) {
                    yield otherType;
                }
                yield null;
            }
            default -> otherType;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "selfType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "otherType";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/light/legacy/LegacyJsonSchemaObjectMerger";
        objectArray[2] = "getSubtypeOfBoth";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ExclusionAndTypesInfo {
        public Boolean isValidByExclusion;
        public Set<JsonSchemaType> types;

        public ExclusionAndTypesInfo(Boolean isValidByExclusion, Set<JsonSchemaType> types) {
            this.isValidByExclusion = isValidByExclusion;
            this.types = types;
        }
    }

    public static class ExclusionAndTypeInfo {
        public Boolean isValidByExclusion;
        public JsonSchemaType type;

        public ExclusionAndTypeInfo(Boolean isValidByExclusion, JsonSchemaType type) {
            this.isValidByExclusion = isValidByExclusion;
            this.type = type;
        }
    }
}

