/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gateway.eel;

import com.intellij.gateway.eel.GatewaySshEelConsts;
import com.intellij.gateway.eel.descriptors.GatewaySshEelDescriptor;
import com.intellij.gateway.eel.descriptors.GatewaySshEelMachine;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelMachineResolver;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/gateway/eel/GatewayTcpEelMachineResolver;", "Lcom/intellij/platform/eel/provider/EelMachineResolver;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/gateway/eel/descriptors/GatewaySshEelMachine;", "resolveEelMachine", "Lcom/intellij/platform/eel/EelMachine;", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "(Lcom/intellij/platform/eel/EelDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getResolvedEelMachine", "resolveEelMachineByInternalName", "internalName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createMachine", "config", "Lcom/intellij/ssh/config/unified/SshConfig;", "intellij.gateway.eel"})
public final class GatewayTcpEelMachineResolver
implements EelMachineResolver {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<String, GatewaySshEelMachine> cache;

    public GatewayTcpEelMachineResolver(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.cache = new ConcurrentHashMap();
    }

    @Nullable
    public Object resolveEelMachine(@NotNull EelDescriptor eelDescriptor, @NotNull Continuation<? super EelMachine> $completion) {
        return this.getResolvedEelMachine(eelDescriptor);
    }

    @Nullable
    public EelMachine getResolvedEelMachine(@NotNull EelDescriptor eelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        GatewaySshEelDescriptor gatewaySshEelDescriptor = eelDescriptor instanceof GatewaySshEelDescriptor ? (GatewaySshEelDescriptor)eelDescriptor : null;
        if (gatewaySshEelDescriptor == null) {
            return null;
        }
        GatewaySshEelDescriptor descriptor = gatewaySshEelDescriptor;
        SshConfig sshConfig = SshConfigManager.getInstance(null).findConfigById(descriptor.getSshConfigId());
        if (sshConfig == null) {
            return null;
        }
        SshConfig config = sshConfig;
        return (EelMachine)this.cache.computeIfAbsent(GatewaySshEelConsts.INSTANCE.internalName(descriptor.getSshConfigId()), arg_0 -> GatewayTcpEelMachineResolver.getResolvedEelMachine$lambda$1(arg_0 -> GatewayTcpEelMachineResolver.getResolvedEelMachine$lambda$0(this, config, arg_0), arg_0));
    }

    @Nullable
    public Object resolveEelMachineByInternalName(@NotNull String internalName, @NotNull Continuation<? super EelMachine> $completion) {
        String string = GatewaySshEelConsts.INSTANCE.extractSshConfigId(internalName);
        if (string == null) {
            return null;
        }
        String sshConfigId = string;
        SshConfig sshConfig = SshConfigManager.getInstance(null).findConfigById(sshConfigId);
        if (sshConfig == null) {
            return null;
        }
        SshConfig config = sshConfig;
        return this.cache.computeIfAbsent(internalName, arg_0 -> GatewayTcpEelMachineResolver.resolveEelMachineByInternalName$lambda$1(arg_0 -> GatewayTcpEelMachineResolver.resolveEelMachineByInternalName$lambda$0(this, config, arg_0), arg_0));
    }

    private final GatewaySshEelMachine createMachine(SshConfig config) {
        return new GatewaySshEelMachine(config, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)("Scope for " + Reflection.getOrCreateKotlinClass(GatewaySshEelMachine.class).getSimpleName() + " " + config.getId()), null, (boolean)false, (int)6, null));
    }

    private static final GatewaySshEelMachine getResolvedEelMachine$lambda$0(GatewayTcpEelMachineResolver this$0, SshConfig $config, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createMachine($config);
    }

    private static final GatewaySshEelMachine getResolvedEelMachine$lambda$1(Function1 $tmp0, Object p0) {
        return (GatewaySshEelMachine)((Object)$tmp0.invoke(p0));
    }

    private static final GatewaySshEelMachine resolveEelMachineByInternalName$lambda$0(GatewayTcpEelMachineResolver this$0, SshConfig $config, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createMachine($config);
    }

    private static final GatewaySshEelMachine resolveEelMachineByInternalName$lambda$1(Function1 $tmp0, Object p0) {
        return (GatewaySshEelMachine)((Object)$tmp0.invoke(p0));
    }
}

