/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.client;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.mediator.client.MediatedProcess;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.BaseOutputReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0014J\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/process/mediator/client/MediatedProcessHandler;", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "process", "Lcom/intellij/execution/process/mediator/client/MediatedProcess;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "<init>", "(Lcom/intellij/execution/process/mediator/client/MediatedProcess;Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "setShouldKillProcessSoftlyWithWinP", "", "shouldKillProcessSoftlyWithWinP", "", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "canKillProcess", "doDestroyProcess", "killProcess", "intellij.execution.process.mediator.client"})
public final class MediatedProcessHandler
extends KillableColoredProcessHandler {
    @NotNull
    private final MediatedProcess process;

    public MediatedProcessHandler(@NotNull MediatedProcess process, @NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super((Process)process, commandLine);
        this.process = process;
        super.setShouldKillProcessSoftlyWithWinP(false);
    }

    public void setShouldKillProcessSoftlyWithWinP(boolean shouldKillProcessSoftlyWithWinP) {
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"BLOCKING");
        return options;
    }

    public boolean canKillProcess() {
        return true;
    }

    protected void doDestroyProcess() {
        boolean gracefulTerminationAttemptedOnWindows;
        boolean bl = gracefulTerminationAttemptedOnWindows = SystemInfo.isWindows && this.shouldKillProcessSoftly() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttemptedOnWindows) {
            this.process.destroy(!this.shouldKillProcessSoftly(), true);
        }
    }

    public void killProcess() {
        this.process.destroy(true, true);
    }
}

